/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.ant.org.eclipse.aether.util.graph.version;

import org.eclipse.aether.internal.ant.org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.ant.org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.ant.org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.internal.ant.org.eclipse.aether.collection.VersionFilter;
import org.eclipse.aether.internal.ant.org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.internal.ant.org.eclipse.aether.util.graph.version.SnapshotVersionFilter;

public final class ContextualSnapshotVersionFilter
implements VersionFilter {
    public static final String CONFIG_PROP_ENABLE = "aether.snapshotFilter";
    private final SnapshotVersionFilter filter = new SnapshotVersionFilter();

    private boolean isEnabled(RepositorySystemSession session) {
        return ConfigUtils.getBoolean(session, false, CONFIG_PROP_ENABLE);
    }

    public void filterVersions(VersionFilter.VersionFilterContext context) {
        if (this.isEnabled(context.getSession())) {
            this.filter.filterVersions(context);
        }
    }

    public VersionFilter deriveChildFilter(DependencyCollectionContext context) {
        if (!this.isEnabled(context.getSession())) {
            Artifact artifact = context.getArtifact();
            if (artifact == null) {
                return this;
            }
            if (artifact.isSnapshot()) {
                return null;
            }
        }
        return this.filter;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return null != obj && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

