/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.ant.tasks;

import java.io.File;
import java.util.HashMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Reference;
import org.eclipse.aether.internal.ant.AntRepoSys;
import org.eclipse.aether.internal.ant.org.apache.maven.model.Model;
import org.eclipse.aether.internal.ant.types.Artifact;
import org.eclipse.aether.internal.ant.types.Artifacts;
import org.eclipse.aether.internal.ant.types.Pom;

public abstract class AbstractDistTask
extends Task {
    private Pom pom;
    private Artifacts artifacts;

    protected void validate() {
        this.getArtifacts().validate(this);
        HashMap<String, File> duplicates = new HashMap<String, File>();
        for (Artifact artifact : this.getArtifacts().getArtifacts()) {
            String key = artifact.getType() + ':' + artifact.getClassifier();
            if ("pom:".equals(key)) {
                throw new BuildException("You must not specify an <artifact> with type=pom, please use the <pom> element instead.");
            }
            if (duplicates.containsKey(key)) {
                throw new BuildException("You must not specify two or more artifacts with the same type (" + artifact.getType() + ") and classifier (" + artifact.getClassifier() + ")");
            }
            duplicates.put(key, artifact.getFile());
            this.validateArtifactGav(artifact);
        }
        Pom defaultPom = AntRepoSys.getInstance(this.getProject()).getDefaultPom();
        if (this.pom == null && defaultPom != null) {
            this.log("Using default POM (" + defaultPom.getCoords() + ")", 2);
            this.pom = defaultPom;
        }
        if (this.pom == null) {
            throw new BuildException("You must specify the <pom file=\"...\"> element to denote the descriptor for the artifacts");
        }
        if (this.pom.getFile() == null) {
            throw new BuildException("You must specify a <pom> element that has the 'file' attribute set");
        }
    }

    private void validateArtifactGav(Artifact artifact) {
        Pom artifactPom = artifact.getPom();
        if (artifactPom != null) {
            String version;
            String aid;
            String gid;
            Model model;
            if (artifactPom.getFile() != null) {
                model = artifactPom.getModel(this);
                gid = model.getGroupId();
                aid = model.getArtifactId();
                version = model.getVersion();
            } else {
                gid = artifactPom.getGroupId();
                aid = artifactPom.getArtifactId();
                version = artifactPom.getVersion();
            }
            model = this.getPom().getModel(this);
            if (!(model.getGroupId().equals(gid) && model.getArtifactId().equals(aid) && model.getVersion().equals(version))) {
                throw new BuildException("Artifact references different pom than it would be installed with: " + artifact.toString());
            }
        }
    }

    protected Artifacts getArtifacts() {
        if (this.artifacts == null) {
            this.artifacts = new Artifacts();
            this.artifacts.setProject(this.getProject());
        }
        return this.artifacts;
    }

    public void addArtifact(Artifact artifact) {
        this.getArtifacts().addArtifact(artifact);
    }

    public void addArtifacts(Artifacts artifacts) {
        this.getArtifacts().addArtifacts(artifacts);
    }

    public void setArtifactsRef(Reference ref) {
        Artifacts artifacts = new Artifacts();
        artifacts.setProject(this.getProject());
        artifacts.setRefid(ref);
        this.getArtifacts().addArtifacts(artifacts);
    }

    protected Pom getPom() {
        if (this.pom == null) {
            return AntRepoSys.getInstance(this.getProject()).getDefaultPom();
        }
        return this.pom;
    }

    public void addPom(Pom pom) {
        if (this.pom != null) {
            throw new BuildException("You must not specify multiple <pom> elements");
        }
        this.pom = pom;
    }

    public void setPomRef(Reference ref) {
        if (this.pom != null) {
            throw new BuildException("You must not specify multiple <pom> elements");
        }
        this.pom = new Pom();
        this.pom.setProject(this.getProject());
        this.pom.setRefid(ref);
    }
}

