/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.ant.tasks;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Resources;
import org.apache.tools.ant.util.FileUtils;
import org.eclipse.aether.internal.ant.AntRepoSys;
import org.eclipse.aether.internal.ant.org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.internal.ant.org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.ant.org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.ant.org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.internal.ant.org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.internal.ant.org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.internal.ant.org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.internal.ant.org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.internal.ant.org.eclipse.aether.util.artifact.SubArtifact;
import org.eclipse.aether.internal.ant.org.eclipse.aether.util.filter.ScopeDependencyFilter;
import org.eclipse.aether.internal.ant.tasks.AbstractResolvingTask;
import org.eclipse.aether.internal.ant.tasks.DependencyGraphLogger;
import org.eclipse.aether.internal.ant.tasks.Layout;
import org.eclipse.aether.internal.ant.types.Dependencies;
import org.eclipse.aether.internal.ant.types.Pom;

public class Resolve
extends AbstractResolvingTask {
    private List<ArtifactConsumer> consumers = new ArrayList<ArtifactConsumer>();
    private boolean failOnMissingAttachments;

    public void setFailOnMissingAttachments(boolean failOnMissingAttachments) {
        this.failOnMissingAttachments = failOnMissingAttachments;
    }

    public Path createPath() {
        Path path = new Path();
        this.consumers.add(path);
        return path;
    }

    public Files createFiles() {
        Files files = new Files();
        this.consumers.add(files);
        return files;
    }

    public Props createProperties() {
        Props props = new Props();
        this.consumers.add(props);
        return props;
    }

    private void validate() {
        for (ArtifactConsumer consumer : this.consumers) {
            consumer.validate();
        }
        Pom pom = AntRepoSys.getInstance(this.getProject()).getDefaultPom();
        if (this.dependencies == null && pom != null) {
            this.log("Using default pom for dependency resolution (" + pom.toString() + ")", 2);
            this.dependencies = new Dependencies();
            this.dependencies.setProject(this.getProject());
            this.getProject().addReference("aether.pom", (Object)pom);
            this.dependencies.setPomRef(new Reference(this.getProject(), "aether.pom"));
        }
        if (this.dependencies == null) {
            throw new BuildException("No <dependencies> set for resolution");
        }
        this.dependencies.validate(this);
    }

    public void execute() throws BuildException {
        this.validate();
        AntRepoSys sys = AntRepoSys.getInstance(this.getProject());
        RepositorySystemSession session = sys.getSession(this, this.localRepository);
        RepositorySystem system = sys.getSystem();
        this.log("Using local repository " + session.getLocalRepository(), 3);
        DependencyNode root = this.collectDependencies().getRoot();
        root.accept(new DependencyGraphLogger(this));
        HashMap<String, Group> groups = new HashMap<String, Group>();
        for (ArtifactConsumer consumer : this.consumers) {
            String classifier = consumer.getClassifier();
            Group group = (Group)groups.get(classifier);
            if (group == null) {
                group = new Group(classifier);
                groups.put(classifier, group);
            }
            group.add(consumer);
        }
        for (Group group : groups.values()) {
            group.createRequests(root);
        }
        this.log("Resolving artifacts", 2);
        for (Group group : groups.values()) {
            List<ArtifactResult> results;
            try {
                results = system.resolveArtifacts(session, group.getRequests());
            }
            catch (ArtifactResolutionException e) {
                if (!group.isAttachments() || this.failOnMissingAttachments) {
                    throw new BuildException("Could not resolve artifacts: " + e.getMessage(), (Throwable)e);
                }
                results = e.getResults();
                for (ArtifactResult result : results) {
                    if (result.isMissing()) {
                        this.log("Ignoring missing attachment " + result.getRequest().getArtifact(), 3);
                        continue;
                    }
                    if (result.isResolved()) continue;
                    throw new BuildException("Could not resolve artifacts: " + e.getMessage(), (Throwable)e);
                }
            }
            group.processResults(results, session);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Group {
        private String classifier;
        private List<ArtifactConsumer> consumers = new ArrayList<ArtifactConsumer>();
        private List<ArtifactRequest> requests = new ArrayList<ArtifactRequest>();

        public Group(String classifier) {
            this.classifier = classifier;
        }

        public boolean isAttachments() {
            return this.classifier != null;
        }

        public void add(ArtifactConsumer consumer) {
            this.consumers.add(consumer);
        }

        public void createRequests(DependencyNode node) {
            this.createRequests(node, new LinkedList<DependencyNode>());
        }

        private void createRequests(DependencyNode node, LinkedList<DependencyNode> parents) {
            if (node.getDependency() != null) {
                for (ArtifactConsumer consumer : this.consumers) {
                    if (!consumer.accept(node, parents)) continue;
                    ArtifactRequest request = new ArtifactRequest(node);
                    if (this.classifier != null) {
                        request.setArtifact(new SubArtifact(request.getArtifact(), this.classifier, "jar"));
                    }
                    this.requests.add(request);
                    break;
                }
            }
            parents.addFirst(node);
            for (DependencyNode child : node.getChildren()) {
                this.createRequests(child, parents);
            }
            parents.removeFirst();
        }

        public List<ArtifactRequest> getRequests() {
            return this.requests;
        }

        public void processResults(List<ArtifactResult> results, RepositorySystemSession session) {
            for (ArtifactResult result : results) {
                if (!result.isResolved()) continue;
                for (ArtifactConsumer consumer : this.consumers) {
                    if (!consumer.accept(result.getRequest().getDependencyNode(), Collections.<DependencyNode>emptyList())) continue;
                    consumer.process(result.getArtifact(), session);
                }
            }
        }
    }

    public class Props
    extends ArtifactConsumer {
        private String prefix;
        private String classifier;

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public void setAttachments(String attachments) {
            if ("sources".equals(attachments)) {
                this.classifier = "*-sources";
            } else if ("javadoc".equals(attachments)) {
                this.classifier = "*-javadoc";
            } else {
                throw new BuildException("The attachment type '" + attachments + "' is not defined, must be one of 'sources' or 'javadoc'");
            }
        }

        public void process(Artifact artifact, RepositorySystemSession session) {
            StringBuilder buffer = new StringBuilder(256);
            if (this.prefix != null && this.prefix.length() > 0) {
                buffer.append(this.prefix);
                if (!this.prefix.endsWith(".")) {
                    buffer.append('.');
                }
            }
            buffer.append(artifact.getGroupId());
            buffer.append(':');
            buffer.append(artifact.getArtifactId());
            buffer.append(':');
            buffer.append(artifact.getExtension());
            if (artifact.getClassifier().length() > 0) {
                buffer.append(':');
                buffer.append(artifact.getClassifier());
            }
            String path = artifact.getFile().getAbsolutePath();
            this.getProject().setProperty(buffer.toString(), path);
        }
    }

    public class Files
    extends ArtifactConsumer {
        private static final String DEFAULT_LAYOUT = "{groupIdDirs}/{artifactId}/{baseVersion}/{artifactId}-{version}-{classifier}.{extension}";
        private String refid;
        private String classifier;
        private File dir;
        private Layout layout;
        private FileSet fileset;
        private Resources resources;

        public void setRefId(String refId) {
            this.refid = refId;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public void setAttachments(String attachments) {
            if ("sources".equals(attachments)) {
                this.classifier = "*-sources";
            } else if ("javadoc".equals(attachments)) {
                this.classifier = "*-javadoc";
            } else {
                throw new BuildException("The attachment type '" + attachments + "' is not defined, must be one of 'sources' or 'javadoc'");
            }
        }

        public void setDir(File dir) {
            this.dir = dir;
            if (dir != null && this.layout == null) {
                this.layout = new Layout(DEFAULT_LAYOUT);
            }
        }

        public void setLayout(String layout) {
            this.layout = new Layout(layout);
        }

        public void validate() {
            if (this.refid == null && this.dir == null) {
                throw new BuildException("You must either specify the 'refid' for the resource collection or a 'dir' to copy the files to");
            }
            if (this.dir == null && this.layout != null) {
                throw new BuildException("You must not specify a 'layout' unless 'dir' is also specified");
            }
        }

        public void process(Artifact artifact, RepositorySystemSession session) {
            if (this.dir != null) {
                if (this.refid != null && this.fileset == null) {
                    this.fileset = new FileSet();
                    this.fileset.setProject(this.getProject());
                    this.fileset.setDir(this.dir);
                    this.getProject().addReference(this.refid, (Object)this.fileset);
                }
                String path = this.layout.getPath(artifact);
                if (this.fileset != null) {
                    this.fileset.createInclude().setName(path);
                }
                File src = artifact.getFile();
                File dst = new File(this.dir, path);
                if (src.lastModified() != dst.lastModified() || src.length() != dst.length()) {
                    try {
                        Resolve.this.log("Copy " + src + " to " + dst, 3);
                        FileUtils.getFileUtils().copyFile(src, dst, null, true, true);
                    }
                    catch (IOException e) {
                        throw new BuildException("Failed to copy artifact file " + src + " to " + dst + ": " + e.getMessage(), (Throwable)e);
                    }
                } else {
                    Resolve.this.log("Omit to copy " + src + " to " + dst + ", seems unchanged", 3);
                }
            } else {
                if (this.resources == null) {
                    this.resources = new Resources();
                    this.resources.setProject(this.getProject());
                    this.getProject().addReference(this.refid, (Object)this.resources);
                }
                FileResource resource = new FileResource(artifact.getFile());
                resource.setBaseDir(session.getLocalRepository().getBasedir());
                resource.setProject(this.getProject());
                this.resources.add((ResourceCollection)resource);
            }
        }
    }

    public class Path
    extends ArtifactConsumer {
        private String refid;
        private org.apache.tools.ant.types.Path path;

        public void setRefId(String refId) {
            this.refid = refId;
        }

        public void validate() {
            if (this.refid == null) {
                throw new BuildException("You must specify the 'refid' for the path");
            }
        }

        public void process(Artifact artifact, RepositorySystemSession session) {
            if (this.path == null) {
                this.path = new org.apache.tools.ant.types.Path(this.getProject());
                this.getProject().addReference(this.refid, (Object)this.path);
            }
            this.path.setLocation(artifact.getFile());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ArtifactConsumer
    extends ProjectComponent {
        private DependencyFilter filter;

        public boolean accept(DependencyNode node, List<DependencyNode> parents) {
            return this.filter == null || this.filter.accept(node, parents);
        }

        public String getClassifier() {
            return null;
        }

        public void validate() {
        }

        public abstract void process(Artifact var1, RepositorySystemSession var2);

        public void setScopes(String scopes) {
            String[] split;
            if (this.filter != null) {
                throw new BuildException("You must not specify both 'scopes' and 'classpath'");
            }
            HashSet<String> included = new HashSet<String>();
            HashSet<String> excluded = new HashSet<String>();
            for (String scope : split = scopes.split("[, ]")) {
                HashSet<String> dst;
                if ((scope = scope.trim()).startsWith("-") || scope.startsWith("!")) {
                    dst = excluded;
                    scope = scope.substring(1);
                } else {
                    dst = included;
                }
                if (scope.length() <= 0) continue;
                dst.add(scope);
            }
            this.filter = new ScopeDependencyFilter(included, excluded);
        }

        public void setClasspath(String classpath) {
            if ("compile".equals(classpath)) {
                this.setScopes("provided,system,compile");
            } else if ("runtime".equals(classpath)) {
                this.setScopes("compile,runtime");
            } else if ("test".equals(classpath)) {
                this.setScopes("provided,system,compile,runtime,test");
            } else {
                throw new BuildException("The classpath '" + classpath + "' is not defined" + ", must be one of 'compile', 'runtime' or 'test'");
            }
        }
    }
}

