/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.ant.types;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Reference;
import org.eclipse.aether.internal.ant.AntRepoSys;
import org.eclipse.aether.internal.ant.ProjectWorkspaceReader;
import org.eclipse.aether.internal.ant.org.apache.maven.model.Model;
import org.eclipse.aether.internal.ant.tasks.RefTask;
import org.eclipse.aether.internal.ant.types.ModelValueExtractor;
import org.eclipse.aether.internal.ant.types.PomPropertyEvaluator;
import org.eclipse.aether.internal.ant.types.PomPropertyHelper;
import org.eclipse.aether.internal.ant.types.RemoteRepositories;
import org.eclipse.aether.internal.ant.types.RemoteRepository;

public class Pom
extends RefTask {
    private Model model;
    private String id;
    private File file;
    private String groupId;
    private String artifactId;
    private String version;
    private String packaging = "jar";
    private RemoteRepositories remoteRepositories;
    private String coords;

    protected Pom getRef() {
        return (Pom)((Object)this.getCheckedRef());
    }

    public void validate() {
        if (this.isReference()) {
            this.getRef().validate();
        } else if (this.file == null) {
            if (this.groupId == null) {
                throw new BuildException("You must specify the 'groupId' for the POM");
            }
            if (this.artifactId == null) {
                throw new BuildException("You must specify the 'artifactId' for the POM");
            }
            if (this.version == null) {
                throw new BuildException("You must specify the 'version' for the POM");
            }
        }
    }

    public void setRefid(Reference ref) {
        if (this.id != null || this.file != null || this.groupId != null || this.artifactId != null || this.version != null) {
            throw this.tooManyAttributes();
        }
        if (this.remoteRepositories != null) {
            throw this.noChildrenAllowed();
        }
        super.setRefid(ref);
    }

    public void setId(String id) {
        this.checkAttributesAllowed();
        this.id = id;
    }

    public File getFile() {
        if (this.isReference()) {
            return this.getRef().getFile();
        }
        return this.file;
    }

    public void setFile(File file) {
        this.checkAttributesAllowed();
        if (this.groupId != null || this.artifactId != null || this.version != null) {
            throw this.ambiguousSource();
        }
        this.file = file;
    }

    public String getGroupId() {
        if (this.isReference()) {
            return this.getRef().getGroupId();
        }
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.checkAttributesAllowed();
        if (this.groupId != null) {
            throw this.ambiguousCoords();
        }
        if (this.file != null) {
            throw this.ambiguousSource();
        }
        this.groupId = groupId;
    }

    public String getArtifactId() {
        if (this.isReference()) {
            return this.getRef().getArtifactId();
        }
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.checkAttributesAllowed();
        if (this.artifactId != null) {
            throw this.ambiguousCoords();
        }
        if (this.file != null) {
            throw this.ambiguousSource();
        }
        this.artifactId = artifactId;
    }

    public String getVersion() {
        if (this.isReference()) {
            return this.getRef().getVersion();
        }
        return this.version;
    }

    public void setVersion(String version) {
        this.checkAttributesAllowed();
        if (this.version != null) {
            throw this.ambiguousCoords();
        }
        if (this.file != null) {
            throw this.ambiguousSource();
        }
        this.version = version;
    }

    public String getCoords() {
        if (this.isReference()) {
            return this.getRef().getCoords();
        }
        return this.coords;
    }

    public void setCoords(String coords) {
        this.checkAttributesAllowed();
        if (this.file != null) {
            throw this.ambiguousSource();
        }
        if (this.groupId != null || this.artifactId != null || this.version != null) {
            throw this.ambiguousCoords();
        }
        Pattern p = Pattern.compile("([^: ]+):([^: ]+):([^: ]+)");
        Matcher m = p.matcher(coords);
        if (!m.matches()) {
            throw new BuildException("Bad POM coordinates, expected format is <groupId>:<artifactId>:<version>");
        }
        this.groupId = m.group(1);
        this.artifactId = m.group(2);
        this.version = m.group(3);
    }

    private BuildException ambiguousCoords() {
        return new BuildException("You must not specify both 'coords' and ('groupId', 'artifactId', 'version')");
    }

    private BuildException ambiguousSource() {
        return new BuildException("You must not specify both 'file' and ('coords', 'groupId', 'artifactId', 'version')");
    }

    public String getPackaging() {
        if (this.isReference()) {
            return this.getRef().getPackaging();
        }
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.checkAttributesAllowed();
        if (this.file != null) {
            throw this.ambiguousSource();
        }
        this.packaging = packaging;
    }

    private RemoteRepositories getRemoteRepos() {
        if (this.remoteRepositories == null) {
            this.remoteRepositories = new RemoteRepositories();
            this.remoteRepositories.setProject(this.getProject());
        }
        return this.remoteRepositories;
    }

    public void addRemoteRepo(RemoteRepository repository) {
        this.getRemoteRepos().addRemoterepo(repository);
    }

    public void addRemoteRepos(RemoteRepositories repositories) {
        this.getRemoteRepos().addRemoterepos(repositories);
    }

    public void setRemoteReposRef(Reference ref) {
        RemoteRepositories repos = new RemoteRepositories();
        repos.setProject(this.getProject());
        repos.setRefid(ref);
        this.getRemoteRepos().addRemoterepos(repos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model getModel(Task task) {
        if (this.isReference()) {
            return this.getRef().getModel(task);
        }
        Pom pom = this;
        synchronized (pom) {
            if (this.model == null && this.file != null) {
                this.model = AntRepoSys.getInstance(this.getProject()).loadModel(task, this.file, true, this.remoteRepositories);
            }
            return this.model;
        }
    }

    public void execute() {
        this.validate();
        if (this.file != null && (this.id == null || AntRepoSys.getInstance(this.getProject()).getDefaultPom() == null)) {
            AntRepoSys.getInstance(this.getProject()).setDefaultPom(this);
        }
        ProjectWorkspaceReader.getInstance().addPom(this);
        Model model = this.getModel(this);
        if (model == null) {
            this.coords = this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getVersion();
            return;
        }
        this.coords = model.getGroupId() + ":" + model.getArtifactId() + ":" + model.getVersion();
        ModelValueExtractor extractor = new ModelValueExtractor(this.id, model, this.getProject());
        PropertyHelper propHelper = PropertyHelper.getPropertyHelper((Project)this.getProject());
        try {
            PomPropertyEvaluator.register(extractor, propHelper);
        }
        catch (LinkageError e) {
            PomPropertyHelper.register(extractor, propHelper);
        }
    }

    public String toString() {
        return this.coords + " (" + super.toString() + ")";
    }
}

