/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf.gef;

import java.util.Collections;
import java.util.List;
import org.eclipse.amp.agf.gef.AGFViewPart;
import org.eclipse.amp.agf.gef.EditPartListener;
import org.eclipse.amp.agf.gef.IModelFactoryProvider;
import org.eclipse.amp.agf.gef.ModelEditPartInput;
import org.eclipse.amp.axf.core.ILifeCycleListener;
import org.eclipse.amp.axf.view.IModelPart;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;

public abstract class EditPartViewPart
extends AGFViewPart {
    private DefaultEditDomain editDomain;
    protected EditPartViewer viewer;
    private EditPartListener rootListener;
    public static double[] ZOOM_LEVELS = new double[]{0.125, 0.25, 0.5, 0.75, 1.0, 1.25, 1.5, 2.0, 2.5, 3.0, 4.0, 6.0, 8.0};
    private ZoomManager zoomer;
    private RootEditPart rootEditPart;

    public EditPartViewPart() {
        this.setEditDomain(new DefaultEditDomain(null));
    }

    public void createPartControl(Composite parent) {
        this.viewer = this.createViewer();
        this.viewer.createControl(parent);
        this.getEditDomain().addViewer(this.viewer);
        if (this.viewer == null) {
            throw new RuntimeException("Viewer is null for: " + (Object)((Object)this));
        }
        super.createPartControl(parent);
    }

    protected EditPartViewer createViewer() {
        return new ScrollingGraphicalViewer();
    }

    public abstract RootEditPart createRoot();

    public void setInput(IEditorInput input) {
        super.setInput(input);
        ModelEditPartInput modelInput = (ModelEditPartInput)input;
        if (input != null) {
            this.rootEditPart = this.createRoot();
            if (this.rootEditPart != null) {
                this.viewer.setRootEditPart(this.rootEditPart);
                this.createZoomer(this.rootEditPart);
            }
            Object contents = null;
            contents = modelInput.getSelection() instanceof IStructuredSelection ? ((StructuredSelection)modelInput.getSelection()).getFirstElement() : this.getModel();
            EditPartFactory factory = modelInput.getFactory();
            if (factory == null) {
                factory = this.createFactory(this.getModel());
            }
            Assert.isNotNull((Object)factory, (String)("Could not find factory for: " + (Object)((Object)this)));
            this.viewer.setEditPartFactory(factory);
            if (factory instanceof ISelectionProvider) {
                ISelectionProvider provider = (ISelectionProvider)factory;
                this.getViewSite().setSelectionProvider(provider);
            }
            this.viewer.setContents(contents);
        }
    }

    protected EditPartFactory createFactory(Object contents) {
        IModelFactoryProvider provider = (IModelFactoryProvider)Platform.getAdapterManager().getAdapter(contents, IModelFactoryProvider.class);
        if (provider == null) {
            throw new RuntimeException("No model factory provider defined for: " + contents);
        }
        return provider.getEditPartFactory(contents);
    }

    protected void createZoomer(RootEditPart rootEditPart) {
        if (rootEditPart instanceof ScalableFreeformRootEditPart) {
            this.zoomer = ((ScalableFreeformRootEditPart)rootEditPart).getZoomManager();
            this.zoomer.setZoomLevels(ZOOM_LEVELS);
            this.zoomer.setZoomLevelContributions(Collections.singletonList(ZoomManager.FIT_ALL));
        }
    }

    public void createModelListeners() {
        super.createModelListeners();
        this.rootListener = new EditPartListener(this);
        this.rootListener.setWaitForUpdate(true);
        this.addModelListener((ILifeCycleListener)this.rootListener);
        if (this.viewer.getContents() instanceof IModelPart) {
            ((IModelPart)this.viewer.getContents()).createModelListeners();
        }
        this.viewer.getControl().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                EditPartViewPart.this.rootListener.endPainting();
            }
        });
    }

    public EditPart getEditPart() {
        List children = this.viewer.getRootEditPart().getChildren();
        if (children.size() > 0) {
            return (EditPart)children.get(0);
        }
        return null;
    }

    public Object getAdapter(Class type) {
        if (type == EditPartViewer.class) {
            return this.getViewer();
        }
        if (type == EditPart.class && this.getViewer() != null) {
            return this.getViewer().getRootEditPart();
        }
        if (type == IFigure.class && this.getViewer() != null) {
            return ((GraphicalEditPart)this.getViewer().getRootEditPart()).getFigure();
        }
        if (type == ZoomManager.class) {
            return this.getZoomer();
        }
        return super.getAdapter(type);
    }

    public EditPartViewer getViewer() {
        return this.viewer;
    }

    public EditPartListener getRootListener() {
        return this.rootListener;
    }

    protected void setEditDomain(DefaultEditDomain ed) {
        this.editDomain = ed;
    }

    protected DefaultEditDomain getEditDomain() {
        return this.editDomain;
    }

    public ZoomManager getZoomer() {
        if (this.rootEditPart instanceof ScalableFreeformRootEditPart) {
            return ((ScalableFreeformRootEditPart)this.rootEditPart).getZoomManager();
        }
        if (this.rootEditPart instanceof ScalableRootEditPart) {
            return ((ScalableRootEditPart)this.rootEditPart).getZoomManager();
        }
        return null;
    }

    public RootEditPart getRootEditPart() {
        return this.rootEditPart;
    }

    protected ISelectionProvider getSelectionProvider() {
        return this.viewer;
    }
}

