/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.abase;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.amp.amf.abase.ICached;
import org.eclipse.amp.amf.abase.IInterpreterFactory;
import org.eclipse.amp.amf.abase.IInterpreterProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLParserPool;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;

public class InterpreterProvider
implements IInterpreterProvider {
    private IInterpreterFactory factory;
    private ResourceSet resourceSet;
    private XMLParserPool parserPool = new XMLParserPoolImpl();
    private Map nameToFeatureMap = new HashMap();

    public InterpreterProvider(IInterpreterFactory factory, ResourceSet resourceSet) {
        this.factory = factory;
        this.resourceSet = resourceSet;
    }

    public InterpreterProvider(IInterpreterFactory factory) {
        this.factory = factory;
    }

    public synchronized Object getInterpreter(URI uri) {
        if (this.resourceSet == null) {
            this.resourceSet = new ResourceSetImpl();
            this.resourceSet.getLoadOptions().put("DEFER_ATTACHMENT", Boolean.TRUE);
            this.resourceSet.getLoadOptions().put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
            this.resourceSet.getLoadOptions().put("USE_DEPRECATED_METHODS", Boolean.TRUE);
            this.resourceSet.getLoadOptions().put("USE_PARSER_POOL", this.parserPool);
            this.resourceSet.getLoadOptions().put("USE_XML_NAME_TO_FEATURE_MAP", this.nameToFeatureMap);
        }
        Resource aparResource = this.resourceSet.getResource(uri, true);
        return this.getInterpreter(aparResource);
    }

    public synchronized Object getInterpreter(IResource aparFileResource) {
        IPath modelPath = ((IFile)aparFileResource).getFullPath();
        URI aparLoc = URI.createPlatformResourceURI((String)modelPath.toString(), (boolean)true);
        return this.getInterpreter(aparLoc);
    }

    public synchronized Object getInterpreter(Resource resource) {
        ICached interpreter = (ICached)this.factory.createInterpreter(resource);
        interpreter.load(resource);
        return interpreter;
    }

    public IInterpreterFactory getFactory() {
        return this.factory;
    }
}

