/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.axf.ide.view;

import org.eclipse.amp.axf.core.IEngine;
import org.eclipse.amp.axf.core.IModel;
import org.eclipse.amp.axf.ide.AXFWorkbenchPlugin;
import org.eclipse.amp.axf.ide.IModelWorkbenchListener;
import org.eclipse.amp.axf.time.ITimeGranularity;
import org.eclipse.amp.axf.time.TimeGranularity;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;

public class ScaleGranularityControl
extends WorkbenchWindowControlContribution
implements IModelWorkbenchListener {
    IEngine engine;
    Scale scale;
    private static int SCALE_MID = 50;
    private static int SCALE_MAX = 110;
    private static int CENTER_RANGE = 5;

    protected Control createControl(Composite parent) {
        this.scale = new Scale(parent, 256);
        this.scale.setMaximum(SCALE_MAX);
        this.scale.setSelection(SCALE_MID);
        this.scale.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ScaleGranularityControl.this.scaleToEngineGranularity();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Thread(){

            public void run() {
                AXFWorkbenchPlugin.getDefault().getManager().getManagerListeners().addModelManagerListener(ScaleGranularityControl.this);
            }
        }.start();
        return this.scale;
    }

    private void scaleToEngineGranularity() {
        if (Math.abs(this.scale.getSelection() - SCALE_MID) > CENTER_RANGE) {
            if (this.scale.getSelection() == this.scale.getMaximum()) {
                this.engine.setUpdateGranularity((ITimeGranularity)TimeGranularity.createFrequencyGranularity((int)Integer.MAX_VALUE));
            } else if (this.scale.getSelection() > SCALE_MID) {
                this.engine.setUpdateGranularity((ITimeGranularity)TimeGranularity.createFrequencyGranularity((int)((this.scale.getSelection() - SCALE_MID - CENTER_RANGE) * 2)));
            } else if (this.scale.getSelection() > 0) {
                this.engine.setUpdateGranularity((ITimeGranularity)TimeGranularity.createDelayGranularity((long)((SCALE_MID - this.scale.getSelection()) * 50)));
            }
        } else if (this.scale.getSelection() != SCALE_MID) {
            this.setScaleSelection(SCALE_MID);
        } else {
            this.engine.setUpdateGranularity((ITimeGranularity)TimeGranularity.DEFAULT_GRANULARITY);
        }
    }

    private void engineGranularityToScale() {
        if (this.engine.getUpdateGranularity() instanceof TimeGranularity) {
            TimeGranularity granularity = (TimeGranularity)this.engine.getUpdateGranularity();
            if (granularity.getUpdateDelay() > 0L) {
                this.setScaleSelection((int)(granularity.getUpdateDelay() / 50L));
            } else if (granularity.getUpdateFrequency() > 1) {
                this.setScaleSelection(granularity.getUpdateFrequency() / 2 + SCALE_MID);
            } else {
                this.setScaleSelection(SCALE_MID);
            }
        }
    }

    protected void setScaleSelection(final int value) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ScaleGranularityControl.this.scale.setSelection(value);
            }
        });
    }

    public void modelActivated(IModel model) {
        if (model != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ScaleGranularityControl.this.scale.setEnabled(true);
                }
            });
            this.engine = model.getEngine();
            this.engineGranularityToScale();
        } else {
            this.engine = null;
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ScaleGranularityControl.this.scale.setEnabled(false);
                }
            });
        }
    }

    public void modelAdded(IModel model) {
    }

    public void modelRemoved(IModel model) {
    }

    public void viewActivated(IWorkbenchPart part) {
    }

    public void viewAdded(IWorkbenchPart part) {
    }

    public void viewRemoved(IWorkbenchPart part) {
    }
}

