/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.shapes;

import java.util.Map;
import org.eclipse.draw3d.Polyline3D;
import org.eclipse.draw3d.RenderContext;
import org.eclipse.draw3d.RenderFragment;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Math3DBase;
import org.eclipse.draw3d.geometry.Math3DCache;
import org.eclipse.draw3d.geometry.ParaxialBoundingBox;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometryext.Plane;
import org.eclipse.draw3d.geometryext.PointList3D;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.draw3d.shapes.Shape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolylineFigureShape
implements Shape {
    private static final float ACCURACY = 10.0f;
    private static final String KEY_HORIZONTAL_BORDER = "horizontal border";
    private static final String KEY_VERTICAL_BORDER = "vertical border";
    private static final String KEY_VISIBLE_BORDER = "visible border";
    private Polyline3D m_figure;

    public PolylineFigureShape(Polyline3D i_figure) {
        if (i_figure == null) {
            throw new NullPointerException("i_figure must not be null");
        }
        this.m_figure = i_figure;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public float getDistance(IVector3f i_rayOrigin, IVector3f i_rayDirection, Map<Object, Object> i_context) {
        PointList3D points = this.m_figure.getPoints3D();
        if (points.size() < 2) {
            return Float.NaN;
        }
        Plane visBorder = this.getVisibleBorder(i_rayOrigin, i_rayDirection, i_context);
        Plane hBorder = this.getHorizontalBorder(i_rayOrigin, i_rayDirection, i_context);
        Plane vBorder = this.getVerticalBorder(i_rayOrigin, i_rayDirection, i_context);
        IVector3f p1 = points.get(0);
        Math3DBase.Side visSide1 = visBorder.getSide(p1);
        Math3DBase.Side hSide1 = null;
        Math3DBase.Side vSide1 = null;
        int i = 1;
        while (i < points.size()) {
            IVector3f p2 = points.get(i);
            Math3DBase.Side visSide2 = visBorder.getSide(p2);
            if (visSide1 != visSide2 || visSide1 == Math3DBase.Side.FRONT) {
                Math3DBase.Side hSide2;
                if (hSide1 == null) {
                    hSide1 = hBorder.getSide(p1);
                }
                if (hSide1 != (hSide2 = hBorder.getSide(p2)) || hSide1 == null && hSide2 == null) {
                    Math3DBase.Side vSide2;
                    if (vSide1 == null) {
                        vSide1 = vBorder.getSide(p1);
                    }
                    if (vSide1 != (vSide2 = vBorder.getSide(p2)) || vSide1 == null && vSide2 == null) {
                        float f;
                        Vector3f intersection = Math3DCache.getVector3f();
                        Vector3f tmp = Math3DCache.getVector3f();
                        try {
                            Plane intersectingBorder = null;
                            intersectingBorder = hSide1 == null && hSide2 == null ? vBorder : hBorder;
                            intersectingBorder.intersectionWithSegment(p1, p2, intersection);
                            Math3D.sub((IVector3f)intersection, (IVector3f)i_rayOrigin, (Vector3f)tmp);
                            float fx = tmp.getX() / i_rayDirection.getX();
                            float fy = tmp.getY() / i_rayDirection.getY();
                            float fz = tmp.getZ() / i_rayDirection.getZ();
                            if (!(Math3D.equals((float)fx, (float)fy, (float)10.0f) && Math3D.equals((float)fx, (float)fz, (float)10.0f) && Math3D.equals((float)fy, (float)fz, (float)10.0f))) {
                                Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{intersection, tmp});
                                return Float.NaN;
                            }
                            f = (fx + fy + fz) / 3.0f;
                        }
                        catch (Throwable throwable) {
                            Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{intersection, tmp});
                            throw throwable;
                        }
                        Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{intersection, tmp});
                        return f;
                    }
                    vSide1 = vSide2;
                } else {
                    vSide1 = null;
                }
                hSide1 = hSide2;
            } else {
                hSide1 = null;
                vSide1 = null;
            }
            visSide1 = visSide2;
            p1 = p2;
            ++i;
        }
        return Float.NaN;
    }

    @Override
    public float getDistanceMeasure(RenderContext i_renderContext) {
        return 0.0f;
    }

    private Plane getHorizontalBorder(IVector3f i_rayOrigin, IVector3f i_rayDirection, Map<Object, Object> i_context) {
        Plane horizontalBorder = null;
        if (i_context != null) {
            horizontalBorder = (Plane)i_context.get(KEY_HORIZONTAL_BORDER);
        }
        if (horizontalBorder == null) {
            Vector3f normal = Math3DCache.getVector3f();
            try {
                Math3D.cross((IVector3f)i_rayOrigin, (IVector3f)i_rayDirection, (Vector3f)normal);
                Math3D.normalise((IVector3f)normal, (Vector3f)normal);
                horizontalBorder = new Plane();
                horizontalBorder.set(i_rayOrigin, (IVector3f)normal);
                if (i_context != null) {
                    i_context.put(KEY_HORIZONTAL_BORDER, horizontalBorder);
                }
            }
            catch (Throwable throwable) {
                Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{normal});
                throw throwable;
            }
            Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{normal});
        }
        return horizontalBorder;
    }

    @Override
    public ParaxialBoundingBox getParaxialBoundingBox(ParaxialBoundingBox o_result) {
        return null;
    }

    @Override
    public RenderFragment.RenderType getRenderType() {
        return RenderFragment.RenderType.getRenderType(this.m_figure.getAlpha(), false);
    }

    private Plane getVerticalBorder(IVector3f i_rayOrigin, IVector3f i_rayDirection, Map<Object, Object> i_context) {
        Plane verticalBorder = null;
        if (i_context != null) {
            verticalBorder = (Plane)i_context.get(KEY_VERTICAL_BORDER);
        }
        if (verticalBorder == null) {
            Vector3f hNormal = Math3DCache.getVector3f();
            Vector3f vNormal = Math3DCache.getVector3f();
            try {
                Plane horizontalBorder = this.getHorizontalBorder(i_rayOrigin, i_rayDirection, i_context);
                horizontalBorder.getNormal(hNormal);
                Math3D.cross((IVector3f)i_rayDirection, (IVector3f)hNormal, (Vector3f)vNormal);
                verticalBorder = new Plane();
                verticalBorder.set(i_rayOrigin, (IVector3f)vNormal);
                if (i_context != null) {
                    i_context.put(KEY_VERTICAL_BORDER, verticalBorder);
                }
            }
            catch (Throwable throwable) {
                Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{hNormal, vNormal});
                throw throwable;
            }
            Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{hNormal, vNormal});
        }
        return verticalBorder;
    }

    private Plane getVisibleBorder(IVector3f i_rayOrigin, IVector3f i_rayDirection, Map<Object, Object> i_context) {
        Plane visibleBorder = null;
        if (i_context != null) {
            visibleBorder = (Plane)i_context.get(KEY_VISIBLE_BORDER);
        }
        if (visibleBorder == null) {
            visibleBorder = new Plane();
            visibleBorder.set(i_rayOrigin, i_rayDirection);
            if (i_context != null) {
                i_context.put(KEY_VISIBLE_BORDER, visibleBorder);
            }
        }
        return visibleBorder;
    }

    @Override
    public void render(RenderContext i_renderContext) {
        PointList3D points = this.m_figure.getPoints3D();
        if (points.size() < 2) {
            return;
        }
        Graphics3D g3d = i_renderContext.getGraphics3D();
        g3d.glColor(this.m_figure.getForegroundColor(), this.m_figure.getAlpha());
        g3d.glLineWidth(this.m_figure.getLineWidth());
        g3d.glBegin(3);
        for (IVector3f point : points) {
            g3d.glVertex3f(point);
        }
        g3d.glEnd();
    }
}

