/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.command;

import java.util.Map;
import org.eclipse.andmore.android.certmanager.command.AbstractHandler2;
import org.eclipse.andmore.android.certmanager.core.KeyStoreUtils;
import org.eclipse.andmore.android.certmanager.core.PasswordProvider;
import org.eclipse.andmore.android.certmanager.exception.InvalidPasswordException;
import org.eclipse.andmore.android.certmanager.exception.KeyStoreManagerException;
import org.eclipse.andmore.android.certmanager.ui.dialogs.importks.ImportEntriesDialog;
import org.eclipse.andmore.android.certmanager.ui.model.IKeyStore;
import org.eclipse.andmore.android.certmanager.ui.model.ITreeNode;
import org.eclipse.andmore.android.common.exception.AndroidException;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.PlatformUI;

public class ImportKeyStoreEntriesHandler
extends AbstractHandler2 {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ITreeNode node = this.getSelection().get(0);
        if (node instanceof IKeyStore) {
            IKeyStore keyStore = (IKeyStore)((Object)node);
            ImportEntriesDialog dialog = new ImportEntriesDialog(PlatformUI.getWorkbench().getModalDialogShellProvider().getShell(), keyStore);
            int diagStatus = dialog.open();
            if (diagStatus == 0) {
                IKeyStore sourceKeyStore = dialog.getKeyStore();
                String sourcePassword = dialog.getPassword();
                Map<String, String> aliases = dialog.getAliases();
                IKeyStore targetKeyStore = dialog.getTargetKeyStore();
                PasswordProvider passwordProvider = targetKeyStore.getPasswordProvider();
                boolean invalidPassword = false;
                do {
                    try {
                        String password = passwordProvider.getKeyStorePassword(true);
                        if (password == null) break;
                        KeyStoreUtils.importKeys(targetKeyStore.getKeyStore(), targetKeyStore.getFile(), targetKeyStore.getType(), password.toCharArray(), sourceKeyStore.getKeyStore(), sourceKeyStore.getFile(), sourcePassword.toCharArray(), aliases);
                        invalidPassword = false;
                        targetKeyStore.forceReload(password.toCharArray(), true);
                    }
                    catch (KeyStoreManagerException e) {
                        EclipseUtils.showErrorDialog((AndroidException)e);
                    }
                    catch (InvalidPasswordException invalidPasswordException) {
                        invalidPassword = true;
                    }
                } while (invalidPassword);
            }
        }
        return null;
    }
}

