/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.core;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import junit.framework.TestCase;
import org.eclipse.andmore.android.certmanager.core.SaveStateManager;
import org.junit.Test;

public class SaveStateManagerTest
extends TestCase {
    private static final String JKS = "JKS";
    SaveStateManager manager;
    File adtKeystoreFile = null;
    File andmoreKeystoreFile = null;

    protected void setUp() throws Exception {
        this.manager = SaveStateManager.getInstance();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.manager.removeEntry(this.adtKeystoreFile);
        this.manager.removeEntry(this.andmoreKeystoreFile);
    }

    @Test
    public void testAddEntryWithoutBackupDate() {
        block4: {
            try {
                this.manager.addEntry(this.adtKeystoreFile, JKS);
                SaveStateManager.ViewStateEntry entry = this.manager.getEntry(this.adtKeystoreFile);
                assert (entry != null && entry.getKeystoreFile() != null && entry.getKeystoreFile().equals(this.adtKeystoreFile));
                assert (entry != null && entry.getKeystoreType() != null && entry.getKeystoreType().equals(JKS));
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testListKeystoresMapped() {
        block3: {
            try {
                this.manager.addEntry(this.adtKeystoreFile, JKS);
                this.manager.addEntry(this.andmoreKeystoreFile, JKS);
                assert (this.manager.getMappedKeystores() != null && this.manager.getMappedKeystores().size() == 2 && this.manager.getMappedKeystores().contains(this.adtKeystoreFile) && this.manager.getMappedKeystores().contains(this.andmoreKeystoreFile));
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testSetBackupDate() {
        block3: {
            try {
                Date date = Calendar.getInstance().getTime();
                this.manager.addEntry(this.adtKeystoreFile, JKS);
                this.manager.setBackupDate(this.adtKeystoreFile, date);
                SaveStateManager.ViewStateEntry entry = this.manager.getEntry(this.adtKeystoreFile);
                assert (entry != null && entry.getBackupDate() != null && entry.getBackupDate().equals(date));
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testIsMappedKeystore() {
        block3: {
            try {
                this.manager.addEntry(this.adtKeystoreFile, JKS);
                boolean result = this.manager.isKeystoreMapped(this.adtKeystoreFile);
                assert (result);
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testRemoveEntry() {
        block4: {
            try {
                this.manager.addEntry(this.andmoreKeystoreFile, JKS);
                assert (this.manager.isKeystoreMapped(this.andmoreKeystoreFile));
                this.manager.removeEntry(this.andmoreKeystoreFile);
                assert (!this.manager.isKeystoreMapped(this.andmoreKeystoreFile));
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }
}

