/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.ui.wizards;

import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.ui.model.KeyStoreNode;
import org.eclipse.andmore.android.certmanager.ui.wizards.CreateKeyWizardPage;
import org.eclipse.andmore.android.certmanager.ui.wizards.CreateKeystorePage;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CreateKeystoreWizard
extends Wizard {
    private final CreateKeystorePage createKeystorePage;
    private final CreateKeyWizardPage createKeyPairPage;
    private static final String WIZARD_BANNER = "icons/wizban/create_keystore_wiz.png";
    private static final String KEYSTORE_KEY_HELP_ID = "org.eclipse.andmore.android.certmanager.keystore-key-help-id";
    private KeyStoreNode createdKeystoreNode;

    public CreateKeystoreWizard() {
        this(null);
    }

    public CreateKeystoreWizard(IJobChangeListener createKeystoreJobListener) {
        this.setWindowTitle(CertificateManagerNLS.CreateKeystoreWizard_CreateNewKeyStore);
        this.setDefaultPageImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android.certmanager", (String)WIZARD_BANNER));
        this.createKeyPairPage = new CreateKeyWizardPage(null, "", createKeystoreJobListener);
        this.createKeystorePage = new CreateKeystorePage(CertificateManagerNLS.CreateKeystoreWizard_CreateNewKeyStore);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), KEYSTORE_KEY_HELP_ID);
    }

    public boolean performFinish() {
        this.createdKeystoreNode = this.createKeystorePage.createKeyStore();
        if (this.createdKeystoreNode != null) {
            this.createKeyPairPage.setKeyStore(this.createdKeystoreNode);
            this.createKeyPairPage.setKeyStorePass(this.createKeystorePage.getPassword());
            this.createKeyPairPage.createKey();
        }
        return this.createdKeystoreNode != null;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.createKeystorePage);
        this.addPage((IWizardPage)this.createKeyPairPage);
    }

    public KeyStoreNode getCreatedKeystoreNode() {
        return this.createdKeystoreNode;
    }

    public String getCreatedKeystorePassword() {
        String result = null;
        if (this.createKeystorePage != null) {
            result = this.createKeystorePage.getPassword();
        }
        return result;
    }
}

