/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.ui.wizards;

import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.ui.wizards.ImportKeystorePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SelectExistentKeystorePage
extends ImportKeystorePage {
    private static final int SMALL_TEXT_SIZE = 64;
    public static final String SELECT_KEYSTORE_HELP_ID = "org.eclipse.andmore.android.certmanager.select_keystore";
    private Button alsoImportIntoView = null;
    private boolean importIntoView = true;
    private Label keystorePasswordLabel;
    private Text keystorePassword;
    private Button savePasswordCheckBox;
    private boolean canSavePassword = false;
    private String password = null;
    private SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            SelectExistentKeystorePage.this.validatePage();
        }
    };

    protected SelectExistentKeystorePage(String pageName) {
        super(pageName);
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setTitle(CertificateManagerNLS.SelectExistentKeystorePage_WizardPageTitle);
        this.setMessage(CertificateManagerNLS.SelectExistentKeystorePage_WizardPageMessage);
        this.keystorePasswordLabel = new Label(this.getMainComposite(), 0);
        this.keystorePasswordLabel.setText(CertificateManagerNLS.SelectExistentKeystorePage_KeystorePasswordLabel);
        this.keystorePassword = new Text(this.getMainComposite(), 0x400804);
        this.keystorePassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.keystorePassword.setTextLimit(64);
        this.keystorePassword.addSelectionListener(this.selectionListener);
        this.keystorePassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectExistentKeystorePage.this.password = SelectExistentKeystorePage.this.keystorePassword.getText();
                SelectExistentKeystorePage.this.validatePage();
            }
        });
        this.savePasswordCheckBox = new Button(this.getMainComposite(), 32);
        this.savePasswordCheckBox.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.savePasswordCheckBox.setText(CertificateManagerNLS.PasswordProvider_SaveThisPassword);
        this.savePasswordCheckBox.setSelection(false);
        this.savePasswordCheckBox.setVisible(this.importIntoView);
        this.savePasswordCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectExistentKeystorePage.this.canSavePassword = SelectExistentKeystorePage.this.savePasswordCheckBox.getSelection();
            }
        });
        this.alsoImportIntoView = new Button(this.getMainComposite(), 32);
        this.alsoImportIntoView.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.alsoImportIntoView.setText(CertificateManagerNLS.SelectExistentKeystorePage_CheckboxText_AlsoImportIntoSigningView);
        this.alsoImportIntoView.setSelection(this.importIntoView);
        this.alsoImportIntoView.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectExistentKeystorePage.this.importIntoView = SelectExistentKeystorePage.this.alsoImportIntoView.getSelection();
                SelectExistentKeystorePage.this.savePasswordCheckBox.setEnabled(SelectExistentKeystorePage.this.importIntoView);
                SelectExistentKeystorePage.this.canSavePassword = SelectExistentKeystorePage.this.importIntoView && SelectExistentKeystorePage.this.savePasswordCheckBox.getSelection();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getMainComposite(), SELECT_KEYSTORE_HELP_ID);
    }

    public boolean needToImportIntoView() {
        return this.importIntoView;
    }

    protected String getPassword() {
        return this.password;
    }

    @Override
    protected boolean validatePage() {
        boolean pageComplete = super.validatePage();
        String infoMessage = CertificateManagerNLS.SelectExistentKeystorePage_WizardPageMessage;
        String errorMessage = null;
        if (pageComplete && !this.keystoreAlreadyMapped) {
            if (this.keystorePassword.getText().isEmpty()) {
                pageComplete = false;
                errorMessage = CertificateManagerNLS.CertificateBlock_EnterPassword_InfoMessage;
            }
            this.setMessage(infoMessage);
            this.setErrorMessage(errorMessage);
            this.setPageComplete(pageComplete);
        }
        return pageComplete;
    }

    protected boolean canSavePassword() {
        return this.canSavePassword;
    }

    @Override
    public boolean importKeystore() {
        return this.importKeystore(this.getPassword(), this.canSavePassword());
    }
}

