/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.ui.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.andmore.android.certmanager.core.KeyStoreManager;
import org.eclipse.andmore.android.certmanager.core.PasswordProvider;
import org.eclipse.andmore.android.certmanager.exception.InvalidPasswordException;
import org.eclipse.andmore.android.certmanager.exception.KeyStoreManagerException;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.ui.model.EntryNode;
import org.eclipse.andmore.android.certmanager.ui.model.IKeyStore;
import org.eclipse.andmore.android.certmanager.ui.model.IKeyStoreEntry;
import org.eclipse.andmore.android.certmanager.ui.model.KeyStoreNode;
import org.eclipse.andmore.android.certmanager.ui.wizards.RemoveExternalPackageSignaturePage;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SignExternalPackagePage
extends RemoveExternalPackageSignaturePage {
    private Label keystoreLabel = null;
    private Label keysLabel = null;
    private Combo keystoreCombo = null;
    private Text keystorePassword = null;
    private Button loadKeystore = null;
    private Button savePassword = null;
    private Combo keysCombo = null;
    private String keyEntryPassword;
    private String keyStoreType;
    PasswordProvider pP = null;
    private IKeyStore initialSelectedKeyStore = null;
    private IKeyStoreEntry initialSelectedEntry = null;
    private IKeyStore selectedKeystore = null;
    SelectionAdapter loadKeysSelectionAdapter = new SelectionAdapter(){

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            SignExternalPackagePage.this.setKeyEntries();
        }
    };

    public SignExternalPackagePage(String pageName, IStructuredSelection selection, IKeyStore selectedIKeyStore, IKeyStoreEntry selectedEntry) {
        super(pageName, selection);
        this.initialSelectedKeyStore = selectedIKeyStore;
        this.initialSelectedEntry = selectedEntry;
        this.setDescription(CertificateManagerNLS.SIGN_EXTERNAL_PKG_WIZARD_DESCRIPTION);
        this.setTitle(CertificateManagerNLS.SIGN_EXTERNAL_PKG_WIZARD_WINDOW_TITLE);
    }

    private HashMap<String, IKeyStore> getAvailableKeystores() {
        HashMap<String, IKeyStore> keystores = new HashMap<String, IKeyStore>();
        Iterator<IKeyStore> iterator = null;
        try {
            if (KeyStoreManager.getInstance() != null && KeyStoreManager.getInstance().getKeyStores() != null) {
                iterator = KeyStoreManager.getInstance().getKeyStores().iterator();
            }
        }
        catch (KeyStoreManagerException e) {
            AndmoreLogger.error(((Object)((Object)this)).getClass(), (String)"Error retrieving keystore list", (Throwable)((Object)e));
        }
        while (iterator != null && iterator.hasNext()) {
            KeyStoreNode keystore = (KeyStoreNode)iterator.next();
            keystores.put(keystore.toString(), keystore);
        }
        return keystores;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String[] getAvailableEntriesForKeystore(IKeyStore keystore) {
        ArrayList<String> entries = new ArrayList<String>();
        if (keystore == null) return entries.toArray(new String[0]);
        this.pP = new PasswordProvider(keystore.getFile());
        String password = null;
        try {
            password = this.pP.getKeyStorePassword(false);
        }
        catch (KeyStoreManagerException e1) {
            AndmoreLogger.error(((Object)((Object)this)).getClass(), (String)"Error retrieving keys from keystore", (Throwable)((Object)e1));
        }
        if (password == null) {
            if (!this.keystorePassword.getText().isEmpty()) {
                password = this.keystorePassword.getText();
            }
        } else {
            try {
                keystore.isPasswordValid(password);
            }
            catch (InvalidPasswordException invalidPasswordException) {
                if (!this.keystorePassword.getText().isEmpty()) {
                    password = this.keystorePassword.getText();
                }
            }
            catch (KeyStoreManagerException keyStoreManagerException) {
                AndmoreLogger.error((String)"This keystore was imported with wrong store type");
            }
        }
        try {
            try {
                List<IKeyStoreEntry> keys;
                if (password != null) {
                    keystore.isPasswordValid(password);
                    if (this.keystorePassword.getText().isEmpty()) {
                        this.keystorePassword.setText(password);
                        this.keystorePassword.setEnabled(false);
                        this.savePassword.setSelection(true);
                        this.savePassword.setEnabled(false);
                        this.loadKeystore.setEnabled(false);
                    }
                }
                if ((keys = keystore.getEntries(password)).size() <= 0) return entries.toArray(new String[0]);
                if (password == null) return entries.toArray(new String[0]);
                this.keyStoreType = keystore.getType();
                Iterator<IKeyStoreEntry> iterator2 = keys.iterator();
                while (iterator2 != null) {
                    if (!iterator2.hasNext()) {
                        return entries.toArray(new String[0]);
                    }
                    EntryNode keyEntry = (EntryNode)iterator2.next();
                    entries.add(keyEntry.getId());
                }
                return entries.toArray(new String[0]);
            }
            catch (KeyStoreManagerException e) {
                AndmoreLogger.error(((Object)((Object)this)).getClass(), (String)"Error retrieving keys from keystore", (Throwable)((Object)e));
                return entries.toArray(new String[0]);
            }
        }
        catch (InvalidPasswordException invalidPasswordException) {
            this.setErrorMessage(CertificateManagerNLS.ConvertKeyStoreTypeDialog_Invalid_Keystore_Pass);
            this.keystorePassword.setText("");
            this.keystorePassword.setFocus();
        }
        return entries.toArray(new String[0]);
    }

    private void setKeyEntries() {
        this.setErrorMessage(null);
        String keystoreSelected = this.keystoreCombo.getItem(this.keystoreCombo.getSelectionIndex());
        this.selectedKeystore = (IKeyStore)this.keystoreCombo.getData(keystoreSelected);
        String[] availableKeys = this.getAvailableEntriesForKeystore(this.selectedKeystore);
        if (availableKeys.length > 0) {
            this.keysCombo.setItems(availableKeys);
            int selectedEntryIndex = 0;
            if (this.initialSelectedEntry != null) {
                selectedEntryIndex = this.keysCombo.indexOf(this.initialSelectedEntry.getAlias());
                this.initialSelectedEntry = null;
            }
            this.keysCombo.select(selectedEntryIndex > 0 ? selectedEntryIndex : 0);
            this.updatePageComplete();
        }
    }

    @Override
    protected void createExtendedArea(Composite parent) {
        GridData layoutData = new GridData(4, 0x1000000, false, false, 1, 1);
        this.keystoreLabel = new Label(parent, 0);
        this.keystoreLabel.setText(CertificateManagerNLS.SIGN_WIZARD_AREA_SIGN_KEYSTORE_LABEL);
        this.keystoreLabel.setLayoutData((Object)layoutData);
        this.keystoreCombo = new Combo(parent, 12);
        layoutData = new GridData(4, 0x1000000, true, false, 3, 1);
        this.keystoreCombo.setLayoutData((Object)layoutData);
        this.keystoreCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SignExternalPackagePage.this.keystorePassword.setText("");
                SignExternalPackagePage.this.keystorePassword.setEnabled(true);
                SignExternalPackagePage.this.savePassword.setSelection(false);
                SignExternalPackagePage.this.savePassword.setEnabled(false);
                SignExternalPackagePage.this.loadKeystore.setEnabled(false);
                SignExternalPackagePage.this.keysCombo.removeAll();
                SignExternalPackagePage.this.setKeyEntries();
                if (SignExternalPackagePage.this.keystorePassword.getEnabled()) {
                    SignExternalPackagePage.this.keystorePassword.setFocus();
                }
                SignExternalPackagePage.this.initialSelectedKeyStore = null;
            }
        });
        Label keystorePasswordLabel = new Label(parent, 0);
        keystorePasswordLabel.setText(CertificateManagerNLS.CreateKeystorePage_KeystorePasswordLabel);
        layoutData = new GridData(4, 0x1000000, false, false, 1, 1);
        keystorePasswordLabel.setLayoutData((Object)layoutData);
        this.keystorePassword = new Text(parent, 0x400800);
        layoutData = new GridData(4, 0x1000000, true, false, 2, 1);
        this.keystorePassword.setLayoutData((Object)layoutData);
        this.keystorePassword.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (SignExternalPackagePage.this.keystorePassword.getText().isEmpty()) {
                    SignExternalPackagePage.this.loadKeystore.setEnabled(false);
                    SignExternalPackagePage.this.savePassword.setEnabled(false);
                } else {
                    SignExternalPackagePage.this.loadKeystore.setEnabled(true);
                    SignExternalPackagePage.this.savePassword.setEnabled(true);
                }
                SignExternalPackagePage.this.keysCombo.removeAll();
                SignExternalPackagePage.this.updatePageComplete();
            }
        });
        this.keystorePassword.addSelectionListener((SelectionListener)this.loadKeysSelectionAdapter);
        this.loadKeystore = new Button(parent, 8);
        layoutData = new GridData(4, 0x1000000, false, false, 1, 1);
        this.loadKeystore.setLayoutData((Object)layoutData);
        this.loadKeystore.setText(CertificateManagerNLS.SIGN_EXTERNAL_PKG_WIZARD_LOAD);
        this.loadKeystore.setEnabled(false);
        this.loadKeystore.addSelectionListener((SelectionListener)this.loadKeysSelectionAdapter);
        this.savePassword = new Button(parent, 32);
        layoutData = new GridData(4, 0x1000000, false, false, 4, 1);
        this.savePassword.setLayoutData((Object)layoutData);
        this.savePassword.setText(CertificateManagerNLS.PasswordProvider_SaveThisPassword);
        this.savePassword.setEnabled(false);
        this.savePassword.setSelection(false);
        this.keysLabel = new Label(parent, 0);
        this.keysLabel.setText(CertificateManagerNLS.SIGN_WIZARD_AREA_SIGN_KEYS_LABEL);
        layoutData = new GridData(4, 0x1000000, false, false, 1, 1);
        this.keysLabel.setLayoutData((Object)layoutData);
        this.keysCombo = new Combo(parent, 12);
        layoutData = new GridData(4, 0x1000000, true, false, 3, 1);
        this.keysCombo.setLayoutData((Object)layoutData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.andmore.android.certmanager.sign_external_pkg_wiz");
        this.populateKeyStoreCombo();
    }

    @Override
    protected void createPackageTreeLabel() {
        Label packagesLabel = new Label(this.mainComposite, 0);
        packagesLabel.setText(CertificateManagerNLS.SignExternalPackagePage_Package_Tree_Label);
        GridData layoutData = new GridData(4, 0x1000000, false, false, 4, 1);
        packagesLabel.setLayoutData((Object)layoutData);
    }

    protected void populateKeyStoreCombo() {
        HashMap<String, IKeyStore> availableKeystores = this.getAvailableKeystores();
        if (availableKeystores.size() > 0) {
            for (String keystoreKey : availableKeystores.keySet()) {
                IKeyStore newKeystore = availableKeystores.get(keystoreKey);
                this.keystoreCombo.setData(keystoreKey, (Object)availableKeystores.get(keystoreKey));
                this.keystoreCombo.add(newKeystore.toString());
                if (this.initialSelectedKeyStore == null || !this.initialSelectedKeyStore.equals(newKeystore)) continue;
                this.keystoreCombo.select(this.keystoreCombo.indexOf(newKeystore.toString()));
                this.setKeyEntries();
            }
            if (this.initialSelectedKeyStore == null) {
                this.keystoreCombo.select(0);
            }
        }
    }

    public IKeyStoreEntry getSelectedKeyEntry() {
        IKeyStoreEntry result = null;
        try {
            result = this.selectedKeystore.getEntry(this.keysCombo.getItem(this.keysCombo.getSelectionIndex()), this.getKeystorePassword());
        }
        catch (KeyStoreManagerException keyStoreManagerException) {
            AndmoreLogger.error((String)"Could not retrieve entry while signing package");
        }
        catch (InvalidPasswordException invalidPasswordException) {
            AndmoreLogger.error((String)"Invalid password while retrieving entry to sign package");
        }
        return result;
    }

    public IKeyStore getSelectedKeyStore() {
        return this.selectedKeystore;
    }

    public String getKeystorePassword() {
        return this.keystorePassword.getText();
    }

    public String getKeyEntryPassword() {
        try {
            this.keyEntryPassword = this.pP.getPassword(this.keysCombo.getItem(this.keysCombo.getSelectionIndex()), true);
        }
        catch (KeyStoreManagerException e) {
            AndmoreLogger.error(((Object)((Object)this)).getClass(), (String)"Error retrieving keys entry password", (Throwable)((Object)e));
        }
        return this.keyEntryPassword;
    }

    public PasswordProvider getPasswordProvider() {
        return this.pP;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    @Override
    public void updatePageComplete() {
        String messageAux;
        super.updatePageComplete();
        int severity = this.getMessageType();
        String string = messageAux = severity == 0 ? null : this.getMessage();
        if (messageAux == null) {
            if (this.keystoreCombo == null || this.keystoreCombo.getItemCount() <= 0 || this.keystoreCombo.getItem(this.keystoreCombo.getSelectionIndex()) == null || this.keystoreCombo.getItem(this.keystoreCombo.getSelectionIndex()).equalsIgnoreCase("") || this.keysCombo == null || this.keysCombo.getItemCount() <= 0 || this.keysCombo.getItem(this.keysCombo.getSelectionIndex()) == null || this.keysCombo.getItem(this.keysCombo.getSelectionIndex()).equalsIgnoreCase("")) {
                messageAux = CertificateManagerNLS.SIGN_EXTERNAL_PKG_WIZARD_NO_CERTIFICATE_ERROR;
                severity = 3;
            }
            if (messageAux == null) {
                messageAux = CertificateManagerNLS.SIGN_EXTERNAL_PKG_WIZARD_DESCRIPTION;
                severity = 0;
            }
            this.setMessage(messageAux, severity);
            this.setPageComplete(severity == 0);
        }
    }

    public boolean getSavePasswordSelection() {
        return this.savePassword.getSelection();
    }
}

