/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.codesnippets;

import org.eclipse.andmore.android.codesnippets.i18n.AndroidSnippetsNLS;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.prefs.BackingStoreException;

public class TooltipDisplayConfigContriutionItem
extends ControlContribution {
    private Button showToolTipButton = null;
    private static final String DIALOG_SETTINGS__IS_TOOLTIP_DISPLAYED = "IsTooltipDisplayed";

    public TooltipDisplayConfigContriutionItem() {
        super("org.eclipse.andmore.android.codesnippets.tooltipDisplayConfig");
    }

    protected Control createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        RowLayout layout = new RowLayout(4);
        layout.center = true;
        layout.marginLeft = 10;
        mainComposite.setLayout((Layout)layout);
        this.showToolTipButton = new Button(mainComposite, 32);
        this.showToolTipButton.setText(AndroidSnippetsNLS.TooltipDisplayConfigContriutionItem_ShowPreview);
        this.showToolTipButton.addSelectionListener((SelectionListener)new TooltipSelectionListener());
        IEclipsePreferences preferences = this.getEclipsePreferences();
        boolean isTooltipDisplayed = preferences.getBoolean(DIALOG_SETTINGS__IS_TOOLTIP_DISPLAYED, true);
        this.showToolTipButton.setSelection(isTooltipDisplayed);
        this.performButtonSelection();
        return mainComposite;
    }

    public boolean isTooltipDisplayed() {
        return this.showToolTipButton.getSelection();
    }

    private void performButtonSelection() {
        IEclipsePreferences preferences = this.getEclipsePreferences();
        preferences.putBoolean(DIALOG_SETTINGS__IS_TOOLTIP_DISPLAYED, this.showToolTipButton.getSelection());
        try {
            preferences.flush();
        }
        catch (BackingStoreException bse) {
            AndmoreLogger.error((String)TooltipDisplayConfigContriutionItem.class.toString(), (String)"Preferences for snippets could not be saved.", (Throwable)bse);
        }
    }

    private IEclipsePreferences getEclipsePreferences() {
        return ConfigurationScope.INSTANCE.getNode("org.eclipse.wst.common.snippets.internal.ui.SnippetsView");
    }

    private final class TooltipSelectionListener
    implements SelectionListener {
        private TooltipSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TooltipDisplayConfigContriutionItem.this.performButtonSelection();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

