/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.common.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.andmore.android.common.exception.AndroidException;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.common.utilities.TargetDataReader;
import org.eclipse.andmore.android.common.utilities.i18n.UtilitiesNLS;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.Bundle;

public class AndroidUtils {
    private static final String CLASS_COM_ANDROID_IDE_ECLIPSE_ADT_INTERNAL_SDK_ANDROID_TARGET_DATA = "org.eclipe.andmore.internal.sdk.AndroidTargetData";
    private static final String CLASS_COM_ANDROID_SDKLIB_I_ANDROID_TARGET = "com.android.sdklib.IAndroidTarget";
    private static final String CLASS_COM_ANDROID_SDKLIB_ANDROID_VERSION = "com.android.sdklib.AndroidVersion";
    private static final String CLASS_COM_ANDROID_IDE_ECLIPSE_ADT_INTERNAL_SDK_SDK = "org.eclipe.andmore.internal.sdk.Sdk";
    private static final String ANDROID_VERSION_API_LEVEL = "AndroidVersion.ApiLevel";
    private static final String SOURCE_PROPERTIES = "source.properties";
    private static final String ANDROID_JAR = "android.jar";
    private static final String PLATFORMS = "platforms";
    private static final String ANDROID = "android-";
    private static final String TARGET = "target";
    private static final String DEFAULT_PROPERTIES = "default.properties";
    private static final String PROJECT_PROPERTIES = "project.properties";
    private static final Map<String, String> permissionNameToPrefixToAppend = new HashMap<String, String>();

    static {
        permissionNameToPrefixToAppend.put("SET_ALARM", "com.android.alarm.permission");
        permissionNameToPrefixToAppend.put("READ_HISTORY_BOOKMARKS", "com.android.browser.permission");
        permissionNameToPrefixToAppend.put("WRITE_HISTORY_BOOKMARKS", "com.android.browser.permission");
        permissionNameToPrefixToAppend.put("ADD_VOICEMAIL", "com.android.voicemail.permission");
    }

    public static String getSDKPathByPreference() {
        IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("org.eclipe.andmore");
        return pref.get("org.eclipe.andmore.sdk", "");
    }

    public static File getAndroidJar(File projectDir) throws AndroidException {
        File androidTargetFolder = AndroidUtils.getAndroidTargetPathForProject(projectDir);
        return new File(androidTargetFolder, ANDROID_JAR);
    }

    public static String[] getIntentFilterPermissions(IProject project) {
        String[] attributeValues = new String[]{};
        if (project != null && project.isOpen()) {
            try {
                Class<?> clsSdk = Class.forName(CLASS_COM_ANDROID_IDE_ECLIPSE_ADT_INTERNAL_SDK_SDK);
                Method mtdGetCurrent = clsSdk.getMethod("getCurrent", null);
                Object sdk = mtdGetCurrent.invoke(null, null);
                Method mtdGetTarget = clsSdk.getMethod("getTarget", IProject.class);
                Object target = mtdGetTarget.invoke(sdk, project);
                Class<?> interfaceIAndroidTarget = Class.forName(CLASS_COM_ANDROID_SDKLIB_I_ANDROID_TARGET);
                Method mtdGetTargetData = clsSdk.getMethod("getTargetData", interfaceIAndroidTarget);
                Object targetData = mtdGetTargetData.invoke(sdk, target);
                if (targetData != null) {
                    Class<?> clsAndroidTargetData = Class.forName(CLASS_COM_ANDROID_IDE_ECLIPSE_ADT_INTERNAL_SDK_ANDROID_TARGET_DATA);
                    Method mtdGetAttributeValues = clsAndroidTargetData.getMethod("getAttributeValues", String.class, String.class);
                    attributeValues = (String[])mtdGetAttributeValues.invoke(targetData, "uses-permission", "android:name");
                }
            }
            catch (Exception e) {
                AndmoreLogger.warn("It was not possible to reach ADT methods (reflection break)", e.getMessage());
                try {
                    attributeValues = AndroidUtils.getIntentFilterPermissions().toArray(attributeValues);
                }
                catch (IOException e1) {
                    AndmoreLogger.error(UtilitiesNLS.AndroidUtils_NotPossibleToReachPermissionsFile_Error, e1.getMessage());
                }
                EclipseUtils.showWarningDialog(UtilitiesNLS.AndroidUtils_ERROR_GETINTENTPERMISSIONSBYREFLECTION_TITLE, UtilitiesNLS.AndroidUtils_ERROR_GETINTENTPERMISSIONSBYREFLECTION_MESSAGE);
            }
        }
        return attributeValues;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File getAndroidTargetPathForProject(File projectDir) throws AndroidException {
        boolean androidSdkPreferenceDefined;
        String sdkPath;
        File androidTarget = null;
        Properties properties = new Properties();
        File defaultPropertiesFile = new File(projectDir, PROJECT_PROPERTIES);
        if (!defaultPropertiesFile.exists()) {
            defaultPropertiesFile = new File(projectDir, DEFAULT_PROPERTIES);
        }
        if (!defaultPropertiesFile.exists()) throw new AndroidException(UtilitiesNLS.AndroidUtils_ERROR_DEFAULTPROPERTIESNOTFOUND);
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(defaultPropertiesFile);
                properties.load(fileInputStream);
            }
            catch (IOException e) {
                throw new AndroidException(UtilitiesNLS.AndroidUtils_ErrorReadingDefaultPropertiesFile, e);
            }
        }
        catch (Throwable throwable) {
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
        }
        if (!properties.containsKey(TARGET)) return androidTarget;
        String targetValue = properties.getProperty(TARGET);
        if (targetValue != null && !targetValue.startsWith(ANDROID)) {
            try {
                int colonIndex = targetValue.lastIndexOf(":");
                if (colonIndex >= 0) {
                    targetValue = ANDROID + targetValue.substring(colonIndex + 1);
                }
            }
            catch (Exception exception) {}
        }
        if ((sdkPath = AndroidUtils.getSdkPath(androidSdkPreferenceDefined = !AndroidUtils.getSDKPathByPreference().equals(""))) == null) throw new AndroidException(UtilitiesNLS.AndroidUtils_ERROR_SDKPATHNOTFOUND);
        androidTarget = new File(String.valueOf(sdkPath) + File.separator + PLATFORMS + File.separator + targetValue);
        if (androidTarget.exists()) return androidTarget;
        File baseFolder = new File(String.valueOf(sdkPath) + File.separator + PLATFORMS);
        File[] androidPlatforms = baseFolder.listFiles();
        boolean foundJar = false;
        if (androidPlatforms.length <= 0) return androidTarget;
        File[] fileArray = androidPlatforms;
        int n = androidPlatforms.length;
        int n2 = 0;
        while (n2 < n) {
            File androidPlatform = fileArray[n2];
            File sourcePropsFile = new File(androidPlatform, SOURCE_PROPERTIES);
            File jar = new File(androidPlatform, ANDROID_JAR);
            if (sourcePropsFile.exists() && jar.exists()) {
                Properties sourceProperties = new Properties();
                try {
                    try {
                        fileInputStream = new FileInputStream(sourcePropsFile);
                        sourceProperties.load(fileInputStream);
                    }
                    catch (IOException e) {
                        throw new AndroidException(UtilitiesNLS.AndroidUtils_ErrorReadingDefaultPropertiesFile, e);
                    }
                }
                catch (Throwable throwable) {
                    if (fileInputStream == null) throw throwable;
                    try {
                        fileInputStream.close();
                        throw throwable;
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception) {}
                }
                String apiLevel = sourceProperties.getProperty(ANDROID_VERSION_API_LEVEL);
                int index = targetValue.indexOf("-");
                if (index >= 0 && apiLevel != null) {
                    String versionName = targetValue.substring(index + 1);
                    try {
                        Integer version = Integer.valueOf(versionName);
                        Integer apiLevelVersion = Integer.valueOf(apiLevel);
                        if (apiLevelVersion >= version) {
                            foundJar = true;
                            androidTarget = androidPlatform;
                            break;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            ++n2;
        }
        if (foundJar) return androidTarget;
        throw new AndroidException(String.valueOf(androidTarget.getAbsolutePath()) + UtilitiesNLS.AndroidUtils_ERROR_SDK_TARGETPLATFORM_NOTFOUND);
    }

    private static String getSdkPath(boolean preferenceDefined) {
        String sdkPath = null;
        if (!preferenceDefined) {
            String pathVariable = System.getenv("PATH");
            String pathSeparator = System.getProperty("path.separator");
            String subPath = null;
            File checkedPath = null;
            String[] folderList = null;
            StringTokenizer token = new StringTokenizer(pathVariable, pathSeparator);
            block0: while (token.hasMoreTokens()) {
                subPath = token.nextToken();
                checkedPath = new File(subPath);
                if (!checkedPath.isDirectory()) continue;
                String[] stringArray = folderList = checkedPath.list();
                int n = folderList.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (s.equals("emulator") || s.equals("emulator.exe") || s.equals("adb") || s.equals("adb.exe")) {
                        File root = checkedPath.getParentFile();
                        sdkPath = root.getAbsolutePath();
                        continue block0;
                    }
                    ++n2;
                }
            }
        } else {
            sdkPath = AndroidUtils.getSDKPathByPreference();
        }
        return sdkPath;
    }

    public static String[] getActivityActions(IProject project) throws AndroidException {
        String[] activityActions = new String[1];
        File androidTargetFile = AndroidUtils.getAndroidTargetPathForProject(project.getLocation().toFile());
        TargetDataReader targetDataReader = new TargetDataReader(androidTargetFile);
        try {
            activityActions = targetDataReader.getActivityActions().toArray(activityActions);
        }
        catch (IOException e) {
            throw new AndroidException(e);
        }
        return activityActions;
    }

    public static String[] getReceiverActions(IProject project) throws AndroidException {
        String[] receiverActions = new String[1];
        File androidTargetFile = AndroidUtils.getAndroidTargetPathForProject(project.getLocation().toFile());
        TargetDataReader targetDataReader = new TargetDataReader(androidTargetFile);
        try {
            receiverActions = targetDataReader.getReceiverActions().toArray(receiverActions);
        }
        catch (IOException e) {
            throw new AndroidException(e);
        }
        return receiverActions;
    }

    public static String[] getIntentFilterCategories(IProject project) throws AndroidException {
        String[] intentFilterCategories = new String[1];
        File androidTargetFile = AndroidUtils.getAndroidTargetPathForProject(project.getLocation().toFile());
        TargetDataReader targetDataReader = new TargetDataReader(androidTargetFile);
        try {
            intentFilterCategories = targetDataReader.getIntentFilterCategories().toArray(intentFilterCategories);
        }
        catch (IOException e) {
            throw new AndroidException(e);
        }
        return intentFilterCategories;
    }

    public static String[] getServiceActions(IProject project) throws AndroidException {
        String[] serviceActions = new String[1];
        File androidTargetFile = AndroidUtils.getAndroidTargetPathForProject(project.getLocation().toFile());
        TargetDataReader targetDataReader = new TargetDataReader(androidTargetFile);
        try {
            serviceActions = targetDataReader.getServiceActions().toArray(serviceActions);
        }
        catch (IOException e) {
            throw new AndroidException(e);
        }
        return serviceActions;
    }

    public static int getApiVersionNumberForProject(IProject project) throws AndroidException {
        int api = 0;
        try {
            Class<?> clsSdk = Class.forName(CLASS_COM_ANDROID_IDE_ECLIPSE_ADT_INTERNAL_SDK_SDK);
            Method mtdGetCurrent = clsSdk.getMethod("getCurrent", null);
            Object sdk = mtdGetCurrent.invoke(null, null);
            Method mtdGetTarget = clsSdk.getMethod("getTarget", IProject.class);
            Object target = mtdGetTarget.invoke(sdk, project);
            Class<?> clsAndroidVersion = Class.forName(CLASS_COM_ANDROID_SDKLIB_ANDROID_VERSION);
            Class<?> interfaceIAndroidTarget = Class.forName(CLASS_COM_ANDROID_SDKLIB_I_ANDROID_TARGET);
            Method mtdGetVersion = interfaceIAndroidTarget.getMethod("getVersion", null);
            Object version = mtdGetVersion.invoke(target, null);
            if (version != null) {
                Method mtdGetApiLevel = clsAndroidVersion.getMethod("getApiLevel", null);
                Object apiLevel = mtdGetApiLevel.invoke(version, null);
                api = (Integer)apiLevel;
            }
        }
        catch (Exception e) {
            AndmoreLogger.info("It was not possible to reach ADT methods (reflection break)", e.getMessage());
            throw new AndroidException(UtilitiesNLS.AndroidUtils_NotPossibleToGetAPIVersionNumber_Error);
        }
        return api;
    }

    private static List<String> getIntentFilterPermissions() throws IOException {
        URL permissionsURL = null;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.andmore.android.common");
        permissionsURL = bundle.getEntry(new StringBuilder(47).append("files/permissions.txt").toString());
        ArrayList<String> items = new ArrayList<String>();
        InputStream is = null;
        BufferedReader bufferedReader = null;
        try {
            if (permissionsURL != null) {
                is = permissionsURL.openStream();
            }
            if (is != null) {
                String line;
                bufferedReader = new BufferedReader(new InputStreamReader(is));
                while ((line = bufferedReader.readLine()) != null) {
                    String prefix = "";
                    prefix = !permissionNameToPrefixToAppend.containsKey(line.trim()) ? "android.permission" : permissionNameToPrefixToAppend.get(line.trim());
                    items.add(String.valueOf(prefix) + "." + line.trim());
                }
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return items;
    }
}

