/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.common.utilities;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.common.utilities.i18n.UtilitiesNLS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;

public class FileUtil {
    public static final int OS_WINDOWS = 0;
    public static final int OS_LINUX = 1;
    public static final char[] MAC_SPECIAL_CHAR = new char[]{'\\', ' ', '\'', '\"', '!', '@', '$', '&', '*', '(', ')', '=', '`', '[', ']', '{', '}', '^', '<', '>', ':', ';', '?', '|'};
    public static final char[] LINUX_SPECIAL_CHAR = new char[]{'\\', ' ', '\'', '\"', '!', '$', '&', '*', '(', ')', '=', '`', '[', ']', '{', '}', '^', '<', '>', ':', ';', '?', '|'};
    public static final char ESCAPE_CHAR = '\\';
    private static final int BUFFER_SIZE = 1024;

    public static void copyDir(File fromDir, File toDir) throws IOException {
        if (fromDir != null && fromDir.isDirectory() && fromDir.canRead() && toDir != null && toDir.isDirectory() && toDir.canWrite()) {
            File[] fileArray = fromDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isFile()) {
                    FileUtil.copyFile(child, new File(toDir, child.getName()));
                } else {
                    File newDir = new File(toDir.getAbsolutePath(), child.getName());
                    newDir.mkdir();
                    FileUtil.copyDir(child, newDir);
                }
                ++n2;
            }
        } else {
            String errorMessage = "";
            if (fromDir == null) {
                errorMessage = "Null pointer for source directory.";
            } else if (!fromDir.isDirectory()) {
                errorMessage = String.valueOf(fromDir.getName()) + " is not a directory.";
            } else if (!fromDir.canRead()) {
                errorMessage = "Cannot read from " + fromDir.getName() + ".";
            } else if (toDir == null) {
                errorMessage = "Null pointer for destination directory.";
            } else if (!toDir.isDirectory()) {
                errorMessage = String.valueOf(toDir.getName()) + " is not a directory.";
            } else if (!toDir.canWrite()) {
                errorMessage = "Cannot write to" + toDir.getName() + ".";
            }
            AndmoreLogger.error(errorMessage);
            throw new IOException("Error copying directory: " + errorMessage);
        }
        AndmoreLogger.info("The directory " + fromDir.getName() + " was successfully copied to " + toDir.getName() + ".");
    }

    public static void copyFile(File source, File target) throws IOException {
        FileUtil.copyFile(source.getAbsolutePath(), target.getAbsolutePath());
    }

    private static void copyFile(String source, String target) throws IOException {
        AbstractInterruptibleChannel sourceFileChannel = null;
        AbstractInterruptibleChannel targetFileChannel = null;
        FileInputStream sourceFileInStream = null;
        FileOutputStream targetFileOutStream = null;
        try {
            try {
                sourceFileInStream = new FileInputStream(source);
                sourceFileChannel = sourceFileInStream.getChannel();
                targetFileOutStream = new FileOutputStream(target);
                targetFileChannel = targetFileOutStream.getChannel();
                ((FileChannel)targetFileChannel).transferFrom((ReadableByteChannel)((Object)sourceFileChannel), 0L, ((FileChannel)sourceFileChannel).size());
                AndmoreLogger.info("The file " + source + " was successfully copied to " + target + ".");
            }
            catch (IOException e) {
                AndmoreLogger.error("Error copying file" + source + "to " + target + ".");
                throw e;
            }
        }
        finally {
            try {
                if (sourceFileChannel != null) {
                    sourceFileChannel.close();
                }
            }
            catch (IOException e) {
                AndmoreLogger.error("Error closing file " + source + ".");
                throw e;
            }
            try {
                if (targetFileChannel != null) {
                    targetFileChannel.close();
                }
            }
            catch (IOException e) {
                AndmoreLogger.error("Error closing file" + target + ".");
                throw e;
            }
            try {
                if (sourceFileInStream != null) {
                    sourceFileInStream.close();
                }
            }
            catch (IOException e) {
                AndmoreLogger.error("Error closing file" + source + ".");
                throw e;
            }
            try {
                if (targetFileOutStream != null) {
                    targetFileOutStream.close();
                }
            }
            catch (IOException e) {
                AndmoreLogger.error("Error closing file" + target + ".");
                throw e;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean deleteDirRecursively(File directory) throws IOException {
        File[] children;
        String dirName = "";
        boolean success = true;
        if (!directory.exists()) {
            String errorMessage = "The directory does not exist.";
            AndmoreLogger.error(errorMessage);
            success = false;
            throw new IOException(errorMessage);
        }
        if (!directory.isDirectory()) {
            String errorMessage = String.valueOf(directory.getName()) + " is not a diretory.";
            AndmoreLogger.error(errorMessage);
            throw new IOException(errorMessage);
        }
        dirName = directory.getName();
        File[] fileArray = children = directory.listFiles();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File element = fileArray[n2];
            success = element.isFile() ? success && element.delete() : success && FileUtil.deleteDirRecursively(element);
            ++n2;
        }
        if (!success) return false;
        if (!directory.delete()) return false;
        boolean bl = true;
        success = bl;
        if (!success) return success;
        if (dirName.equals("")) return success;
        AndmoreLogger.info("The directory " + dirName + "was successfully deleted.");
        return success;
    }

    public static void deleteFile(File fileToDelete) throws IOException {
        if (!(fileToDelete != null && fileToDelete.exists() && fileToDelete.isFile() && fileToDelete.canWrite())) {
            String errorMessage = "";
            if (fileToDelete == null) {
                errorMessage = "Null pointer for file to delete.";
            } else if (!fileToDelete.exists()) {
                errorMessage = "The file " + fileToDelete.getName() + " does not exist.";
            } else if (!fileToDelete.isFile()) {
                errorMessage = String.valueOf(fileToDelete.getName()) + " is not a file.";
            } else if (!fileToDelete.canWrite()) {
                errorMessage = "Cannot write to " + fileToDelete.getName();
            }
            AndmoreLogger.error(errorMessage);
            throw new IOException("Cannot delete file: " + errorMessage);
        }
        fileToDelete.delete();
        AndmoreLogger.info("The file " + fileToDelete.getName() + "was successfully deleted.");
    }

    public static void deleteFilesOnList(List<File> filesToDelete) throws IOException {
        for (File element : filesToDelete) {
            if (!element.exists()) continue;
            FileUtil.deleteFile(element);
        }
    }

    public static int getFileSize(File root) throws IOException {
        int size = 0;
        if (root.isDirectory()) {
            File[] fileArray = root.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                size += FileUtil.getFileSize(child);
                ++n2;
            }
        } else if (root.isFile()) {
            int available;
            FileInputStream fis = new FileInputStream(root);
            try {
                available = fis.available();
            }
            catch (Throwable throwable) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                fis.close();
            }
            catch (IOException iOException) {}
            size = available;
        }
        return size;
    }

    public static String getExtension(String fileName) {
        if (fileName != null) {
            int i = fileName.lastIndexOf(".") + 1;
            return i == 0 ? "" : fileName.substring(i);
        }
        AndmoreLogger.error("The file " + fileName + " does not exist.");
        return null;
    }

    public static List<File> getFilesComposingPath(File aFile) {
        ArrayList<File> fileList;
        if (aFile == null) {
            fileList = new ArrayList();
        } else {
            fileList = FileUtil.getFilesComposingPath(aFile.getParentFile());
            fileList.add(aFile);
        }
        return fileList;
    }

    public static String getRelativeFilename(File homeDir, File targetFile) throws IOException {
        StringBuffer relativePath = new StringBuffer();
        List<File> homeDirList = FileUtil.getFilesComposingPath(FileUtil.getCanonicalFile(homeDir));
        List<File> targetDirList = FileUtil.getFilesComposingPath(FileUtil.getCanonicalFile(targetFile));
        if (homeDirList.size() == 0) {
            AndmoreLogger.info("Home Dir has no parent.");
        }
        if (targetDirList.size() == 0) {
            AndmoreLogger.info("Target Dir has no parent.");
        }
        int commonIndex = -1;
        int i = 0;
        while (i < homeDirList.size() && i < targetDirList.size()) {
            File aTargetDir;
            File aHomeDir = homeDirList.get(i);
            if (!aHomeDir.equals(aTargetDir = targetDirList.get(i))) break;
            commonIndex = i++;
        }
        i = commonIndex + 1;
        while (i < homeDirList.size()) {
            relativePath.append("..");
            relativePath.append(File.separatorChar);
            ++i;
        }
        i = commonIndex + 1;
        while (i < targetDirList.size()) {
            File targetDir = targetDirList.get(i);
            relativePath.append(targetDir.getName());
            if (i != targetDirList.size() - 1) {
                relativePath.append(File.separatorChar);
            }
            ++i;
        }
        return relativePath.toString();
    }

    public static List<String> listFilesRecursively(String baseDirToList) throws IOException {
        File baseDirToListFiles = new File(baseDirToList);
        List<String> listOfFiles = FileUtil.listFilesRecursively(baseDirToListFiles);
        return listOfFiles;
    }

    public static List<String> listFilesRecursively(File baseDirToList) throws IOException {
        ArrayList<String> listOfFiles = new ArrayList<String>();
        if (baseDirToList.exists() && baseDirToList.isDirectory() && baseDirToList.canRead()) {
            File[] children;
            File[] fileArray = children = baseDirToList.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isFile()) {
                    listOfFiles.add(child.getAbsolutePath());
                } else {
                    List<String> temporaryList = FileUtil.listFilesRecursively(child);
                    listOfFiles.addAll(temporaryList);
                }
                ++n2;
            }
        } else {
            String errorMessage = "";
            if (!baseDirToList.exists()) {
                errorMessage = "The base dir does not exist.";
            } else if (!baseDirToList.isDirectory()) {
                errorMessage = String.valueOf(baseDirToList.getName()) + "is not a directory.";
            } else if (!baseDirToList.canRead()) {
                errorMessage = "Cannot fread from " + baseDirToList.getName() + ".";
            }
            AndmoreLogger.error(errorMessage);
            throw new IOException("Error listing files: " + errorMessage);
        }
        return listOfFiles;
    }

    public static File getCanonicalFile(String absoluteFilename) {
        return FileUtil.getCanonicalFile(new File(absoluteFilename));
    }

    public static File getCanonicalFile(File location, String filename) {
        return FileUtil.getCanonicalFile(new File(location, filename));
    }

    /*
     * Unable to fully structure code
     */
    public static File getCanonicalFile(File aFile) {
        block5: {
            f = null;
            try {
                f = aFile.getCanonicalFile();
                break block5;
            }
            catch (IOException e) {
                AndmoreLogger.error(FileUtil.class, "FileUtil.getCanonicalFile: IOException e", (Throwable)e);
                filename = aFile.getAbsolutePath();
                st = new StringTokenizer(filename, File.separator);
                sb = new StringBuffer();
                ** while (st.hasMoreTokens())
            }
lbl-1000:
            // 1 sources

            {
                token = (String)st.nextElement();
                if (token.equals("..")) {
                    lastDirIndex = sb.lastIndexOf(File.separator);
                    if (lastDirIndex <= 2) continue;
                    sb.delete(lastDirIndex, sb.length());
                    continue;
                }
                if (token.equals(".")) continue;
                if (sb.length() > 0) {
                    sb.append(File.separator);
                }
                sb.append(token);
                if (!token.endsWith(":")) continue;
                sb.append(File.separator);
                continue;
            }
lbl28:
            // 1 sources

            f = new File(sb.toString());
        }
        return f;
    }

    public static int getOS() {
        int result = -1;
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("linux") > -1) {
            result = 1;
        } else if (osName.indexOf("windows") > -1) {
            result = 0;
        }
        return result;
    }

    public static boolean isWindows() {
        return FileUtil.getOS() == 0;
    }

    public static StringBuffer openFile(InputStream stream) throws IOException {
        InputStreamReader streamReader = null;
        StringBuffer fileBuffer = new StringBuffer();
        BufferedReader reader = null;
        try {
            streamReader = new InputStreamReader(stream);
            reader = new BufferedReader(streamReader);
            char[] buffer = new char[1024];
            int line = reader.read(buffer);
            while (line > 0) {
                fileBuffer.append(buffer, 0, line);
                line = reader.read(buffer);
            }
        }
        catch (Throwable throwable) {
            if (streamReader != null) {
                try {
                    streamReader.close();
                }
                catch (Exception exception) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (streamReader != null) {
            try {
                streamReader.close();
            }
            catch (Exception exception) {}
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        return fileBuffer;
    }

    public static String[] readFileAsArray(String filename) throws IOException {
        LinkedList<String> file = new LinkedList<String>();
        String[] lines = new String[]{};
        FileReader reader = null;
        BufferedReader lineReader = null;
        try {
            String line;
            reader = new FileReader(filename);
            lineReader = new LineNumberReader(reader);
            while ((line = ((LineNumberReader)lineReader).readLine()) != null) {
                file.add(line);
            }
            lines = new String[file.size()];
            lines = file.toArray(lines);
        }
        catch (Throwable throwable) {
            try {
                lineReader.close();
                reader.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            lineReader.close();
            reader.close();
        }
        catch (Exception exception) {}
        return lines;
    }

    public static IDocument readFile(IFile file) throws CoreException {
        if (!FileUtil.canRead(file)) {
            String errMsg = NLS.bind((String)UtilitiesNLS.EXC_FileUtil_TheFileCannotBeRead, (Object)file.getName());
            Status status = new Status(4, "org.eclipse.andmore.android.common", errMsg);
            throw new CoreException((IStatus)status);
        }
        TextFileDocumentProvider documentProvider = new TextFileDocumentProvider();
        Document document = new Document();
        documentProvider.connect((Object)file);
        document = documentProvider.getDocument((Object)file);
        documentProvider.disconnect((Object)file);
        return document;
    }

    public static void saveFile(IFile file, IDocument document, String encoding, boolean overwrite) throws CoreException {
        if (file.exists() && !overwrite) {
            String errMsg = NLS.bind((String)UtilitiesNLS.EXC_FileUtil_CannotOverwriteTheFile, (Object)file.getName());
            Status status = new Status(4, "org.eclipse.andmore.android.common", errMsg);
            throw new CoreException((IStatus)status);
        }
        if (!FileUtil.canWrite(file)) {
            String errMsg = NLS.bind((String)UtilitiesNLS.EXC_FileUtil_ErrorWritingTheFile, (Object)file.getName());
            Status status = new Status(4, "org.eclipse.andmore.android.common", errMsg);
            throw new CoreException((IStatus)status);
        }
        ByteArrayInputStream bais = null;
        try {
            try {
                bais = new ByteArrayInputStream(document.get().getBytes(encoding));
                file.setCharset(encoding, (IProgressMonitor)new NullProgressMonitor());
                file.setContents((InputStream)bais, true, false, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                String errMsg = NLS.bind((String)UtilitiesNLS.EXC_FileUtil_ErrorSettingTheFileEncoding, (Object)file.getName());
                Status status = new Status(4, "org.eclipse.andmore.android.common", errMsg);
                throw new CoreException((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (bais != null) {
            try {
                bais.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canRead(IFile file) {
        boolean canRead = true;
        InputStream is = null;
        try {
            if (file.exists()) {
                file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                is = file.getContents();
                is.read();
            }
        }
        catch (CoreException coreException) {
            canRead = false;
            if (is == null) return canRead;
            try {
                is.close();
                return canRead;
            }
            catch (IOException iOException) {}
            return canRead;
        }
        catch (IOException iOException) {
            try {
                canRead = false;
                if (is == null) return canRead;
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                is.close();
                return canRead;
            }
            catch (IOException iOException3) {}
            return canRead;
        }
        if (is == null) return canRead;
        try {
            is.close();
            return canRead;
        }
        catch (IOException iOException) {}
        return canRead;
    }

    public static boolean canWrite(IFile file) {
        boolean canWrite = true;
        if (file.exists() && FileUtil.canRead(file)) {
            canWrite = !file.isReadOnly();
        } else {
            IFolder parent = (IFolder)file.getParent();
            if (!parent.isAccessible()) {
                canWrite = false;
            } else {
                try {
                    if (parent.members() == null) {
                        canWrite = false;
                    } else {
                        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
                        file.create(null, true, (IProgressMonitor)nullProgressMonitor);
                        file.refreshLocal(0, (IProgressMonitor)nullProgressMonitor);
                        file.delete(true, (IProgressMonitor)nullProgressMonitor);
                    }
                }
                catch (CoreException coreException) {
                    canWrite = false;
                }
            }
        }
        return canWrite;
    }

    public static boolean canRead(File file) {
        boolean canRead;
        block18: {
            canRead = false;
            if (file != null && file.exists()) {
                FileInputStream fis = null;
                try {
                    try {
                        if (file.isFile()) {
                            fis = new FileInputStream(file);
                            fis.read();
                            canRead = true;
                        } else {
                            String[] children = file.list();
                            if (children != null) {
                                canRead = true;
                            }
                        }
                    }
                    catch (Exception exception) {
                        try {
                            if (fis != null) {
                                fis.close();
                            }
                            break block18;
                        }
                        catch (IOException iOException) {}
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return canRead;
    }

    public static boolean canWrite(File file) {
        boolean canWrite;
        block22: {
            canWrite = false;
            if (file != null) {
                FileOutputStream fos = null;
                try {
                    try {
                        if (!file.exists()) {
                            canWrite = file.createNewFile();
                            if (canWrite) {
                                file.delete();
                            }
                        } else if (file.isDirectory()) {
                            File tempFile = File.createTempFile("StudioForAndroidFSChecking", null, file);
                            if (tempFile.exists()) {
                                canWrite = true;
                                tempFile.delete();
                            }
                        } else if (file.isFile()) {
                            fos = new FileOutputStream(file);
                            fos.getFD();
                            canWrite = true;
                        }
                    }
                    catch (Exception exception) {
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return canWrite;
    }

    public static boolean unpackZipFile(File file, String destination, IProgressMonitor monitor) {
        String extractDestination;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        ZipFile zipFile = null;
        String string = extractDestination = destination != null ? destination : file.getParent();
        if (!extractDestination.endsWith(File.separator)) {
            extractDestination = String.valueOf(extractDestination) + File.separator;
        }
        boolean unziped = true;
        try {
            zipFile = new ZipFile(file);
        }
        catch (Throwable e) {
            unziped = false;
            AndmoreLogger.error(FileUtil.class, "Error extracting file: " + file.getAbsolutePath() + " to " + extractDestination, e);
        }
        if (zipFile != null) {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            subMonitor.beginTask("Extracting files", Collections.list(entries).size());
            entries = zipFile.entries();
            InputStream input = null;
            OutputStream output = null;
            while (entries.hasMoreElements()) {
                try {
                    try {
                        ZipEntry entry = entries.nextElement();
                        File newFile = new File(String.valueOf(extractDestination) + entry.getName());
                        if (entry.isDirectory()) {
                            newFile.mkdirs();
                        } else {
                            newFile.getParentFile().mkdirs();
                            if (newFile.createNewFile()) {
                                input = zipFile.getInputStream(entry);
                                output = new BufferedOutputStream(new FileOutputStream(newFile));
                                FileUtil.copyStreams(input, output);
                            }
                        }
                    }
                    catch (Throwable t) {
                        unziped = false;
                        AndmoreLogger.error(FileUtil.class, "Error extracting file: " + file.getAbsolutePath() + " to " + extractDestination, t);
                        try {
                            if (input != null) {
                                input.close();
                            }
                            if (output != null) {
                                output.close();
                            }
                        }
                        catch (Throwable throwable) {}
                        subMonitor.worked(1);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            input.close();
                        }
                        if (output != null) {
                            output.close();
                        }
                    }
                    catch (Throwable throwable2) {}
                    subMonitor.worked(1);
                    throw throwable;
                }
                try {
                    if (input != null) {
                        input.close();
                    }
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Throwable throwable) {}
                subMonitor.worked(1);
            }
        }
        return unziped;
    }

    public static boolean extractZipArchive(File file, File destination, List<String> selectedEntries, IProgressMonitor monitor) throws IOException {
        File extractDestination;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        ZipFile zipFile = null;
        CRC32 crc = new CRC32();
        byte[] buf = new byte[1024];
        File file2 = extractDestination = destination != null ? destination : file.getParentFile();
        if (!extractDestination.exists()) {
            extractDestination.mkdirs();
        }
        boolean unziped = true;
        try {
            zipFile = new ZipFile(file);
        }
        catch (Throwable e) {
            unziped = false;
            AndmoreLogger.error(FileUtil.class, "Error extracting file: " + file.getAbsolutePath() + " to " + extractDestination, e);
        }
        if (zipFile != null) {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            subMonitor.beginTask("Extracting files", Collections.list(entries).size());
            entries = zipFile.entries();
            InputStream input = null;
            FileOutputStream output = null;
            int diagReturn = 2;
            while (entries.hasMoreElements()) {
                crc.reset();
                try {
                    try {
                        ZipEntry entry = entries.nextElement();
                        if (selectedEntries.contains(entry.getName())) {
                            File newFile = new File(extractDestination, entry.getName());
                            if (diagReturn != 4 && newFile.exists()) {
                                diagReturn = EclipseUtils.showQuestionYesAllCancelDialog(UtilitiesNLS.FileUtil_File_Exists_Title, NLS.bind((String)UtilitiesNLS.FileUtil_File_Exists_Message, (Object)newFile.getAbsolutePath()));
                            }
                            if (diagReturn == 2 || diagReturn == 4) {
                                newFile.delete();
                                if (entry.isDirectory()) {
                                    newFile.mkdirs();
                                } else {
                                    newFile.getParentFile().mkdirs();
                                    if (newFile.createNewFile()) {
                                        input = zipFile.getInputStream(entry);
                                        output = new FileOutputStream(newFile);
                                        int length = 0;
                                        while ((length = input.read(buf, 0, 1024)) > 1) {
                                            output.write(buf, 0, length);
                                            crc.update(buf, 0, length);
                                        }
                                        if (crc.getValue() != entry.getCrc()) {
                                            throw new IOException();
                                        }
                                    }
                                }
                            } else {
                                diagReturn = 2;
                            }
                        }
                    }
                    catch (IOException e) {
                        unziped = false;
                        AndmoreLogger.error(FileUtil.class, "Error extracting file: " + file.getAbsolutePath() + " to " + extractDestination, (Throwable)e);
                        throw e;
                    }
                    catch (Throwable t) {
                        unziped = false;
                        AndmoreLogger.error(FileUtil.class, "Error extracting file: " + file.getAbsolutePath() + " to " + extractDestination, t);
                        try {
                            if (input != null) {
                                input.close();
                            }
                            if (output != null) {
                                output.close();
                            }
                        }
                        catch (Throwable throwable) {}
                        subMonitor.worked(1);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            input.close();
                        }
                        if (output != null) {
                            output.close();
                        }
                    }
                    catch (Throwable throwable2) {}
                    subMonitor.worked(1);
                    throw throwable;
                }
                try {
                    if (input != null) {
                        input.close();
                    }
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Throwable throwable) {}
                subMonitor.worked(1);
            }
        }
        return unziped;
    }

    public static boolean unpackTarFile(File artifactFile, String destination) {
        String extractDestination;
        boolean unpacked = true;
        String string = extractDestination = destination != null ? destination : artifactFile.getParent();
        if (!extractDestination.endsWith(File.separator)) {
            extractDestination = String.valueOf(extractDestination) + File.separator;
        }
        LinkedList<String> commandList = new LinkedList<String>();
        commandList.add("tar");
        String fileName = artifactFile.getName();
        if (fileName.endsWith("gz")) {
            commandList.add("xzf");
        } else if (fileName.endsWith("bz2")) {
            commandList.add("xjf");
        } else if (fileName.endsWith("tar")) {
            commandList.add("xf");
        } else {
            unpacked = false;
        }
        if (unpacked) {
            commandList.add(artifactFile.getAbsolutePath());
            File target = new File(extractDestination);
            if (target.exists() && target.isDirectory() && target.canWrite()) {
                try {
                    Process p = Runtime.getRuntime().exec(commandList.toArray(new String[0]), null, target);
                    try {
                        p.waitFor();
                    }
                    catch (InterruptedException interruptedException) {}
                    if (p.exitValue() != 0) {
                        unpacked = false;
                    }
                }
                catch (IOException iOException) {
                    unpacked = false;
                }
            }
        }
        return unpacked;
    }

    public static void copyStreams(InputStream inputStream, OutputStream outputStream) throws IOException {
        int length;
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) >= 0) {
            outputStream.write(buffer, 0, length);
        }
    }

    public static void createProjectFolder(IProject project, String parentFolder, String folderName, IProgressMonitor monitor) throws CoreException {
        block4: {
            monitor.beginTask(UtilitiesNLS.UI_Project_Creating_Folder_Task, 100);
            try {
                monitor.setTaskName(UtilitiesNLS.UI_Project_Verifying_Folder_Task);
                if (folderName.length() <= 0) break block4;
                monitor.worked(10);
                IFolder folder = project.getFolder(String.valueOf(parentFolder) + folderName);
                monitor.worked(10);
                if (folder.exists()) break block4;
                monitor.worked(10);
                if (FileUtil.canWrite(folder.getLocation().toFile())) {
                    monitor.worked(10);
                    monitor.setTaskName(UtilitiesNLS.UI_Project_Creating_Folder_Task);
                    folder.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 60));
                    break block4;
                }
                String errMsg = NLS.bind((String)UtilitiesNLS.EXC_Project_CannotCreateFolderReadOnlyWorkspace, (Object)folder.getLocation().toFile().toString());
                Status status = new Status(4, "org.eclipse.andmore.android.common", errMsg);
                throw new CoreException((IStatus)status);
            }
            finally {
                monitor.done();
            }
        }
    }

    public static File createUniqueDirectoryDescriptor(File directory) {
        if (directory.exists()) {
            boolean exists = true;
            int counter = 1;
            String rootPath = directory.getAbsolutePath();
            while (exists) {
                directory = new File(String.valueOf(rootPath) + "-" + counter);
                exists = directory.exists();
                ++counter;
            }
        }
        return directory;
    }

    public static String getEscapedPath(String path, String operatingSystem) {
        char[] specialCharSet = null;
        if (operatingSystem.equals("linux")) {
            specialCharSet = LINUX_SPECIAL_CHAR;
        } else if (operatingSystem.equals("macosx")) {
            specialCharSet = MAC_SPECIAL_CHAR;
        }
        if (path != null && specialCharSet != null) {
            char[] cArray = specialCharSet;
            int n = specialCharSet.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                String target = String.valueOf(c);
                String replacement = new String("\\" + String.valueOf(c));
                path = path.replace(target, replacement);
                ++n2;
            }
        }
        return path;
    }

    public static String getEscapedPath(String path) {
        return FileUtil.getEscapedPath(path, Platform.getOS());
    }

    public static String getUnescapedPath(String path) {
        char[] specialCharSet = null;
        if (Platform.getOS().equals("linux")) {
            specialCharSet = LINUX_SPECIAL_CHAR;
        } else if (Platform.getOS().equals("macosx")) {
            specialCharSet = MAC_SPECIAL_CHAR;
        }
        if (path != null && specialCharSet != null) {
            char[] cArray = specialCharSet;
            int n = specialCharSet.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                String target = String.valueOf(new String("\\")) + String.valueOf(c);
                String replacement = String.valueOf(c);
                path = path.replace(target, replacement);
                ++n2;
            }
        }
        return path;
    }

    public static String removeUnescapedQuotes(String path, String quoteReplacement) {
        char[] quotes = new char[]{'\'', '\"'};
        boolean escaped = false;
        int i = 0;
        while (i < path.length()) {
            if (!escaped) {
                if (path.charAt(i) == '\\') {
                    escaped = true;
                } else {
                    char[] cArray = quotes;
                    int n = quotes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char quote = cArray[n2];
                        if (path.charAt(i) == quote) {
                            String part1 = path.substring(0, i);
                            String part2 = path.substring(i + 1, path.length());
                            path = part1.concat(quoteReplacement).concat(part2);
                        }
                        ++n2;
                    }
                }
            } else {
                escaped = false;
            }
            ++i;
        }
        return path;
    }

    public static String getCleanPath(String path, String quoteReplacement) {
        path = FileUtil.removeUnescapedQuotes(path, quoteReplacement);
        path = FileUtil.getUnescapedPath(path);
        return path;
    }

    public static String calculateMd5Sum(File file) throws IOException {
        String md5Sum = null;
        BigInteger hash = null;
        FileInputStream fis = new FileInputStream(file);
        byte[] buf = new byte[1500000];
        try {
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                int bytesRead = 0;
                while ((bytesRead = fis.read(buf)) > 0) {
                    digest.update(buf, 0, bytesRead);
                }
                hash = new BigInteger(1, digest.digest());
                md5Sum = hash.toString(16);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                AndmoreLogger.warn("Eclipse Andmore could not find an instance of the MessageDigest for the MD5 algorithm");
                throw new IOException(UtilitiesNLS.FileUtil_Get_MD5_Algorithm_Failed);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        if (md5Sum == null) {
            throw new IOException(NLS.bind((String)UtilitiesNLS.FileUtil_MD5_Calculation_Failed, (Object)file.getAbsolutePath()));
        }
        return md5Sum;
    }

    public static void copy(File sourceFile, File targetFile) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(targetFile);
        FileInputStream inputStream = new FileInputStream(sourceFile);
        try {
            try {
                int length;
                byte[] buffer = new byte[1024];
                while ((length = ((InputStream)inputStream).read(buffer)) >= 0) {
                    ((OutputStream)outputStream).write(buffer, 0, length);
                }
            }
            catch (IOException iOException) {
                throw new IOException("Error copying file:" + sourceFile.getAbsolutePath() + " to " + targetFile.getAbsolutePath());
            }
        }
        finally {
            ((OutputStream)outputStream).close();
            ((InputStream)inputStream).close();
        }
    }

    public static String normalizePath(String folder) {
        return folder.endsWith(File.separator) ? folder : String.valueOf(folder) + File.separator;
    }

    public static void delete(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                int i = 0;
                while (i < files.length) {
                    FileUtil.delete(files[i]);
                    ++i;
                }
            }
            file.delete();
        }
    }

    public static void delete(String fileName) {
        FileUtil.delete(new File(fileName));
    }

    public static void mkdir(String directory) throws IOException {
        File f = new File(directory);
        if (f.exists() ? f.isFile() : !f.mkdirs()) {
            throw new IOException("Error creating directory:" + directory);
        }
    }
}

