/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.common.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TargetDataReader {
    private final File activityActionsFile;
    private final File broadCastActionsFile;
    private final File serviceActionsFile;
    private final File categoriesFile;

    public TargetDataReader(File androidTarget) {
        File dataFolder = new File(androidTarget, "data");
        this.activityActionsFile = new File(dataFolder, "activity_actions.txt");
        this.broadCastActionsFile = new File(dataFolder, "broadcast_actions.txt");
        this.serviceActionsFile = new File(dataFolder, "service_actions.txt");
        this.categoriesFile = new File(dataFolder, "categories.txt");
    }

    private List<String> readItems(File file) throws IOException {
        ArrayList<String> items = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        FileReader reader = null;
        try {
            String line;
            reader = new FileReader(file);
            bufferedReader = new BufferedReader(reader);
            while ((line = bufferedReader.readLine()) != null) {
                items.add(line.trim());
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return items;
    }

    public List<String> getActivityActions() throws IOException {
        return this.readItems(this.activityActionsFile);
    }

    public List<String> getServiceActions() throws IOException {
        return this.readItems(this.serviceActionsFile);
    }

    public List<String> getReceiverActions() throws IOException {
        return this.readItems(this.broadCastActionsFile);
    }

    public List<String> getIntentFilterCategories() throws IOException {
        return this.readItems(this.categoriesFile);
    }
}

