/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.common.utilities.ui;

import org.eclipse.andmore.android.common.utilities.i18n.UtilitiesNLS;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class LoginPasswordDialogCreator {
    private LoginPasswordDialog dialog;
    private final String url;
    public static final int OK = 0;
    public static final int CANCEL = 1;

    public LoginPasswordDialogCreator(String url) {
        this.url = url;
    }

    public int openLoginPasswordDialog() {
        final Integer[] dialogReturnValue = new Integer[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                LoginPasswordDialogCreator.this.dialog = new LoginPasswordDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
                dialogReturnValue[0] = LoginPasswordDialogCreator.this.dialog.open();
            }
        });
        return dialogReturnValue[0];
    }

    public String getTypedLogin() {
        String login = this.dialog != null ? this.dialog.getTypedLogin() : null;
        return login;
    }

    public String getTypedPassword() {
        String password = this.dialog != null ? this.dialog.getTypedPassword() : null;
        return password;
    }

    private class LoginPasswordDialog
    extends Dialog {
        private String login;
        private String password;

        protected LoginPasswordDialog(Shell parentShell) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x860);
        }

        protected Control createDialogArea(Composite parent) {
            parent.getShell().setText(UtilitiesNLS.LoginPasswordDialogCreator_DialogTItle0);
            Composite topComposite = new Composite(parent, 4);
            GridLayout layout = new GridLayout(1, false);
            GridData layoutData = new GridData(4, 4, true, true);
            topComposite.setLayout((Layout)layout);
            topComposite.setLayoutData((Object)layoutData);
            Label messageLabel = new Label(topComposite, 0);
            layoutData = new GridData(4, 0x1000000, false, false);
            messageLabel.setLayoutData((Object)layoutData);
            messageLabel.setText("   \n" + UtilitiesNLS.SDKLoginPasswordDialog_LoginInformationMessage + " " + LoginPasswordDialogCreator.this.url.substring(0, LoginPasswordDialogCreator.this.url.lastIndexOf("/")) + "   ");
            Composite mainComposite = new Composite(topComposite, 4);
            layout = new GridLayout(2, false);
            mainComposite.setLayout((Layout)layout);
            mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            Label loginLabel = new Label(mainComposite, 0);
            layoutData = new GridData(16384, 0x1000000, false, false);
            loginLabel.setLayoutData((Object)layoutData);
            loginLabel.setText(UtilitiesNLS.SDKLoginPasswordDialog_UsernameLabel);
            final Text loginText = new Text(mainComposite, 2052);
            layoutData = new GridData(4, 0x1000000, true, false);
            loginText.setLayoutData((Object)layoutData);
            loginText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LoginPasswordDialog.this.login = loginText.getText();
                }
            });
            Label passwordLabel = new Label(mainComposite, 0);
            layoutData = new GridData(16384, 0x1000000, false, false);
            passwordLabel.setLayoutData((Object)layoutData);
            passwordLabel.setText(UtilitiesNLS.SDKLoginPasswordDialog_PasswordLabel);
            final Text passwordText = new Text(mainComposite, 0x400804);
            layoutData = new GridData(4, 0x1000000, true, false);
            passwordText.setLayoutData((Object)layoutData);
            passwordText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LoginPasswordDialog.this.password = passwordText.getText();
                }
            });
            return topComposite;
        }

        public String getTypedLogin() {
            return this.login;
        }

        public String getTypedPassword() {
            return this.password;
        }
    }
}

