/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.model.manifest.parser;

import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import org.apache.xerces.parsers.DOMParser;
import org.eclipse.andmore.android.common.exception.AndroidException;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.i18n.UtilitiesNLS;
import org.eclipse.andmore.android.model.manifest.dom.AndroidManifestNode;
import org.eclipse.andmore.android.model.manifest.parser.AndroidManifestNodeParser;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AndroidManifestParser
extends AndroidManifestNodeParser {
    protected List<AndroidManifestNode> rootNodes = new LinkedList<AndroidManifestNode>();

    public void parseDocument(IDocument document) throws AndroidException {
        DOMParser domParser = new DOMParser();
        this.rootNodes.clear();
        StringReader stringReader = null;
        try {
            try {
                stringReader = new StringReader(document.get());
                domParser.parse(new InputSource(stringReader));
            }
            catch (SAXException e) {
                String errMsg = NLS.bind((String)UtilitiesNLS.EXC_AndroidManifestNodeParser_ErrorParsingTheXMLFile, (Object)e.getLocalizedMessage());
                AndmoreLogger.error(AndroidManifestParser.class, errMsg, (Throwable)e);
                throw new AndroidException(errMsg);
            }
            catch (IOException e) {
                String errMsg = NLS.bind((String)UtilitiesNLS.EXC_AndroidManifestNodeParser_ErrorReadingTheXMLContent, (Object)e.getLocalizedMessage());
                AndmoreLogger.error(AndroidManifestParser.class, errMsg, (Throwable)e);
                throw new AndroidException(errMsg);
            }
        }
        finally {
            if (stringReader != null) {
                stringReader.close();
            }
        }
        NodeList children = domParser.getDocument().getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            this.parseNode(node, null);
            ++i;
        }
    }

    private void parseNode(Node node, AndroidManifestNode rootNode) {
        AndroidManifestNode amNode;
        AndroidManifestNode.NodeType nodeType = this.identifyNode(node);
        NamedNodeMap attributes = node.getAttributes();
        switch (nodeType) {
            case Manifest: {
                amNode = this.parseManifestNode(attributes);
                break;
            }
            case UsesPermission: {
                amNode = this.parseUsesPermissionNode(attributes);
                break;
            }
            case Permission: {
                amNode = this.parsePermissionNode(attributes);
                break;
            }
            case PermissionTree: {
                amNode = this.parsePermissionTreeNode(attributes);
                break;
            }
            case PermissionGroup: {
                amNode = this.parsePermissionGroupNode(attributes);
                break;
            }
            case Instrumentation: {
                amNode = this.parseInstrumentationNode(attributes);
                break;
            }
            case UsesSdk: {
                amNode = this.parseUsesSdkNode(attributes);
                break;
            }
            case Application: {
                amNode = this.parseApplicationNode(attributes);
                break;
            }
            case Activity: {
                amNode = this.parseActivityNode(attributes);
                break;
            }
            case IntentFilter: {
                amNode = this.parseIntentFilterNode(attributes);
                break;
            }
            case Action: {
                amNode = this.parseActionNode(attributes);
                break;
            }
            case Category: {
                amNode = this.parseCategoryNode(attributes);
                break;
            }
            case Data: {
                amNode = this.parseDataNode(attributes);
                break;
            }
            case MetaData: {
                amNode = this.parseMetadataNode(attributes);
                break;
            }
            case ActivityAlias: {
                amNode = this.parseActivityAliasNode(attributes);
                break;
            }
            case Service: {
                amNode = this.parseServiceNode(attributes);
                break;
            }
            case Receiver: {
                amNode = this.parseReceiverNode(attributes);
                break;
            }
            case Provider: {
                amNode = this.parseProviderNode(attributes);
                break;
            }
            case GrantUriPermission: {
                amNode = this.parseGrantUriPermissionNode(attributes);
                break;
            }
            case UsesLibrary: {
                amNode = this.parseUsesLibraryNode(attributes);
                break;
            }
            case UsesFeature: {
                amNode = this.parseUsesFeatureNode(attributes);
                break;
            }
            case Comment: {
                amNode = this.parseCommentNode((Comment)node);
                break;
            }
            default: {
                amNode = this.parseUnknownNode(node.getNodeName(), attributes);
            }
        }
        NodeList xmlChildNodes = node.getChildNodes();
        int i = 0;
        while (i < xmlChildNodes.getLength()) {
            Node xmlNode = xmlChildNodes.item(i);
            if (xmlNode instanceof Element || xmlNode instanceof Comment) {
                this.parseNode(xmlNode, amNode);
            }
            ++i;
        }
        if (rootNode == null) {
            this.rootNodes.add(amNode);
        } else {
            rootNode.addChild(amNode);
        }
    }

    private AndroidManifestNode.NodeType identifyNode(Node xmlNode) {
        AndroidManifestNode.NodeType identifiedType = AndroidManifestNode.NodeType.Unknown;
        String nodeName = xmlNode.getNodeName();
        if (xmlNode instanceof Comment) {
            identifiedType = AndroidManifestNode.NodeType.Comment;
        } else {
            AndroidManifestNode.NodeType[] nodeTypeArray = AndroidManifestNode.NodeType.values();
            int n = nodeTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AndroidManifestNode.NodeType nodeType = nodeTypeArray[n2];
                String thisNodeName = AndroidManifestNode.getNodeName(nodeType);
                if (thisNodeName.equalsIgnoreCase(nodeName)) {
                    identifiedType = nodeType;
                    break;
                }
                ++n2;
            }
        }
        return identifiedType;
    }
}

