/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.launch.ui;

import com.android.ide.common.xml.AndroidManifestParser;
import com.android.ide.common.xml.ManifestData;
import com.android.io.IAbstractFolder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.andmore.android.ISerialNumbered;
import org.eclipse.andmore.android.SdkUtils;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.device.handlers.OpenNewDeviceWizardHandler;
import org.eclipse.andmore.android.emulator.device.refresh.InstancesListRefresh;
import org.eclipse.andmore.android.launch.ILaunchConfigurationConstants;
import org.eclipse.andmore.android.launch.LaunchUtils;
import org.eclipse.andmore.android.launch.i18n.LaunchNLS;
import org.eclipse.andmore.android.launch.ui.AndroidProjectsSelectionDialog;
import org.eclipse.andmore.android.launch.ui.DeviceSelectionDialog;
import org.eclipse.andmore.io.IFolderWrapper;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.sequoyah.device.framework.events.IInstanceListener;
import org.eclipse.sequoyah.device.framework.events.InstanceEvent;
import org.eclipse.sequoyah.device.framework.events.InstanceEventManager;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class LaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    private static final String NAME = LaunchNLS.UI_LaunchConfigurationTab_Tab_Name;
    private static final Object UPDATE_WIDGETS_EVENT = new Object();
    private Composite mainComposite;
    private String projectName = "";
    private String activityName = "";
    private String deviceName = "";
    private boolean activitySpecified = false;
    private boolean runDefaultActivity = true;
    private final String LAUNCH_DIALOG_HELP = "org.eclipse.andmore.android.launch.mainLaunchTab";
    private Button defaultLauncherButton = null;
    private Button vdlLauncherButton = null;
    private Button deviceNameBrowseButton = null;
    private final IInstanceListener instanceListener = new IInstanceListener(){

        private void fireUpdate() {
            Display currentDisplay = PlatformUI.getWorkbench().getDisplay();
            if (!currentDisplay.isDisposed()) {
                currentDisplay.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        LaunchConfigurationTab.this.updateDeviceChooserButton();
                        LaunchConfigurationTab.this.updateLaunchConfigurationDialog();
                    }
                });
            }
        }

        public void instanceUpdated(InstanceEvent instanceevent) {
            this.fireUpdate();
        }

        public void instanceUnloaded(InstanceEvent instanceevent) {
            this.fireUpdate();
        }

        public void instanceTransitioned(InstanceEvent instanceevent) {
            this.fireUpdate();
        }

        public void instanceLoaded(InstanceEvent instanceevent) {
            this.fireUpdate();
        }

        public void instanceDeleted(InstanceEvent instanceevent) {
            this.fireUpdate();
        }

        public void instanceCreated(InstanceEvent instanceevent) {
            this.fireUpdate();
        }

        public void instanceAboutToTransition(InstanceEvent instanceevent) {
            this.fireUpdate();
        }
    };

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 430;
        gd.heightHint = 130;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)gd);
        this.createMainInfoGroup(main);
        this.setControl((Control)main);
    }

    private void updateDeviceChooserButton() {
        if (!this.deviceNameBrowseButton.isDisposed()) {
            this.deviceNameBrowseButton.setEnabled(true);
        }
    }

    private void createMainInfoGroup(Composite mainComposite) {
        this.mainComposite = mainComposite;
        Group destinationGroup = new Group(mainComposite, 0);
        GridLayout layout = new GridLayout(3, false);
        destinationGroup.setLayout((Layout)layout);
        GridData defaultDestGridData = new GridData(4, 0x1000000, true, false, 3, 1);
        destinationGroup.setLayoutData((Object)defaultDestGridData);
        destinationGroup.setText(LaunchNLS.LaunchComposite_UI_LaunchComposite_DestinationGroupText);
        Label projectNameLabel = new Label((Composite)destinationGroup, 0);
        projectNameLabel.setText(LaunchNLS.UI_LaunchComposite_ProjectNameLabel);
        GridData folderGridData = new GridData(16384, 0x1000000, false, false);
        projectNameLabel.setLayoutData((Object)folderGridData);
        final Text projectNameText = new Text((Composite)destinationGroup, 2052);
        projectNameText.setText(this.projectName);
        folderGridData = new GridData(4, 0x1000000, true, false, 1, 1);
        projectNameText.setLayoutData((Object)folderGridData);
        projectNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.data == UPDATE_WIDGETS_EVENT) {
                    projectNameText.setText(LaunchConfigurationTab.this.projectName);
                } else {
                    LaunchConfigurationTab.this.projectName = projectNameText.getText();
                    LaunchConfigurationTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        Button projectNameBrowseButton = new Button((Composite)destinationGroup, 8);
        folderGridData = new GridData(4, 0x1000000, false, false, 1, 1);
        projectNameBrowseButton.setLayoutData((Object)folderGridData);
        projectNameBrowseButton.setText(LaunchNLS.UI_LaunchComposite_BrowseButton);
        projectNameBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object resultProject;
                AndroidProjectsSelectionDialog dialog = new AndroidProjectsSelectionDialog(LaunchConfigurationTab.this.getShell());
                int result = dialog.open();
                if (result == 0 && (resultProject = dialog.getFirstResult()) instanceof IProject) {
                    IProject project = (IProject)resultProject;
                    projectNameText.setText(project.getName());
                }
            }
        });
        Group activityGroup = new Group(mainComposite, 0);
        GridLayout activityLayout = new GridLayout(3, false);
        activityGroup.setLayout((Layout)activityLayout);
        GridData activityGrid = new GridData(4, 0x1000000, true, false, 3, 1);
        activityGroup.setLayoutData((Object)activityGrid);
        activityGroup.setText(LaunchNLS.UI_LaunchComposite_ActivityGroupLabel);
        final Button defaultActivityButton = new Button((Composite)activityGroup, 16);
        defaultActivityButton.setText(LaunchNLS.UI_LaunchComposite_ActivityDefaultButton);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        defaultActivityButton.setLayoutData((Object)gridData);
        final Button specificActivityButton = new Button((Composite)activityGroup, 16);
        specificActivityButton.setText(LaunchNLS.LaunchConfigurationTab_LaunchButton);
        GridData activityData = new GridData(16384, 0x1000000, false, false);
        specificActivityButton.setLayoutData((Object)activityData);
        final Text activityNameText = new Text((Composite)activityGroup, 2052);
        activityNameText.setText(this.activityName);
        activityData = new GridData(4, 0x1000000, true, false, 1, 1);
        activityNameText.setLayoutData((Object)activityData);
        activityNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.data == UPDATE_WIDGETS_EVENT) {
                    activityNameText.setText(LaunchConfigurationTab.this.activityName);
                } else {
                    LaunchConfigurationTab.this.activityName = activityNameText.getText();
                    LaunchConfigurationTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        final Button activityNameBrowseButton = new Button((Composite)activityGroup, 8);
        activityData = new GridData(4, 0x1000000, false, false, 1, 1);
        activityNameBrowseButton.setLayoutData((Object)activityData);
        activityNameBrowseButton.setText(LaunchNLS.UI_LaunchComposite_BrowseButton);
        activityNameBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            protected static final String ACTIVITY_SELECTION_DIALOG_HELPID = "org.eclipse.andmore.android.launch.activitySelectionDialog";

            private Set<String> getAllActivities(String projectName) {
                String[] tempActivities = null;
                HashSet<String> activities = new HashSet<String>();
                if (projectName.length() != 0) {
                    IProject selectedProject = LaunchUtils.getProject(projectName);
                    String[] stringArray = tempActivities = LaunchUtils.getProjectActivities(selectedProject);
                    int n = tempActivities.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        activities.add(s);
                        ++n2;
                    }
                }
                return activities;
            }

            public void widgetSelected(SelectionEvent e) {
                if (LaunchConfigurationTab.this.projectName.length() == 0) {
                    IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    MessageDialog.openInformation((Shell)ww.getShell(), (String)LaunchNLS.UI_LaunchComposite_ProjectRequiredTitle, (String)LaunchNLS.UI_LaunchComposite_ProjectRequiredMessage);
                } else {
                    ElementListSelectionDialog dialog = new ElementListSelectionDialog(LaunchConfigurationTab.this.getShell(), (ILabelProvider)new LabelProvider(){

                        public String getText(Object element) {
                            String activity = (String)element;
                            return activity;
                        }
                    }){

                        protected Control createDialogArea(Composite parent) {
                            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, 5.ACTIVITY_SELECTION_DIALOG_HELPID);
                            return super.createDialogArea(parent);
                        }
                    };
                    dialog.setTitle(LaunchNLS.UI_LaunchComposite_SelectActivityScreenTitle);
                    dialog.setMessage(LaunchNLS.UI_LaunchComposite_SelectActivityScreenMessage);
                    Object[] allActivities = this.getAllActivities(projectNameText.getText()).toArray();
                    if (allActivities.length == 0) {
                        activityNameText.setText("");
                    } else {
                        dialog.setElements(this.getAllActivities(projectNameText.getText()).toArray());
                        int buttonId = dialog.open();
                        if (buttonId == 0) {
                            String activity = (String)dialog.getFirstResult();
                            activityNameText.setText(activity);
                        }
                    }
                }
            }
        });
        final Button noActivityButton = new Button((Composite)activityGroup, 16);
        noActivityButton.setText(LaunchNLS.LaunchConfigurationTab_DoNothingButton);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        noActivityButton.setLayoutData((Object)gridData);
        defaultActivityButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.data == UPDATE_WIDGETS_EVENT) {
                    defaultActivityButton.setSelection(!LaunchConfigurationTab.this.activitySpecified && LaunchConfigurationTab.this.runDefaultActivity);
                    activityNameText.setEnabled(LaunchConfigurationTab.this.activitySpecified);
                    activityNameBrowseButton.setEnabled(LaunchConfigurationTab.this.activitySpecified);
                } else {
                    LaunchConfigurationTab.this.handleActivityLauncherTypeVariables(defaultActivityButton, specificActivityButton, activityNameText, activityNameBrowseButton);
                }
            }
        });
        specificActivityButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.data == UPDATE_WIDGETS_EVENT) {
                    specificActivityButton.setSelection(LaunchConfigurationTab.this.activitySpecified && !LaunchConfigurationTab.this.runDefaultActivity);
                    activityNameText.setEnabled(LaunchConfigurationTab.this.activitySpecified);
                    activityNameBrowseButton.setEnabled(LaunchConfigurationTab.this.activitySpecified);
                } else {
                    LaunchConfigurationTab.this.handleActivityLauncherTypeVariables(defaultActivityButton, specificActivityButton, activityNameText, activityNameBrowseButton);
                }
            }
        });
        noActivityButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.data == UPDATE_WIDGETS_EVENT) {
                    noActivityButton.setSelection(!LaunchConfigurationTab.this.activitySpecified && !LaunchConfigurationTab.this.runDefaultActivity);
                    activityNameText.setEnabled(LaunchConfigurationTab.this.activitySpecified);
                    activityNameBrowseButton.setEnabled(LaunchConfigurationTab.this.activitySpecified);
                } else {
                    LaunchConfigurationTab.this.handleActivityLauncherTypeVariables(defaultActivityButton, specificActivityButton, activityNameText, activityNameBrowseButton);
                }
            }
        });
        Label deviceNameLabel = new Label((Composite)destinationGroup, 0);
        deviceNameLabel.setText(LaunchNLS.UI_LaunchComposite_DeviceNameLabel);
        GridData deviceGridData = new GridData(16384, 0x1000000, false, false);
        deviceNameLabel.setLayoutData((Object)deviceGridData);
        final Text deviceNameText = new Text((Composite)destinationGroup, 2052);
        deviceNameText.setText(this.deviceName);
        deviceGridData = new GridData(4, 0x1000000, true, false, 1, 1);
        deviceNameText.setLayoutData((Object)deviceGridData);
        deviceNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.data == UPDATE_WIDGETS_EVENT) {
                    deviceNameText.setText(LaunchConfigurationTab.this.deviceName);
                } else {
                    LaunchConfigurationTab.this.deviceName = deviceNameText.getText();
                    LaunchConfigurationTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.deviceNameBrowseButton = new Button((Composite)destinationGroup, 8);
        deviceGridData = new GridData(4, 0x1000000, false, false, 1, 1);
        this.deviceNameBrowseButton.setLayoutData((Object)deviceGridData);
        this.deviceNameBrowseButton.setText(LaunchNLS.UI_LaunchComposite_BrowseButton);
        this.deviceNameBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IProject selectedProject = LaunchUtils.getProject(projectNameText.getText());
                DeviceSelectionDialog dialog = new DeviceSelectionDialog(LaunchConfigurationTab.this.getShell(), LaunchNLS.UI_LaunchComposite_SelectDeviceScreenMessage, selectedProject);
                dialog.setTitle(LaunchNLS.UI_LaunchComposite_SelectDeviceScreenTitle);
                dialog.setMultipleSelection(false);
                dialog.setValidator(new ISelectionStatusValidator(){

                    public IStatus validate(Object[] selection) {
                        Status status = new Status(0, "org.eclipse.andmore.android.launch", "");
                        if (selection.length == 0) {
                            status = new Status(4, "org.eclipse.andmore.android.launch", "No selected instance");
                        }
                        return status;
                    }
                });
                int res = dialog.open();
                if (res == 0) {
                    ISerialNumbered serialNumbered = (ISerialNumbered)dialog.getFirstResult();
                    String selectedDevice = ((IInstance)serialNumbered).getName();
                    deviceNameText.setText(selectedDevice);
                }
            }
        });
        InstanceEventManager.getInstance().addInstanceListener(this.instanceListener);
        Link createNewAvdLink = new Link((Composite)destinationGroup, 0);
        deviceGridData = new GridData(131072, 0x1000000, true, false, 3, 1);
        createNewAvdLink.setLayoutData((Object)deviceGridData);
        createNewAvdLink.setText(LaunchNLS.LaunchConfigurationTab_CreateNewAVDLink);
        createNewAvdLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenNewDeviceWizardHandler handler = new OpenNewDeviceWizardHandler();
                try {
                    handler.execute(new ExecutionEvent());
                }
                catch (ExecutionException executionException) {}
            }
        });
        mainComposite.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                projectNameText.notifyListeners(24, e);
                activityNameText.notifyListeners(24, e);
                deviceNameText.notifyListeners(24, e);
                defaultActivityButton.notifyListeners(13, e);
                specificActivityButton.notifyListeners(13, e);
                noActivityButton.notifyListeners(13, e);
                if (LaunchConfigurationTab.this.defaultLauncherButton != null) {
                    LaunchConfigurationTab.this.defaultLauncherButton.notifyListeners(13, e);
                }
                if (LaunchConfigurationTab.this.vdlLauncherButton != null) {
                    LaunchConfigurationTab.this.vdlLauncherButton.notifyListeners(13, e);
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)mainComposite, "org.eclipse.andmore.android.launch.mainLaunchTab");
    }

    private void handleActivityLauncherTypeVariables(Button defaultActivityButton, Button specificActivityButton, Text activityNameText, Button activityNameBrowseButton) {
        this.activitySpecified = specificActivityButton.getSelection();
        this.runDefaultActivity = defaultActivityButton.getSelection();
        activityNameText.setEnabled(this.activitySpecified);
        activityNameBrowseButton.setEnabled(this.activitySpecified);
        this.updateLaunchConfigurationDialog();
    }

    public String getName() {
        return NAME;
    }

    public Image getImage() {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android.launch", (String)"icons/category.gif").createImage();
    }

    public void dispose() {
        InstanceEventManager.getInstance().removeInstanceListener(this.instanceListener);
        super.dispose();
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        InstancesListRefresh.refresh();
        try {
            this.projectName = configuration.getAttribute(ILaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
            this.activityName = configuration.getAttribute("org.eclipse.andmore.activity", "");
            this.activitySpecified = configuration.getAttribute("org.eclipse.andmore.action", 1) == 1;
            this.runDefaultActivity = configuration.getAttribute("org.eclipse.andmore.action", 1) == 0;
            this.deviceName = configuration.getAttribute("org.eclipse.andmore.android.launch.instanceName", "");
            Event e = new Event();
            e.type = 24;
            e.data = UPDATE_WIDGETS_EVENT;
            this.mainComposite.notifyListeners(24, e);
        }
        catch (CoreException coreException) {}
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(ILaunchConfigurationConstants.ATTR_PROJECT_NAME, this.projectName);
        configuration.setAttribute("org.eclipse.andmore.activity", this.activityName);
        Collection validAvds = SdkUtils.getAllValidVmNames();
        if (validAvds.contains(this.deviceName)) {
            configuration.setAttribute("org.eclipse.andmore.android.launch.instanceName", this.deviceName);
            configuration.setAttribute("org.eclipse.andmore.avd", this.deviceName);
        } else {
            configuration.setAttribute("org.eclipse.andmore.android.launch.instanceName", this.deviceName);
            configuration.removeAttribute("org.eclipse.andmore.avd");
        }
        if (this.activitySpecified) {
            configuration.setAttribute("org.eclipse.andmore.action", 1);
        } else if (this.runDefaultActivity) {
            configuration.setAttribute("org.eclipse.andmore.action", 0);
        } else {
            configuration.setAttribute("org.eclipse.andmore.action", 2);
        }
        LaunchUtils.updateLaunchConfigurationDefaults(configuration);
        IProject project = LaunchUtils.getProject(this.projectName);
        IResource[] mappedResources = null;
        if (project != null) {
            mappedResources = new IResource[]{project};
        }
        configuration.setMappedResources(mappedResources);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(ILaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        configuration.setAttribute("org.eclipse.andmore.activity", "");
        configuration.setAttribute("org.eclipse.andmore.action", 0);
        configuration.setAttribute("org.eclipse.andmore.android.launch.instanceName", "");
        LaunchUtils.setADTLaunchConfigurationDefaults(configuration);
        this.projectName = "";
        this.activityName = "";
        this.deviceName = "";
        this.activitySpecified = false;
        this.runDefaultActivity = true;
        if (this.mainComposite != null) {
            Event e = new Event();
            e.type = 24;
            e.data = UPDATE_WIDGETS_EVENT;
            this.mainComposite.notifyListeners(24, e);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean isValid = true;
        boolean hasWarning = false;
        String projectName = "";
        String instanceName = "";
        String activityName = "";
        try {
            projectName = launchConfig.getAttribute(ILaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
            instanceName = launchConfig.getAttribute("org.eclipse.andmore.android.launch.instanceName", null);
            activityName = launchConfig.getAttribute("org.eclipse.andmore.activity", "");
        }
        catch (CoreException e) {
            AndmoreLogger.error(LaunchConfigurationTab.class, (String)("Error validating launch configuration " + launchConfig.getName()), (Throwable)e);
        }
        IProject project = null;
        if (isValid && projectName.length() > 0) {
            Path projectPath = new Path(projectName);
            if (!projectPath.isValidSegment(projectName)) {
                isValid = false;
                this.setErrorMessage(LaunchNLS.UI_LaunchConfigurationTab_ERR_PROJECT_NOT_EXIST);
            }
            if ((project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null && !project.exists()) {
                isValid = false;
                this.setErrorMessage(LaunchNLS.UI_LaunchConfigurationTab_ERR_PROJECT_NOT_EXIST);
            } else if (project != null && SdkUtils.isLibraryProject((IProject)project)) {
                isValid = false;
                this.setErrorMessage(LaunchNLS.UI_LaunchConfigurationTab_ERR_PROJECT_IS_LIBRARY);
            } else if (project == null) {
                isValid = false;
                this.setErrorMessage(LaunchNLS.UI_LaunchConfigurationTab_ERR_PROJECT_NOT_EXIST);
            }
        } else if (isValid && projectName.length() == 0) {
            this.setErrorMessage(null);
        }
        if (project != null) {
            this.updateDeviceChooserButton();
        }
        if (isValid && instanceName != null && instanceName.length() > 0) {
            IStatus compatible = LaunchUtils.isCompatible(project, instanceName);
            if (compatible == null) {
                this.setErrorMessage(LaunchNLS.UI_LaunchConfigurationTab_ERR_DEVICE_INEXISTENT);
                isValid = false;
            } else if (compatible.getSeverity() == 4) {
                this.setErrorMessage(compatible.getMessage());
                isValid = false;
            } else if (compatible.getSeverity() == 2) {
                this.setMessage(compatible.getMessage());
                hasWarning = true;
            }
        } else if (isValid && instanceName != null && instanceName.length() == 0) {
            this.setErrorMessage(null);
        }
        if (isValid && activityName.length() > 0 && this.activitySpecified) {
            ManifestData.Activity[] currentActivities = null;
            boolean activityValid = false;
            ManifestData manifestParser = null;
            try {
                manifestParser = AndroidManifestParser.parse((IAbstractFolder)new IFolderWrapper((IContainer)project));
            }
            catch (Exception e) {
                AndmoreLogger.error(LaunchUtils.class, (String)"An error occurred trying to parse AndroidManifest", (Throwable)e);
            }
            if (manifestParser != null) {
                currentActivities = manifestParser.getActivities();
            } else {
                isValid = false;
                this.setErrorMessage(LaunchNLS.UI_LaunchConfigurationTab_ERR_INVALID_ACTIVITY);
            }
            ManifestData.Activity[] activityArray = currentActivities;
            int n = currentActivities.length;
            int n2 = 0;
            while (n2 < n) {
                ManifestData.Activity s = activityArray[n2];
                if (s.getName().equals(activityName)) {
                    activityValid = true;
                }
                ++n2;
            }
            if (!activityValid) {
                isValid = false;
                this.setErrorMessage(LaunchNLS.UI_LaunchConfigurationTab_ERR_ACTIVITY_NOT_EXIST);
            }
        } else if (isValid && activityName.length() == 0 && this.activitySpecified) {
            this.setErrorMessage(null);
        }
        if (isValid && (projectName.length() == 0 || this.activitySpecified && activityName.length() == 0 || instanceName.length() == 0)) {
            isValid = false;
            if (projectName.length() == 0) {
                this.setMessage(LaunchNLS.UI_LaunchConfigurationTab_InfoSelectProject);
            } else if (instanceName.length() == 0) {
                this.setMessage(LaunchNLS.UI_LaunchConfigurationTab_InfoSelectInstance);
            } else if (activityName.length() == 0) {
                this.setMessage(LaunchNLS.UI_LaunchConfigurationTab_InfoSelectActivity);
            }
        }
        if (isValid) {
            this.setErrorMessage(null);
            if (!hasWarning) {
                this.setMessage(null);
            }
        }
        return isValid;
    }
}

