/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.remote;

import java.util.Collection;
import java.util.List;
import org.eclipse.andmore.android.AndmoreEventManager;
import org.eclipse.andmore.android.AndroidPlugin;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.DdmsRunnable;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.remote.RemoteDeviceUtils;
import org.eclipse.andmore.android.remote.RemoteDeviceWorkbenchListener;
import org.eclipse.andmore.android.remote.instance.RemoteDeviceInstance;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.device.framework.DeviceUtils;
import org.eclipse.sequoyah.device.framework.events.IInstanceListener;
import org.eclipse.sequoyah.device.framework.events.InstanceAdapter;
import org.eclipse.sequoyah.device.framework.events.InstanceEvent;
import org.eclipse.sequoyah.device.framework.events.InstanceEventManager;
import org.eclipse.sequoyah.device.framework.factory.DeviceTypeRegistry;
import org.eclipse.sequoyah.device.framework.model.IDeviceType;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.IService;
import org.eclipse.sequoyah.device.framework.model.handler.IServiceHandler;
import org.eclipse.sequoyah.device.framework.model.handler.ServiceHandler;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class RemoteDevicePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.andmore.android.remote";
    public static final String DEVICE_ID = "org.eclipse.andmore.android.remote.androidRemoteDevice";
    public static final String STATUS_ONLINE_ID = "org.eclipse.andmore.android.remote.status.connected";
    public static final String WIRELESS_PAGE_CONTEXT_HELP_ID = "org.eclipse.andmore.android.remote.langPage";
    private static RemoteDevicePlugin plugin;
    private static ServiceHandler connectServiceHandler;
    private static ServiceHandler disconnectServiceHandler;
    private static final Runnable sdkLoaderListener;
    private static DdmsRunnable connectedListener;
    private static DdmsRunnable disconnectedListener;
    private static final IInstanceListener tmlListener;
    private static final IWorkbenchListener workbenchListener;

    static {
        connectServiceHandler = null;
        disconnectServiceHandler = null;
        sdkLoaderListener = new Runnable(){

            @Override
            public void run() {
                Collection serialNumbers = DDMSFacade.getConnectedSerialNumbers();
                for (String serial : serialNumbers) {
                    RemoteDeviceUtils.connectDevice(serial);
                }
            }
        };
        connectedListener = new DdmsRunnable(){

            public void run(String serialNumber) {
                RemoteDeviceUtils.connectDevice(serialNumber);
            }
        };
        disconnectedListener = new DdmsRunnable(){

            public void run(String serialNumber) {
                RemoteDeviceUtils.disconnectDevice(serialNumber);
            }
        };
        tmlListener = new InstanceAdapter(){

            public void instanceLoaded(InstanceEvent e) {
                IInstance instance = e.getInstance();
                if (instance instanceof RemoteDeviceInstance) {
                    IDeviceType device = DeviceTypeRegistry.getInstance().getDeviceTypeById(instance.getDeviceTypeId());
                    IService service = DeviceUtils.getServiceById((IDeviceType)device, (String)"org.eclipse.andmore.android.remote.initRemoteService");
                    IServiceHandler handler = service.getHandler();
                    try {
                        handler.run(instance);
                    }
                    catch (SequoyahException e1) {
                        AndmoreLogger.warn((String)("Remote Device: the instance " + instance.getName() + " is in an incorrect state (" + e1.getMessage() + ")."));
                    }
                }
            }
        };
        workbenchListener = new RemoteDeviceWorkbenchListener();
    }

    public void start(BundleContext context) throws Exception {
        AndmoreLogger.debug(RemoteDevicePlugin.class, (String)"Starting Andmore Remote Device Plugin...");
        super.start(context);
        plugin = this;
        AndroidPlugin.getDefault().addSDKLoaderListener(sdkLoaderListener);
        AndmoreEventManager.asyncAddDeviceChangeListeners((DdmsRunnable)connectedListener, (DdmsRunnable)disconnectedListener);
        InstanceEventManager.getInstance().addInstanceListener(tmlListener);
        PlatformUI.getWorkbench().addWorkbenchListener(workbenchListener);
        AndmoreLogger.debug(RemoteDevicePlugin.class, (String)"Starting Andmore Remote Device Plugin started.");
    }

    public void stop(BundleContext context) throws Exception {
        AndroidPlugin.getDefault().removeSDKLoaderListener(sdkLoaderListener);
        AndmoreEventManager.asyncRemoveDeviceChangeListeners((DdmsRunnable)connectedListener, (DdmsRunnable)disconnectedListener);
        InstanceEventManager.getInstance().removeInstanceListener(tmlListener);
        PlatformUI.getWorkbench().removeWorkbenchListener(workbenchListener);
        plugin = null;
        super.stop(context);
    }

    public static RemoteDevicePlugin getDefault() {
        return plugin;
    }

    public static ServiceHandler getConnectServiceHandler() {
        if (connectServiceHandler == null) {
            IDeviceType device = DeviceTypeRegistry.getInstance().getDeviceTypeById(DEVICE_ID);
            List services = device.getServices();
            for (IService service : services) {
                IServiceHandler handler = service.getHandler();
                if (!handler.getService().getId().equals("org.eclipse.andmore.android.remote.connectRemoteService")) continue;
                connectServiceHandler = (ServiceHandler)handler;
                break;
            }
        }
        return connectServiceHandler;
    }

    public static ServiceHandler getDisconnectServiceHandler() {
        if (disconnectServiceHandler == null) {
            IDeviceType device = DeviceTypeRegistry.getInstance().getDeviceTypeById(DEVICE_ID);
            List services = device.getServices();
            for (IService service : services) {
                IServiceHandler handler = service.getHandler();
                if (!handler.getService().getId().equals("org.eclipse.andmore.android.remote.disconnectRemoteService")) continue;
                disconnectServiceHandler = (ServiceHandler)handler;
                break;
            }
        }
        return disconnectServiceHandler;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return RemoteDevicePlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static boolean isWifiServiceEnabled() {
        Boolean enabled = null;
        try {
            enabled = Boolean.parseBoolean(System.getProperty("enableWifiService"));
        }
        catch (Exception exception) {
            enabled = Boolean.FALSE;
        }
        return enabled;
    }
}

