/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.remote.ui.wireless.runnables;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Properties;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.ISerialNumbered;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.remote.i18n.RemoteDeviceNLS;
import org.eclipse.andmore.android.remote.instance.RemoteDeviceInstance;
import org.eclipse.andmore.android.remote.ui.wireless.WirelessWizard;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.device.framework.factory.InstanceRegistry;
import org.eclipse.sequoyah.device.framework.manager.InstanceManager;
import org.eclipse.sequoyah.device.framework.model.IInstance;

public class SwitchFromUSBAndConnectToWirelessRunnable
implements IRunnableWithProgress {
    private final WirelessWizard wirelessWizard;

    public SwitchFromUSBAndConnectToWirelessRunnable(WirelessWizard wirelessWizard) {
        this.wirelessWizard = wirelessWizard;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        boolean isInstanceCreated = false;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        subMonitor.beginTask(RemoteDeviceNLS.SwitchFromUSBAndConnectToWirelessRunnable_MsgCreatingWirelessRemoteDevice, 1000);
        RemoteDeviceInstance remoteDeviceInstance = null;
        IStatus status = Status.OK_STATUS;
        int connectionTimeout = Integer.valueOf(this.wirelessWizard.getProperties().getProperty("org.eclipse.andmore.android.remote.timeoutProperty"));
        try {
            subMonitor.worked(100);
            if (!subMonitor.isCanceled()) {
                try {
                    status = DDMSFacade.switchUSBtoTcpIp((String)this.wirelessWizard.getInstance().getDeviceName(), (String)this.wirelessWizard.getInstance().getSerialNumber(), (String)this.wirelessWizard.getProperties().getProperty("org.eclipse.andmore.android.remote.portProperty"), (int)connectionTimeout, (IProgressMonitor)subMonitor.newChild(300));
                }
                catch (IOException se) {
                    status = this.handleStatusAndLogDuringException(se);
                    throw new InvocationTargetException(se, se.getMessage());
                }
            }
            remoteDeviceInstance = null;
            if (status.getSeverity() != 4 && !subMonitor.isCanceled()) {
                subMonitor.setTaskName(RemoteDeviceNLS.SwitchFromUSBAndConnectToWirelessRunnable_CreatingRemoteDeviceInstance);
                List instanceByName = InstanceRegistry.getInstance().getInstancesByName(this.wirelessWizard.getDeviceName());
                if (instanceByName != null && !instanceByName.isEmpty()) {
                    remoteDeviceInstance = (RemoteDeviceInstance)((Object)instanceByName.get(0));
                } else {
                    try {
                        remoteDeviceInstance = (RemoteDeviceInstance)InstanceManager.createInstance((String)this.wirelessWizard.getDeviceName(), (String)"org.eclipse.andmore.android.remote.androidRemoteDevice", (String)"OFF", (Properties)this.wirelessWizard.getProperties());
                    }
                    catch (SequoyahException se) {
                        status = this.handleStatusAndLogDuringException((Exception)((Object)se));
                        throw new InvocationTargetException(se, se.getMessage());
                    }
                    if (!subMonitor.isCanceled()) {
                        InstanceRegistry.getInstance().addInstance((IInstance)remoteDeviceInstance);
                        isInstanceCreated = true;
                    }
                }
                subMonitor.worked(300);
            }
            if (!subMonitor.isCanceled()) {
                subMonitor.setTaskName(RemoteDeviceNLS.SwitchFromUSBAndConnectToWirelessRunnable_ConnectingToWifiDevice);
                int timeoutAux = connectionTimeout > 60 ? connectionTimeout : 60;
                long timeoutLimit = System.currentTimeMillis() + (long)(timeoutAux * 1000);
                while (!DDMSFacade.isDeviceOnline((String)remoteDeviceInstance.getSerialNumber()) && System.currentTimeMillis() < timeoutLimit) {
                    try {
                        status = DDMSFacade.connectTcpIp((ISerialNumbered)remoteDeviceInstance, (String)this.wirelessWizard.getProperties().getProperty("org.eclipse.andmore.android.remote.hostProperty"), (String)this.wirelessWizard.getProperties().getProperty("org.eclipse.andmore.android.remote.portProperty"), (int)connectionTimeout, (IProgressMonitor)subMonitor.newChild(300));
                    }
                    catch (IOException ioe) {
                        status = this.handleStatusAndLogDuringException(ioe);
                        throw new InvocationTargetException(ioe, ioe.getMessage());
                    }
                }
            }
            if (status != null && status.getSeverity() == 4 && !subMonitor.isCanceled()) {
                if (status.getException() != null) {
                    throw new InvocationTargetException(status.getException());
                }
                throw new InvocationTargetException(new Exception(RemoteDeviceNLS.SwitchFromUSBAndConnectToWirelessRunnable_MsgNotPossibleToConvertUSBToTCPIP));
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException("The switching to TCP/IP connection mode was canceled by the user.");
            }
        }
        finally {
            if (remoteDeviceInstance != null && isInstanceCreated && (status.getSeverity() == 4 || subMonitor.isCanceled())) {
                InstanceRegistry.getInstance().removeInstance(remoteDeviceInstance);
            }
        }
    }

    private IStatus handleStatusAndLogDuringException(Exception exception) {
        AndmoreLogger.error(this.getClass(), (String)exception.getMessage(), (Throwable)exception);
        return new Status(4, "org.eclipse.andmore.android", exception.getMessage());
    }
}

