/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.command;

import java.security.KeyStore;
import org.eclipse.andmore.android.certmanager.command.AbstractHandler2;
import org.eclipse.andmore.android.certmanager.core.KeyStoreUtils;
import org.eclipse.andmore.android.certmanager.core.PasswordProvider;
import org.eclipse.andmore.android.certmanager.event.KeyStoreModelEvent;
import org.eclipse.andmore.android.certmanager.event.KeyStoreModelEventManager;
import org.eclipse.andmore.android.certmanager.exception.KeyStoreManagerException;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.ui.model.ITreeNode;
import org.eclipse.andmore.android.certmanager.ui.model.KeyStoreNode;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.common.utilities.ui.PasswordInputDialog;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public class ChangePasswordKeystoreHandler
extends AbstractHandler2
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ITreeNode node = this.getSelection().get(0);
        if (node instanceof KeyStoreNode) {
            KeyStoreNode keyStoreNode = (KeyStoreNode)node;
            PasswordProvider passwordProvider = new PasswordProvider(keyStoreNode.getFile());
            PasswordInputDialog passwordInputDialog = null;
            boolean cancelledOrChangedPassword = false;
            do {
                if ((passwordInputDialog = new PasswordInputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), NLS.bind((String)CertificateManagerNLS.Passwordinput_EnterOldKeystorePasssword_Message, (Object)keyStoreNode.getName()), true, null, 6)).open() == 0) {
                    String newPassword = passwordInputDialog.getNewPassword();
                    String oldPassword = passwordInputDialog.getOldPassword();
                    if (newPassword == null || oldPassword == null) continue;
                    KeyStore keyStore = null;
                    try {
                        keyStore = KeyStoreUtils.loadKeystore(keyStoreNode.getFile(), oldPassword.toCharArray(), keyStoreNode.getType());
                        try {
                            KeyStoreUtils.changeKeystorePasswd(keyStore, keyStoreNode.getFile(), oldPassword.toCharArray(), newPassword.toCharArray());
                            if (passwordProvider.isPasswordSaved()) {
                                passwordProvider.deleteKeyStoreSavedPassword();
                            }
                            if (passwordInputDialog.needToStorePassword()) {
                                passwordProvider.saveKeyStorePassword(newPassword);
                            }
                            cancelledOrChangedPassword = true;
                            EclipseUtils.showInformationDialog((String)CertificateManagerNLS.PasswordChanged_Info_Title, (String)NLS.bind((String)CertificateManagerNLS.PasswordChanged_Info_Message, (Object)keyStoreNode.getFile()));
                            KeyStoreModelEventManager.getInstance().fireEvent(node, KeyStoreModelEvent.EventType.UPDATE);
                        }
                        catch (KeyStoreManagerException e) {
                            cancelledOrChangedPassword = false;
                            EclipseUtils.showErrorDialog((String)CertificateManagerNLS.ChangePasswordKeystoreHandler_Error_ChangingKeystorePassword, (String)e.getMessage());
                        }
                    }
                    catch (Exception e1) {
                        AndmoreLogger.error(ChangePasswordKeystoreHandler.class, (String)e1.getMessage(), (Throwable)e1);
                        cancelledOrChangedPassword = false;
                        EclipseUtils.showErrorDialog((String)CertificateManagerNLS.ChangePasswordKeystoreHandler_Error_WrongOldKeystorePassword, (String)NLS.bind((String)CertificateManagerNLS.ChangePasswordKeystoreHandler_InvalidOldPassword, (Object)keyStoreNode.getFile()));
                    }
                    continue;
                }
                cancelledOrChangedPassword = true;
            } while (!cancelledOrChangedPassword);
        }
        return null;
    }
}

