/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.core;

import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.andmore.android.certmanager.core.KeyStoreUtils;
import org.eclipse.andmore.android.certmanager.core.SaveStateManager;
import org.eclipse.andmore.android.certmanager.exception.InvalidPasswordException;
import org.eclipse.andmore.android.certmanager.exception.KeyStoreManagerException;
import org.eclipse.andmore.android.certmanager.ui.model.IKeyStore;
import org.eclipse.andmore.android.certmanager.ui.model.KeyStoreNode;
import org.eclipse.andmore.android.common.log.AndmoreLogger;

public class KeyStoreManager {
    public static final String KEYSTORE_TYPE_PKCS12 = "PKCS12";
    public static final String KEYSTORE_TYPE_JCEKS = "JCEKS";
    public static final String KEYSTORE_TYPE_JKS = "JKS";
    private static final String ERROR_TO_ACCESS_KEYSTORE_MAPPING_PERSISTENCE = "Error to access keystore mapping persistence";
    private static KeyStoreManager _instance;
    private List<IKeyStore> keyStores = null;

    public static synchronized KeyStoreManager getInstance() {
        if (_instance == null) {
            _instance = new KeyStoreManager();
        }
        return _instance;
    }

    private KeyStoreManager() {
    }

    public void addKeyStore(IKeyStore keystore) throws KeyStoreManagerException {
        SaveStateManager manager = null;
        try {
            manager = SaveStateManager.getInstance();
            manager.addEntry(keystore.getFile(), keystore.getType());
            this.getKeyStores().add(keystore);
        }
        catch (Exception e) {
            throw new KeyStoreManagerException(ERROR_TO_ACCESS_KEYSTORE_MAPPING_PERSISTENCE, e);
        }
    }

    public void removeKeyStore(IKeyStore keystore) throws KeyStoreManagerException {
        SaveStateManager manager = null;
        try {
            manager = SaveStateManager.getInstance();
            manager.removeEntry(keystore.getFile());
            this.getKeyStores().remove(keystore);
        }
        catch (Exception e) {
            throw new KeyStoreManagerException(ERROR_TO_ACCESS_KEYSTORE_MAPPING_PERSISTENCE, e);
        }
    }

    public void setBackupDate(IKeyStore keyStore, Date backupDate) throws KeyStoreManagerException {
        if (keyStore != null && backupDate != null) {
            try {
                SaveStateManager manager = SaveStateManager.getInstance();
                manager.setBackupDate(keyStore.getFile(), backupDate);
            }
            catch (Exception e) {
                throw new KeyStoreManagerException(ERROR_TO_ACCESS_KEYSTORE_MAPPING_PERSISTENCE, e);
            }
        }
    }

    public void updateKeyStoreType(IKeyStore keyStore) throws KeyStoreManagerException {
        try {
            SaveStateManager manager = SaveStateManager.getInstance();
            if (manager.isKeystoreMapped(keyStore.getFile())) {
                manager.addEntry(keyStore.getFile(), keyStore.getType());
            }
        }
        catch (IOException e) {
            throw new KeyStoreManagerException(ERROR_TO_ACCESS_KEYSTORE_MAPPING_PERSISTENCE, e);
        }
    }

    public List<IKeyStore> getKeyStores() throws KeyStoreManagerException {
        if (this.keyStores == null) {
            this.keyStores = new ArrayList<IKeyStore>();
            SaveStateManager manager = null;
            try {
                manager = SaveStateManager.getInstance();
                if (manager.getMappedKeystores() != null) {
                    for (File keystoreFile : manager.getMappedKeystores()) {
                        SaveStateManager.ViewStateEntry stateEntry = manager.getEntry(keystoreFile);
                        if (stateEntry == null) continue;
                        KeyStoreNode keyStoreNode = new KeyStoreNode(keystoreFile);
                        keyStoreNode.setType(stateEntry.getKeystoreType());
                        keyStoreNode.setLastBackupDate(stateEntry.getBackupDate());
                        this.keyStores.add(keyStoreNode);
                    }
                }
            }
            catch (IOException e) {
                throw new KeyStoreManagerException(ERROR_TO_ACCESS_KEYSTORE_MAPPING_PERSISTENCE, e);
            }
        }
        return this.keyStores;
    }

    public boolean isKeystoreMapped(File keystoreFile) {
        boolean result;
        block3: {
            result = false;
            SaveStateManager manager = null;
            try {
                manager = SaveStateManager.getInstance();
                if (manager.getMappedKeystores() == null) break block3;
                for (File mappedKeystoreFile : manager.getMappedKeystores()) {
                    if (!mappedKeystoreFile.getCanonicalPath().equals(keystoreFile.getCanonicalPath())) continue;
                    result = true;
                    break;
                }
            }
            catch (IOException iOException) {
                result = false;
                AndmoreLogger.error(this.getClass(), (String)"IOException while trying to check if a file is mapped on Signing and Keys view.");
            }
        }
        return result;
    }

    public List<String> getAvailableTypes() {
        ArrayList<String> availableKeystoreTypes = new ArrayList<String>();
        availableKeystoreTypes.add(KEYSTORE_TYPE_JKS);
        availableKeystoreTypes.add(KEYSTORE_TYPE_JCEKS);
        availableKeystoreTypes.add(KEYSTORE_TYPE_PKCS12);
        if (!availableKeystoreTypes.contains(this.getDefaultType())) {
            availableKeystoreTypes.add(this.getDefaultType());
        }
        return availableKeystoreTypes;
    }

    public String getDefaultType() {
        return KeyStore.getDefaultType().toUpperCase();
    }

    public static IKeyStore createKeyStore(File keyStoreFile, String keyStoreType, char[] password) throws KeyStoreManagerException {
        KeyStoreNode keyStoreNode = null;
        try {
            KeyStore keyStore = KeyStoreUtils.createKeystore(keyStoreFile, keyStoreType, password);
            keyStoreNode = new KeyStoreNode(keyStoreFile, keyStore);
        }
        catch (InvalidPasswordException e) {
            AndmoreLogger.error((String)("Invalid password when creating a keystore: " + e.getMessage()));
        }
        return keyStoreNode;
    }

    public static IKeyStore createKeyStore(File keyStoreFile, char[] password) throws KeyStoreManagerException {
        KeyStoreNode keyStoreNode = null;
        try {
            KeyStore keyStore = KeyStoreUtils.createKeystore(keyStoreFile, password);
            keyStoreNode = new KeyStoreNode(keyStoreFile, keyStore);
        }
        catch (InvalidPasswordException e) {
            AndmoreLogger.error((String)("Invalid password when creating a keystore: " + e.getMessage()));
        }
        return keyStoreNode;
    }
}

