/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.job;

import org.eclipse.andmore.android.certmanager.core.PasswordProvider;
import org.eclipse.andmore.android.certmanager.exception.InvalidPasswordException;
import org.eclipse.andmore.android.certmanager.exception.KeyStoreManagerException;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.ui.composite.NewKeyBlock;
import org.eclipse.andmore.android.certmanager.ui.model.CertificateDetailsInfo;
import org.eclipse.andmore.android.certmanager.ui.model.EntryNode;
import org.eclipse.andmore.android.certmanager.ui.model.IKeyStore;
import org.eclipse.andmore.android.certmanager.ui.model.IKeyStoreEntry;
import org.eclipse.andmore.android.certmanager.ui.wizards.CreateKeyWizard;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

public class CreateKeyJob
extends Job {
    private static final String KEY_PASSWORD_SAVED = "Key password saved";
    private static final String SAVING_KEY_PASSWORD = "Saving key password";
    private static final String KEY_CREATED = "Key created";
    private static final String CREATING_KEY = "Creating key";
    private static final String GETTING_KEY_INFO = "Getting key info";
    private static final int NUMBER_OF_TASKS = 5;
    private NewKeyBlock newKeyBlock = null;
    private CertificateDetailsInfo certificateDetailsInfo = null;
    private IKeyStore keystore = null;
    private String keyStorePass;

    public CreateKeyJob(String jobName, NewKeyBlock newKeyBlock, CertificateDetailsInfo certificateDetailsInfo, IKeyStore keystore, String keyStorePass) {
        super(jobName);
        this.certificateDetailsInfo = certificateDetailsInfo;
        this.newKeyBlock = newKeyBlock;
        this.keystore = keystore;
        this.keyStorePass = keyStorePass;
        if (this.keyStorePass == null) {
            try {
                this.keyStorePass = keystore.getPasswordProvider().getKeyStorePassword(false);
            }
            catch (KeyStoreManagerException e) {
                AndmoreLogger.error((String)("Error while accessing keystore manager. " + e.getMessage()));
            }
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        subMonitor.beginTask(CREATING_KEY, 5);
        AndmoreLogger.debug((String)GETTING_KEY_INFO);
        subMonitor.worked(1);
        IKeyStoreEntry entryNode = null;
        try {
            AndmoreLogger.debug((String)CREATING_KEY);
            subMonitor.worked(1);
            String keystorePassword = this.getKeyStorePassword();
            if (keystorePassword != null) {
                entryNode = EntryNode.createSelfSignedNode(this.keystore, keystorePassword, this.certificateDetailsInfo.getAlias(), this.certificateDetailsInfo);
                AndmoreLogger.debug((String)KEY_CREATED);
                subMonitor.worked(1);
                if (this.newKeyBlock.needToSaveKeyPassword()) {
                    AndmoreLogger.debug((String)SAVING_KEY_PASSWORD);
                    subMonitor.worked(1);
                    PasswordProvider passwordProvider = new PasswordProvider(this.keystore.getFile());
                    passwordProvider.savePassword(entryNode.getAlias(), this.newKeyBlock.getKeyPassword());
                    AndmoreLogger.debug((String)KEY_PASSWORD_SAVED);
                    subMonitor.worked(1);
                }
            }
        }
        catch (KeyStoreManagerException e) {
            EclipseUtils.showErrorDialog((String)CertificateManagerNLS.CreateKeyWizard_ErrorCreatingKey_DialogTitle, (String)e.getMessage());
            AndmoreLogger.error(CreateKeyWizard.class, (String)CertificateManagerNLS.CreateKeyWizard_ErrorCreatingKey_DialogTitle, (Throwable)((Object)e));
        }
        subMonitor.done();
        return Status.OK_STATUS;
    }

    private String getKeyStorePassword() throws KeyStoreManagerException {
        boolean invalidPass = true;
        String keystorePassword = this.keyStorePass;
        try {
            if (keystorePassword != null) {
                this.keystore.isPasswordValid(keystorePassword);
                invalidPass = false;
            }
        }
        catch (InvalidPasswordException invalidPasswordException) {
            invalidPass = true;
        }
        while (invalidPass) {
            try {
                this.keystore.isPasswordValid(keystorePassword);
                invalidPass = false;
            }
            catch (InvalidPasswordException invalidPasswordException) {
                invalidPass = true;
                PasswordProvider passwordProvider = new PasswordProvider(this.keystore.getFile());
                keystorePassword = passwordProvider.getKeyStorePassword(true, false);
                if (keystorePassword != null) continue;
                invalidPass = false;
            }
        }
        return keystorePassword;
    }

    public String getCreatedKeyAlias() {
        return this.certificateDetailsInfo.getAlias();
    }

    public IKeyStore getKeyStore() {
        return this.keystore;
    }
}

