/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.packaging.sign;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.eclipse.andmore.android.certmanager.exception.KeyStoreManagerException;
import org.eclipse.andmore.android.certmanager.packaging.sign.SignException;
import org.eclipse.andmore.android.certmanager.packaging.sign.SignatureFile;
import org.eclipse.andmore.android.certmanager.ui.model.IKeyStoreEntry;
import org.eclipse.andmore.android.common.log.AndmoreLogger;

public class SignatureBlockFile {
    private SignatureFile signatureFile;
    private IKeyStoreEntry keystoreEntry;
    private String keyEntryPassword;

    public SignatureBlockFile(SignatureFile signatureFile, IKeyStoreEntry keystoreEntry, String keyEntryPassword) {
        this.keyEntryPassword = keyEntryPassword;
        this.keystoreEntry = keystoreEntry;
        this.signatureFile = signatureFile;
    }

    public String toString() {
        String result = new String();
        try {
            result = "META-INF" + "/" + "CERT" + "." + this.getBlockAlgorithm();
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            AndmoreLogger.error((String)"Could not generate signature block file name.");
        }
        catch (KeyStoreException keyStoreException) {
            AndmoreLogger.error((String)"Could not generate signature block file name.");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            AndmoreLogger.error((String)"Could not generate signature block file name.");
        }
        catch (KeyStoreManagerException keyStoreManagerException) {
            AndmoreLogger.error((String)"Could not generate signature block file name.");
        }
        return result;
    }

    private String getBlockAlgorithm() throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, KeyStoreManagerException {
        return this.keystoreEntry.getKey(this.keyEntryPassword).getAlgorithm();
    }

    public void write(OutputStream outputStream) throws IOException, SignException, UnrecoverableKeyException, KeyStoreException, KeyStoreManagerException, NoSuchAlgorithmException, InvalidKeyException, CertificateEncodingException, OperatorCreationException, CMSException {
        X509Certificate[] certChain = new X509Certificate[]{this.keystoreEntry.getX509Certificate()};
        if (certChain.length > 0) {
            X509Certificate publicKey = certChain[0];
            PrivateKey privateKey = this.keystoreEntry.getPrivateKey(this.keyEntryPassword);
            String blockalgorithm = this.getBlockAlgorithm();
            if (!blockalgorithm.equalsIgnoreCase("DSA") && !blockalgorithm.equalsIgnoreCase("RSA")) {
                AndmoreLogger.error(SignatureBlockFile.class, (String)"Signing block algorithm not supported. Key algorithm must be DSA or RSA");
                throw new SignException("Signing block algorithm not supported");
            }
            String signatureAlgorithm = "SHA1with" + blockalgorithm;
            Security.addProvider((Provider)new BouncyCastleProvider());
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            certList.add(publicKey);
            JcaCertStore certs = new JcaCertStore(certList);
            ContentSigner signer = new JcaContentSignerBuilder(signatureAlgorithm).build(privateKey);
            CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
            generator.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build()).setDirectSignature(true).build(signer, publicKey));
            generator.addCertificates((Store)certs);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.signatureFile.write(baos);
            CMSProcessableByteArray cmsdata = new CMSProcessableByteArray(baos.toByteArray());
            CMSSignedData signeddata = generator.generate((CMSTypedData)cmsdata, false);
            ASN1InputStream asn1 = new ASN1InputStream(signeddata.getEncoded());
            DEROutputStream dos = new DEROutputStream(outputStream);
            dos.writeObject((ASN1Encodable)asn1.readObject());
            dos.flush();
            dos.close();
            asn1.close();
        }
        AndmoreLogger.info(SignatureBlockFile.class, (String)"Created signature block file");
    }
}

