/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.ui.dialogs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.ui.dialogs.BackupContentProvider;
import org.eclipse.andmore.android.certmanager.ui.dialogs.BackupLabelProvider;
import org.eclipse.andmore.android.certmanager.ui.model.IKeyStore;
import org.eclipse.andmore.android.certmanager.ui.model.ITreeNode;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.common.utilities.FileUtil;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class BackupDialog
extends TitleAreaDialog {
    private static final String ZIP_EXT = ".zip";
    private static final String WIZARD_BANNER = "icons/wizban/backup_keystore_wiz.png";
    private static final String BACKUP_KEYSTORE_HELP_ID = "org.eclipse.andmore.android.certmanager.backup_keystore";
    private final IContentProvider contentProvider;
    private final IBaseLabelProvider labelProvider;
    private CheckboxTableViewer tableViewer;
    private Object input;
    private final String title;
    private File archiveFile;
    private List<String> selectedKeyStores;
    private String archivePath;
    private boolean verifyOverwrite;
    private Button selectAllButton;

    public BackupDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.contentProvider = new BackupContentProvider();
        this.labelProvider = new BackupLabelProvider();
        this.title = CertificateManagerNLS.BackupDialog_Diag_Title;
        this.archivePath = "";
        this.selectedKeyStores = new ArrayList<String>();
        this.setTitleImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android.certmanager", (String)WIZARD_BANNER).createImage());
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        this.setTitle(CertificateManagerNLS.BackupDialog_DialogTitle);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), BACKUP_KEYSTORE_HELP_ID);
        Composite dialogArea = new Composite(parent, 4);
        dialogArea.setLayout((Layout)new GridLayout());
        dialogArea.setLayoutData((Object)new GridData(4, 4, true, true));
        Group pathGroup = new Group(dialogArea, 32);
        pathGroup.setText(CertificateManagerNLS.BackupDialog_Backup_File);
        pathGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        pathGroup.setLayout((Layout)new GridLayout(3, false));
        Label pathLabel = new Label((Composite)pathGroup, 0);
        pathLabel.setText(CertificateManagerNLS.BackupDialog_Path);
        pathLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        final Text pathText = new Text((Composite)pathGroup, 2048);
        pathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BackupDialog.this.archivePath = pathText.getText();
                BackupDialog.this.archiveFile = new File(BackupDialog.this.archivePath);
                BackupDialog.this.verifyOverwrite = true;
                BackupDialog.this.validate();
            }
        });
        Button browseButton = new Button((Composite)pathGroup, 8);
        browseButton.setText(CertificateManagerNLS.BackupDialog_Browse);
        browseButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(BackupDialog.this.getShell(), 8192);
                fileDialog.setFilterExtensions(new String[]{"*.zip"});
                fileDialog.setOverwrite(true);
                String choosenPath = fileDialog.open();
                pathText.setText(choosenPath);
                BackupDialog.this.verifyOverwrite = false;
                super.widgetSelected(e);
            }
        });
        Group keystoresGroup = new Group(dialogArea, 32);
        keystoresGroup.setText(CertificateManagerNLS.BackupDialog_KeyStores);
        keystoresGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        keystoresGroup.setLayout((Layout)new GridLayout(1, false));
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)keystoresGroup, (int)2848);
        this.tableViewer.setContentProvider(this.contentProvider);
        this.tableViewer.setLabelProvider(this.labelProvider);
        this.tableViewer.setInput(this.input);
        this.selectKeystores();
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.widthHint = 400;
        layoutData.heightHint = 200;
        this.tableViewer.getControl().setLayoutData((Object)layoutData);
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                String keyStore = null;
                Object element = event.getElement();
                if (element instanceof String) {
                    keyStore = (String)element;
                }
                if (keyStore != null) {
                    if (event.getChecked()) {
                        BackupDialog.this.selectedKeyStores.add(keyStore);
                    } else {
                        BackupDialog.this.selectedKeyStores.remove(keyStore);
                    }
                }
                BackupDialog.this.updateSelectAllState();
                BackupDialog.this.validate();
            }
        });
        Composite selectButtonArea = new Composite((Composite)keystoresGroup, 0);
        selectButtonArea.setLayout((Layout)new GridLayout(1, true));
        selectButtonArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.selectAllButton = new Button(selectButtonArea, 32);
        this.selectAllButton.setText(CertificateManagerNLS.BackupDialog_Select_All);
        this.selectAllButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BackupDialog.this.tableViewer.setAllChecked(BackupDialog.this.selectAllButton.getSelection());
                BackupDialog.this.selectedKeyStores.clear();
                Object[] objectArray = BackupDialog.this.tableViewer.getCheckedElements();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    String keyStoreEl = (String)element;
                    BackupDialog.this.selectedKeyStores.add(keyStoreEl);
                    ++n2;
                }
                BackupDialog.this.validate();
                super.widgetSelected(e);
            }
        });
        this.updateSelectAllState();
        this.setMessage(CertificateManagerNLS.BackupDialog_Default_Message);
        return dialogArea;
    }

    private void updateSelectAllState() {
        if (this.tableViewer.getCheckedElements().length == this.tableViewer.getTable().getItems().length) {
            this.selectAllButton.setSelection(true);
        } else {
            this.selectAllButton.setSelection(false);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return buttonBar;
    }

    protected void okPressed() {
        boolean canContinue = true;
        if (this.verifyOverwrite && this.archiveFile.exists()) {
            boolean canOvewrite = EclipseUtils.showQuestionDialog((String)CertificateManagerNLS.BackupDialog_Archive_Exists_Title, (String)NLS.bind((String)CertificateManagerNLS.BackupDialog_Archive_Exists_Message, (Object)this.archiveFile));
            if (!canOvewrite) {
                canContinue = false;
            } else {
                this.archiveFile.delete();
            }
        }
        if (canContinue) {
            if (!FileUtil.canWrite((File)this.archiveFile)) {
                EclipseUtils.showErrorDialog((String)CertificateManagerNLS.BackupDialog_Fail_Writing_Archive_Title, (String)NLS.bind((String)CertificateManagerNLS.BackupDialog_Fail_Writing_Archive_Message, (Object)this.archiveFile));
            } else {
                this.setErrorMessage(null);
                super.okPressed();
            }
        }
    }

    private void validate() {
        boolean isValid = true;
        boolean hasWarn = false;
        Path path = new Path(this.archivePath);
        try {
            if (this.archivePath.isEmpty() || !path.isValidPath(this.archiveFile.getCanonicalPath())) {
                this.setErrorMessage(CertificateManagerNLS.BackupDialog_Invalid_Destination_Title);
                isValid = false;
            }
        }
        catch (IOException iOException) {
            this.setErrorMessage(CertificateManagerNLS.BackupDialog_Invalid_Destination_Title);
            isValid = false;
        }
        if (isValid && this.archiveFile.exists() && this.archiveFile.isDirectory()) {
            this.setErrorMessage(CertificateManagerNLS.BackupDialog_Invalid_Destination_Message);
            isValid = false;
        }
        if (isValid && !this.archiveFile.isAbsolute()) {
            this.setMessage(NLS.bind((String)CertificateManagerNLS.BackupDialog_Non_Absolute_Path, (Object)this.archiveFile.getAbsolutePath()), 2);
            hasWarn = true;
        }
        if (isValid) {
            if (this.selectedKeyStores.isEmpty()) {
                this.setErrorMessage(CertificateManagerNLS.BackupDialog_Select_KeyStore);
                isValid = false;
            } else {
                this.setErrorMessage(null);
                if (!hasWarn) {
                    this.setMessage(CertificateManagerNLS.BackupDialog_Default_Message);
                }
                isValid = true;
            }
        }
        this.getButton(0).setEnabled(isValid);
    }

    public void setInput(Object input) {
        if (this.tableViewer != null) {
            this.tableViewer.setInput(input);
        }
        this.input = input;
    }

    public File getArchiveFile() {
        return this.archiveFile.getName().toLowerCase().endsWith(ZIP_EXT) ? this.archiveFile : new File(String.valueOf(this.archivePath) + ZIP_EXT);
    }

    public List<String> getSelectedKeyStores() {
        return this.selectedKeyStores;
    }

    public void selectKeyStores(List<ITreeNode> keystores) {
        for (ITreeNode treeNode : keystores) {
            if (!(treeNode instanceof IKeyStore)) continue;
            IKeyStore keystore = (IKeyStore)((Object)treeNode);
            this.selectedKeyStores.add(keystore.getFile().getAbsolutePath());
        }
    }

    private void selectKeystores() {
        TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            item.setChecked(this.selectedKeyStores.contains(item.getText()));
            ++n2;
        }
    }
}

