/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.codesnippets;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.andmore.android.codesnippets.CodeSnippetsPlugin;
import org.eclipse.andmore.android.codesnippets.i18n.AndroidSnippetsNLS;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.manifest.AndroidProjectManifestFile;
import org.eclipse.andmore.android.model.manifest.AndroidManifestFile;
import org.eclipse.andmore.android.model.manifest.dom.AndroidManifestNode;
import org.eclipse.andmore.android.model.manifest.dom.ManifestNode;
import org.eclipse.andmore.android.model.manifest.dom.UsesPermissionNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.common.snippets.core.ISnippetItem;
import org.eclipse.wst.common.snippets.core.ISnippetsEntry;
import org.eclipse.wst.common.snippets.internal.ui.SnippetsView;
import org.eclipse.wst.common.snippets.ui.DefaultSnippetInsertion;

public class AndroidPermissionInsertSnippet
extends DefaultSnippetInsertion {
    protected void doInsert(IEditorPart editorPart, ITextEditor textEditor, IDocument document, ITextSelection textSelection) throws BadLocationException {
        String replacement = this.getInsertString(editorPart.getEditorSite().getShell());
        boolean permissionsAdded = this.addPermissionToManifest(editorPart, replacement);
        SnippetsView snippetsView = (SnippetsView)EclipseUtils.getActiveView((String)"org.eclipse.wst.common.snippets.internal.ui.SnippetsView");
        ISnippetsEntry snippetEntry = snippetsView.getSelectedEntry();
        if (snippetEntry != null) {
            String snippetLabel = snippetEntry.getLabel();
            if (CodeSnippetsPlugin.getDefault() != null) {
                AndmoreLogger.collectUsageData((String)"inserted", (String)"codesnippet", (String)("Codesnippet '" + snippetLabel + "' used. Permission added: " + permissionsAdded), (String)"org.eclipse.wst.common.snippets.internal.ui.SnippetsView", (String)CodeSnippetsPlugin.getDefault().getBundle().getVersion().toString());
            }
        }
        super.doInsert(editorPart, textEditor, document, textSelection);
    }

    private boolean addPermissionToManifest(IEditorPart editorPart, String snippetText) {
        boolean needToAddPermission = snippetText.contains("AndroidManifest.xml must have the following permission:");
        boolean shouldAddToManifest = false;
        if (needToAddPermission) {
            List<String> neededPermissions = this.getNeededPermissions(snippetText);
            ArrayList<String> permissionsToBeAdded = new ArrayList<String>(neededPermissions.size());
            IEditorInput input = editorPart.getEditorInput();
            FileEditorInput fileEditorInput = null;
            ManifestNode manifestNode = null;
            if (input instanceof FileEditorInput) {
                fileEditorInput = (FileEditorInput)input;
                IFile file = fileEditorInput.getFile();
                IProject project = file.getProject();
                try {
                    AndroidManifestFile androidManifestFile = AndroidProjectManifestFile.getFromProject((IProject)project);
                    manifestNode = androidManifestFile.getManifestNode();
                }
                catch (Exception exception) {}
            }
            if (manifestNode != null) {
                for (String neededPermission : neededPermissions) {
                    if (this.permAlreadyExists(manifestNode, neededPermission)) continue;
                    permissionsToBeAdded.add(neededPermission);
                }
            }
            if (!permissionsToBeAdded.isEmpty()) {
                StringBuilder permMsgBuilder = new StringBuilder();
                for (String neededPermission : permissionsToBeAdded) {
                    permMsgBuilder.append(AndroidSnippetsNLS.AndroidPermissionInsertSnippet_PermissionPrefix);
                    permMsgBuilder.append(neededPermission);
                    permMsgBuilder.append(AndroidSnippetsNLS.AndroidPermissionInsertSnippet_PermissionSuffix);
                }
                shouldAddToManifest = EclipseUtils.showQuestionDialog((String)AndroidSnippetsNLS.AndroidPermissionInsertSnippet_Msg_AddToManifest_Title, (String)NLS.bind((String)AndroidSnippetsNLS.AndroidPermissionInsertSnippet_Msg_AddToManifest_Msg, (Object)permMsgBuilder.toString()));
                if (shouldAddToManifest) {
                    AndroidManifestFile androidManifestFile = null;
                    manifestNode = null;
                    if (fileEditorInput != null) {
                        this.addPermissionToManifest(permissionsToBeAdded, (IEditorInput)fileEditorInput, androidManifestFile, manifestNode);
                    }
                }
            }
        }
        return shouldAddToManifest;
    }

    private List<String> getNeededPermissions(String snippetText) {
        StringTokenizer lineToken = new StringTokenizer(snippetText, "\n\r");
        ArrayList<String> neededPermissions = new ArrayList<String>(lineToken.countTokens());
        while (lineToken.hasMoreTokens()) {
            String line = lineToken.nextToken();
            if (!line.contains("<uses-permission")) continue;
            String permNameToAdd = null;
            String androidNameStr = "android:name=\"";
            int beginIndex = line.indexOf(androidNameStr);
            int endIndex = line.indexOf("\"/>");
            if (beginIndex > 0 && endIndex > 0) {
                permNameToAdd = line.substring(beginIndex + androidNameStr.length(), endIndex);
                neededPermissions.add(permNameToAdd);
                continue;
            }
            AndmoreLogger.error(AndroidPermissionInsertSnippet.class, (String)("Permission code snippet was not in the right format to enable insert of uses-permission on androidmanifest.xml" + snippetText));
        }
        return neededPermissions;
    }

    private void addPermissionToManifest(List<String> neededPermissions, IEditorInput input, AndroidManifestFile androidManifestFile, ManifestNode manifestNode) {
        IFile file = ((FileEditorInput)input).getFile();
        IProject project = file.getProject();
        try {
            androidManifestFile = AndroidProjectManifestFile.getFromProject((IProject)project);
            manifestNode = androidManifestFile.getManifestNode();
            for (String neededPermission : neededPermissions) {
                if (this.permAlreadyExists(manifestNode, neededPermission)) continue;
                UsesPermissionNode usesPermissionNode = new UsesPermissionNode(neededPermission);
                manifestNode.addChild((AndroidManifestNode)usesPermissionNode);
            }
            AndroidProjectManifestFile.saveToProject((IProject)project, (AndroidManifestFile)androidManifestFile, (boolean)true);
        }
        catch (Exception e) {
            AndmoreLogger.error(AndroidPermissionInsertSnippet.class, (String)"Error adding snippet permissions to androidmanifest.xml.", (Throwable)e);
        }
    }

    private boolean permAlreadyExists(ManifestNode manifestNode, String neededPermission) {
        boolean permAlreadyExists = false;
        List permissionsNode = manifestNode.getUsesPermissionNodes();
        if (permissionsNode != null) {
            for (UsesPermissionNode existentPermissionNode : permissionsNode) {
                String permName = (String)existentPermissionNode.getNodeProperties().get("android:name");
                if (permName == null || !permName.equals(neededPermission)) continue;
                permAlreadyExists = true;
                break;
            }
        }
        return permAlreadyExists;
    }

    public void dragSetData(DragSourceEvent event, ISnippetItem item) {
        IEditorPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        this.addPermissionToManifest(part, item.getContentString());
        super.dragSetData(event, item);
    }
}

