/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.common;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class CommonPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.andmore.android.common";
    private static final String JDBC_DRIVER_PATH = "res/androidjdbc.jar";
    public static final String JDBC_DRIVER_INSTANCE_NAME = "andmore_jdbc_driver";
    private static CommonPlugin plugin;

    public void start(BundleContext context) throws Exception {
        AndmoreLogger.debug(CommonPlugin.class, "Starting Andmore Common Plugin...");
        super.start(context);
        plugin = this;
        AndmoreLogger.debug(CommonPlugin.class, "Andmore Common Plugin started.");
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static CommonPlugin getDefault() {
        return plugin;
    }

    public String getDriverPath() {
        String driverPath = "";
        if (this.getDbResourceFile(JDBC_DRIVER_PATH) != null) {
            driverPath = this.getDbResourceFile(JDBC_DRIVER_PATH).getAbsolutePath();
        }
        return driverPath;
    }

    private File getDbResourceFile(String pathAtPlugin) {
        URL location = this.getBundle().getEntry(pathAtPlugin);
        AndmoreLogger.debug("JDBC Driver Location:" + location + " JDBC Driver getBundle().getLocation():" + this.getBundle().getLocation());
        File file = null;
        try {
            Path p = new Path(FileLocator.toFileURL((URL)location).getFile());
            AndmoreLogger.debug("JDBC Driver Path:" + p.toOSString());
            file = p.toFile();
        }
        catch (IOException e) {
            AndmoreLogger.error("Error while trying to locate jdbc driver into db plugin:" + e.getMessage());
        }
        return file;
    }
}

