/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.common.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.AuthState;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.i18n.UtilitiesNLS;
import org.eclipse.andmore.android.common.utilities.ui.LoginPasswordDialogCreator;
import org.eclipse.core.internal.net.ProxyManager;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.internal.net.auth.NetAuthenticator;

public class HttpUtils {
    private static final int ONE_SECOND = 1000;
    private static final Map<String, Credentials> authenticationRealmCache = new HashMap<String, Credentials>();
    private GetMethod getMethod;

    public InputStream getInputStreamForUrl(String url, IProgressMonitor monitor) throws IOException {
        return this.getInputStreamForUrl(url, monitor, true);
    }

    private InputStream getInputStreamForUrl(String url, IProgressMonitor monitor, boolean returnStream) throws IOException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        subMonitor.beginTask(UtilitiesNLS.HttpUtils_MonitorTask_PreparingConnection, 300);
        AndmoreLogger.debug(HttpUtils.class, "Verifying proxy usage for opening http connection");
        IProxyService proxyService = ProxyManager.getProxyManager();
        IProxyData proxyData = null;
        if (proxyService.isProxiesEnabled() || proxyService.isSystemProxiesEnabled()) {
            Authenticator.setDefault((Authenticator)new NetAuthenticator());
            if (url.startsWith("https")) {
                proxyData = proxyService.getProxyData("HTTPS");
                AndmoreLogger.debug(HttpUtils.class, "Using https proxy");
            } else if (url.startsWith("http")) {
                proxyData = proxyService.getProxyData("HTTP");
                AndmoreLogger.debug(HttpUtils.class, "Using http proxy");
            } else {
                AndmoreLogger.debug(HttpUtils.class, "Not using any proxy");
            }
        }
        HttpClient client = null;
        client = new HttpClient();
        if (proxyData != null) {
            if (proxyData.getHost() != null) {
                client.getHostConfiguration().setProxy(proxyData.getHost(), proxyData.getPort());
            }
            if (proxyData.getUserId() != null && proxyData.getUserId().trim().length() > 0) {
                UsernamePasswordCredentials cred = new UsernamePasswordCredentials(proxyData.getUserId(), proxyData.getPassword() == null ? "" : proxyData.getPassword());
                client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)cred);
            }
        }
        InputStream streamForUrl = null;
        this.getMethod = new GetMethod(url);
        this.getMethod.setFollowRedirects(true);
        HttpMethodParams params = this.getMethod.getParams();
        params.setSoTimeout(15000);
        this.getMethod.setParams(params);
        boolean trying = true;
        Credentials credentials = null;
        subMonitor.worked(100);
        subMonitor.setTaskName(UtilitiesNLS.HttpUtils_MonitorTask_ContactingSite);
        do {
            AndmoreLogger.info(HttpUtils.class, "Attempting to make a connection");
            HttpClientParams clientParams = client.getParams();
            clientParams.setIntParameter("http.protocol.max-redirects", 1);
            clientParams.setSoTimeout(5000);
            client.setParams(clientParams);
            client.executeMethod((HttpMethod)this.getMethod);
            if (subMonitor.isCanceled()) break;
            AuthState authorizationState = this.getMethod.getHostAuthState();
            String authenticationRealm = authorizationState.getRealm();
            if (this.getMethod.getStatusCode() == 401) {
                AndmoreLogger.debug(HttpUtils.class, "Client requested authentication; retrieving credentials");
                credentials = authenticationRealmCache.get(authenticationRealm);
                if (credentials == null) {
                    AndmoreLogger.debug(HttpUtils.class, "Credentials not found; prompting user for login/password");
                    subMonitor.setTaskName(UtilitiesNLS.HttpUtils_MonitorTask_WaitingAuthentication);
                    LoginPasswordDialogCreator dialogCreator = new LoginPasswordDialogCreator(url);
                    if (dialogCreator.openLoginPasswordDialog() == 0) {
                        credentials = new UsernamePasswordCredentials(dialogCreator.getTypedLogin(), dialogCreator.getTypedPassword());
                    } else {
                        trying = false;
                        subMonitor.setCanceled(true);
                    }
                }
                if (credentials != null) {
                    AuthScope scope = new AuthScope(null, -1, authenticationRealm);
                    client.getState().setCredentials(scope, credentials);
                }
                subMonitor.worked(100);
                continue;
            }
            if (this.getMethod.getStatusCode() == 200) {
                AndmoreLogger.debug(HttpUtils.class, "Http connection suceeded");
                subMonitor.setTaskName(UtilitiesNLS.HttpUtils_MonitorTask_RetrievingSiteContent);
                if (authenticationRealm != null && credentials != null) {
                    authenticationRealmCache.put(authenticationRealm, credentials);
                } else {
                    subMonitor.worked(100);
                }
                AndmoreLogger.info(HttpUtils.class, "Retrieving site content");
                if (returnStream) {
                    streamForUrl = this.getMethod.getResponseBodyAsStream();
                }
                trying = false;
                subMonitor.worked(100);
                continue;
            }
            trying = false;
            subMonitor.worked(200);
        } while (trying);
        subMonitor.done();
        return streamForUrl;
    }

    public boolean isConnectionOk(String url) {
        try {
            this.getInputStreamForUrl(url, null, false);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void releaseConnection() {
        if (this.getMethod != null) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    HttpUtils.this.getMethod.releaseConnection();
                }
            };
            t.start();
        }
    }
}

