/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.common.utilities.ui;

import org.eclipse.andmore.android.common.utilities.i18n.UtilitiesNLS;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PasswordInputDialog
extends Dialog {
    private static final int SMALL_TEXT_SIZE = 64;
    private String newPassword = null;
    private String oldPassword = null;
    private final boolean changePassword;
    private Text newPasswordConfirmText;
    private Text newPasswordText;
    private Text oldPasswordText;
    private Label message;
    private Label image;
    private final String description;
    private Button saveCheckBox;
    private boolean needToStorePassword = true;
    private int passwordMinimumSize = 1;

    public PasswordInputDialog(Shell parent, String description, boolean changePassword, String oldPassword, int passwordMinimumSize) {
        super(parent);
        this.changePassword = changePassword;
        this.description = description;
        if (changePassword) {
            this.oldPassword = oldPassword;
        }
        this.passwordMinimumSize = passwordMinimumSize;
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayoutData((Object)new GridData(1808));
        mainComposite.setLayout((Layout)new GridLayout(2, false));
        Composite messageComposite = new Composite(mainComposite, 0);
        GridData layoutData = new GridData(4, 0x1000000, true, false, 2, 1);
        messageComposite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        messageComposite.setLayout((Layout)layout);
        this.image = new Label(messageComposite, 0);
        this.image.setVisible(false);
        layoutData = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.image.setLayoutData((Object)layoutData);
        this.message = new Label(messageComposite, 0);
        this.message.setText(this.description);
        layoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        this.message.setLayoutData((Object)layoutData);
        Label oldPasswordLabel = new Label(mainComposite, 0);
        layoutData = new GridData(16384, 0x1000000, false, false, 1, 1);
        oldPasswordLabel.setLayoutData((Object)layoutData);
        oldPasswordLabel.setText(UtilitiesNLS.Passwordinput_Enterpassword_Label);
        this.oldPasswordText = new Text(mainComposite, 0x400804);
        this.oldPasswordText.setTextLimit(64);
        layoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        layoutData.minimumWidth = 150;
        this.oldPasswordText.setLayoutData((Object)layoutData);
        if (this.oldPassword != null) {
            this.oldPasswordText.setEnabled(false);
            this.oldPasswordText.setText(this.oldPassword);
            oldPasswordLabel.setEnabled(false);
        }
        this.oldPasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PasswordInputDialog.this.updateStatus();
            }
        });
        if (this.changePassword) {
            Label separator = new Label(mainComposite, 258);
            layoutData = new GridData(4, 0x1000000, true, false, 2, 1);
            separator.setLayoutData((Object)layoutData);
            Label passwordLabel = new Label(mainComposite, 0);
            layoutData = new GridData(16384, 0x1000000, false, false, 1, 1);
            passwordLabel.setLayoutData((Object)layoutData);
            passwordLabel.setText(UtilitiesNLS.Passwordinput_Enternewpassword_Label);
            this.newPasswordText = new Text(mainComposite, 0x400804);
            this.newPasswordText.setTextLimit(64);
            layoutData = new GridData(4, 0x1000000, true, false, 1, 1);
            layoutData.minimumWidth = 150;
            this.newPasswordText.setLayoutData((Object)layoutData);
            Label passwordConfirmLabel = new Label(mainComposite, 0);
            layoutData = new GridData(16384, 0x1000000, false, false, 1, 1);
            passwordConfirmLabel.setLayoutData((Object)layoutData);
            passwordConfirmLabel.setText(UtilitiesNLS.Passwordinput_Reenterpassword_Label);
            this.newPasswordConfirmText = new Text(mainComposite, 0x400804);
            this.newPasswordConfirmText.setTextLimit(64);
            layoutData = new GridData(4, 0x1000000, true, false, 1, 1);
            layoutData.minimumWidth = 150;
            this.newPasswordConfirmText.setLayoutData((Object)layoutData);
            this.newPasswordText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PasswordInputDialog.this.updateStatus();
                }
            });
            this.newPasswordConfirmText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PasswordInputDialog.this.updateStatus();
                }
            });
        }
        this.saveCheckBox = new Button(mainComposite, 32);
        this.saveCheckBox.setText(UtilitiesNLS.PasswordProvider_SaveThisPassword);
        this.saveCheckBox.setSelection(false);
        GridData gridData = new GridData(16384, 0x1000000, false, false, 2, 1);
        this.saveCheckBox.setLayoutData((Object)gridData);
        return mainComposite;
    }

    public void updateStatus() {
        String errorMessage = null;
        int severity = 0;
        if (this.oldPasswordText.getText().length() > 0) {
            this.oldPassword = this.oldPasswordText.getText();
        } else {
            errorMessage = "";
            this.oldPassword = null;
        }
        if (errorMessage == null && this.changePassword) {
            if (this.newPasswordText.getText().length() < this.passwordMinimumSize) {
                errorMessage = NLS.bind((String)UtilitiesNLS.Passwordinput_Error_PasswordMinimumSize, (Object)this.passwordMinimumSize);
                severity = 3;
            } else if (!this.newPasswordText.getText().equals(this.newPasswordConfirmText.getText())) {
                errorMessage = UtilitiesNLS.Passwordinput_Error_Passwordnotmatch;
                severity = 3;
            } else {
                this.newPassword = this.newPasswordText.getText();
            }
        }
        this.setErrorMessage(errorMessage, severity);
    }

    private void setErrorMessage(String errorMsg, int severity) {
        if (errorMsg == null || severity == 0) {
            this.image.setImage(null);
            this.image.setVisible(false);
            this.message.setText(this.description);
            this.getButton(0).setEnabled(errorMsg == null);
        } else {
            this.message.setText(errorMsg);
            this.message.setVisible(true);
            switch (severity) {
                case 3: {
                    this.image.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
                    break;
                }
                case 1: {
                    this.image.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK"));
                    break;
                }
                case 2: {
                    this.image.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
                    break;
                }
                default: {
                    this.image.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
                }
            }
            this.image.setVisible(true);
            this.getButton(0).setEnabled(false);
        }
        this.message.getParent().layout();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public String getOldPassword() {
        return this.oldPassword;
    }

    public boolean needToStorePassword() {
        return this.needToStorePassword;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UtilitiesNLS.Passwordinput_Title);
        newShell.setMinimumSize(500, 200);
        newShell.layout(true);
    }

    protected void okPressed() {
        this.needToStorePassword = this.saveCheckBox.getSelection();
        super.okPressed();
    }
}

