/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.common.utilities.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.andmore.android.common.utilities.ui.Country;

public class ToolsCountries {
    private static ToolsCountries instance = null;
    private final ResourceBundle bundle = ResourceBundle.getBundle("countries");

    private ToolsCountries() {
    }

    public static synchronized ToolsCountries getInstance() {
        if (instance == null) {
            instance = new ToolsCountries();
        }
        return instance;
    }

    public List<Country> getCountries() {
        ArrayList<Country> toReturn = new ArrayList<Country>();
        try {
            Enumeration<String> keys = this.bundle.getKeys();
            while (keys.hasMoreElements()) {
                String countryCode = keys.nextElement();
                String countryName = this.bundle.getString(countryCode);
                toReturn.add(new Country(countryCode, countryName));
            }
            Collections.sort(toReturn);
        }
        catch (MissingResourceException missingResourceException) {
            toReturn = new ArrayList();
        }
        return toReturn;
    }
}

