/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.model.manifest.dom;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.android.model.manifest.dom.AbstractBuildingBlockNode;
import org.eclipse.andmore.android.model.manifest.dom.ActionNode;
import org.eclipse.andmore.android.model.manifest.dom.AndroidManifestNode;
import org.eclipse.andmore.android.model.manifest.dom.CategoryNode;
import org.eclipse.andmore.android.model.manifest.dom.IntentFilterNode;
import org.eclipse.andmore.android.model.manifest.dom.MetadataNode;
import org.eclipse.core.runtime.IStatus;

public class ActivityNode
extends AbstractBuildingBlockNode {
    private static Map<String, ConfigChanges> configChanges;
    private static Map<String, LaunchMode> launchModes;
    private static Map<String, ScreenOrientation> screenOrientations;
    private Boolean propAllowTaskReparenting = null;
    private Boolean propAlwaysRetainTaskState = null;
    private Boolean propClearTaskOnLaunch = null;
    private final List<ConfigChanges> propConfigChanges = new LinkedList<ConfigChanges>();
    private Boolean propExcludeFromRecents = null;
    private Boolean propFinishOnTaskLaunch = null;
    private LaunchMode propLaunchMode = null;
    private Boolean propMultiprocess = null;
    private ScreenOrientation propScreenOrientation = null;
    private Boolean propStateNotNeeded = null;
    private String propTaskAffinity = null;
    private String propTheme = null;

    static {
        defaultProperties.add("android:allowTaskReparenting");
        defaultProperties.add("android:alwaysRetainTaskState");
        defaultProperties.add("android:clearTaskOnLaunch");
        defaultProperties.add("android:configChanges");
        defaultProperties.add("android:excludeFromRecents");
        defaultProperties.add("android:finishOnTaskLaunch");
        defaultProperties.add("android:launchMode");
        defaultProperties.add("android:multiprocess");
        defaultProperties.add("android:screenOrientation");
        defaultProperties.add("android:stateNotNeeded");
        defaultProperties.add("android:taskAffinity");
        defaultProperties.add("android:theme");
        configChanges = new HashMap<String, ConfigChanges>();
        Enum[] enumArray = ConfigChanges.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigChanges configChange = enumArray[n2];
            configChanges.put(configChange.toString().toLowerCase(), configChange);
            ++n2;
        }
        launchModes = new HashMap<String, LaunchMode>();
        enumArray = LaunchMode.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum launchMode = enumArray[n2];
            launchModes.put(launchMode.toString().toLowerCase(), (LaunchMode)launchMode);
            ++n2;
        }
        screenOrientations = new HashMap<String, ScreenOrientation>();
        enumArray = ScreenOrientation.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum screenOrientation = enumArray[n2];
            screenOrientations.put(screenOrientation.toString().toLowerCase(), (ScreenOrientation)screenOrientation);
            ++n2;
        }
    }

    public static String getConfigChangeName(ConfigChanges configChange) {
        String name = "";
        if (configChange != null) {
            name = configChange.toString();
        }
        return name;
    }

    public static ConfigChanges getConfigChangeFromName(String configChangeName) {
        ConfigChanges configChange = null;
        if (configChangeName != null) {
            String ccn = configChangeName.trim().toLowerCase();
            configChange = configChanges.get(ccn);
        }
        return configChange;
    }

    public static String getLaunchModeName(LaunchMode launchMode) {
        String name = "";
        if (launchMode != null) {
            name = launchMode.toString();
        }
        return name;
    }

    public static LaunchMode getLaunchModeFromName(String launchModeName) {
        LaunchMode launchMode = null;
        if (launchModeName != null) {
            String lmn = launchModeName.trim().toLowerCase();
            launchMode = launchModes.get(lmn);
        }
        return launchMode;
    }

    public static String getScreenOrientationName(ScreenOrientation screenOrientation) {
        String name = "";
        if (screenOrientation != null) {
            name = screenOrientation.toString();
        }
        return name;
    }

    public static ScreenOrientation getScreenOrientationFromName(String screenOrientationName) {
        ScreenOrientation screenOrientation = null;
        if (screenOrientationName != null) {
            String son = screenOrientationName.trim().toLowerCase();
            screenOrientation = screenOrientations.get(son);
        }
        return screenOrientation;
    }

    public ActivityNode(String name) {
        super(name);
    }

    @Override
    protected boolean canContains(AndroidManifestNode.NodeType nodeType) {
        return nodeType == AndroidManifestNode.NodeType.IntentFilter || nodeType == AndroidManifestNode.NodeType.MetaData || nodeType == AndroidManifestNode.NodeType.Comment;
    }

    @Override
    protected void addAdditionalProperties() {
        super.addAdditionalProperties();
        if (this.propAllowTaskReparenting != null) {
            this.properties.put("android:allowTaskReparenting", this.propAllowTaskReparenting.toString());
        }
        if (this.propAlwaysRetainTaskState != null) {
            this.properties.put("android:alwaysRetainTaskState", this.propAlwaysRetainTaskState.toString());
        }
        if (this.propClearTaskOnLaunch != null) {
            this.properties.put("android:clearTaskOnLaunch", this.propClearTaskOnLaunch.toString());
        }
        if (this.propConfigChanges != null && !this.propConfigChanges.isEmpty()) {
            String configChangesString = "";
            int i = 0;
            while (i < this.propConfigChanges.size() - 1) {
                configChangesString = String.valueOf(configChangesString) + ActivityNode.getConfigChangeName(this.propConfigChanges.get(i)) + "|";
                ++i;
            }
            configChangesString = String.valueOf(configChangesString) + ActivityNode.getConfigChangeName(this.propConfigChanges.get(this.propConfigChanges.size() - 1));
            this.properties.put("android:configChanges", configChangesString);
        }
        if (this.propExcludeFromRecents != null) {
            this.properties.put("android:excludeFromRecents", this.propExcludeFromRecents.toString());
        }
        if (this.propFinishOnTaskLaunch != null) {
            this.properties.put("android:finishOnTaskLaunch", this.propFinishOnTaskLaunch.toString());
        }
        if (this.propLaunchMode != null) {
            this.properties.put("android:launchMode", ActivityNode.getLaunchModeName(this.propLaunchMode));
        }
        if (this.propMultiprocess != null) {
            this.properties.put("android:multiprocess", this.propMultiprocess.toString());
        }
        if (this.propScreenOrientation != null) {
            this.properties.put("android:screenOrientation", ActivityNode.getScreenOrientationName(this.propScreenOrientation));
        }
        if (this.propStateNotNeeded != null) {
            this.properties.put("android:stateNotNeeded", this.propStateNotNeeded.toString());
        }
        if (this.propTaskAffinity != null) {
            this.properties.put("android:taskAffinity", this.propTaskAffinity);
        }
        if (this.propTheme != null) {
            this.properties.put("android:theme", this.propTheme);
        }
    }

    @Override
    public AndroidManifestNode.NodeType getNodeType() {
        return AndroidManifestNode.NodeType.Activity;
    }

    @Override
    protected boolean isNodeValid() {
        return super.isNodeValid();
    }

    public Boolean getAllowTaskReparenting() {
        return this.propAllowTaskReparenting;
    }

    public void setAllowTaskReparenting(Boolean allowTaskReparenting) {
        this.propAllowTaskReparenting = allowTaskReparenting;
    }

    public Boolean getAlwaysRetainTaskState() {
        return this.propAlwaysRetainTaskState;
    }

    public void setAlwaysRetainTaskState(Boolean alwaysRetainTaskState) {
        this.propAlwaysRetainTaskState = alwaysRetainTaskState;
    }

    public Boolean getClearTaskOnLaunch() {
        return this.propClearTaskOnLaunch;
    }

    public void setClearTaskOnLaunch(Boolean clearTaskOnLaunch) {
        this.propClearTaskOnLaunch = clearTaskOnLaunch;
    }

    public ConfigChanges[] getConfigChanges() {
        ConfigChanges[] configChanges = null;
        if (this.propConfigChanges != null) {
            configChanges = new ConfigChanges[this.propConfigChanges.size()];
            configChanges = this.propConfigChanges.toArray(configChanges);
        }
        return configChanges;
    }

    public void addConfigChanges(ConfigChanges configChanges) {
        if (configChanges != null && !this.propConfigChanges.contains((Object)configChanges)) {
            this.propConfigChanges.add(configChanges);
        }
    }

    public Boolean getExcludeFromRecents() {
        return this.propExcludeFromRecents;
    }

    public void setExcludeFromRecents(Boolean excludeFromRecents) {
        this.propExcludeFromRecents = excludeFromRecents;
    }

    public Boolean getFinishOnTaskLaunch() {
        return this.propFinishOnTaskLaunch;
    }

    public void setFinishOnTaskLaunch(Boolean finishOnTaskLaunch) {
        this.propFinishOnTaskLaunch = finishOnTaskLaunch;
    }

    public LaunchMode getLaunchMode() {
        return this.propLaunchMode;
    }

    public void setLaunchMode(LaunchMode launchMode) {
        this.propLaunchMode = launchMode;
    }

    public Boolean getMultiprocess() {
        return this.propMultiprocess;
    }

    public void setMultiprocess(Boolean multiProcess) {
        this.propMultiprocess = multiProcess;
    }

    public ScreenOrientation getScreenOrientation() {
        return this.propScreenOrientation;
    }

    public void setScreenOrientation(ScreenOrientation screenOrientation) {
        this.propScreenOrientation = screenOrientation;
    }

    public Boolean getStateNotNeeded() {
        return this.propStateNotNeeded;
    }

    public void setStateNotNeeded(Boolean stateNotNeeded) {
        this.propStateNotNeeded = stateNotNeeded;
    }

    public String getTaskAffinity() {
        return this.propTaskAffinity;
    }

    public void setTaskAffinity(String taskAffinity) {
        this.propTaskAffinity = taskAffinity;
    }

    public String getTheme() {
        return this.propTheme;
    }

    public void setTheme(String theme) {
        this.propTheme = theme;
    }

    public void addIntentFilterNode(IntentFilterNode intentFilter) {
        if (intentFilter != null && !this.children.contains(intentFilter)) {
            this.children.add(intentFilter);
        }
    }

    public List<IntentFilterNode> getIntentFilterNodes() {
        LinkedList<IntentFilterNode> intentFilters = new LinkedList<IntentFilterNode>();
        AndroidManifestNode[] androidManifestNodeArray = this.getAllChildrenFromType(AndroidManifestNode.NodeType.IntentFilter);
        int n = androidManifestNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AndroidManifestNode node = androidManifestNodeArray[n2];
            intentFilters.add((IntentFilterNode)node);
            ++n2;
        }
        return intentFilters;
    }

    public void removeIntentFilterNode(IntentFilterNode intentFilter) {
        if (intentFilter != null) {
            this.children.remove(intentFilter);
        }
    }

    public boolean setAsMainActivity(boolean isMainActivity) {
        boolean result = false;
        if (isMainActivity) {
            if (this.isMainActivity()) {
                result = true;
            } else {
                IntentFilterNode intentFilterNode = new IntentFilterNode();
                ActionNode actionMainNode = new ActionNode("android.intent.action.MAIN");
                CategoryNode categoryLauncherNode = new CategoryNode("android.intent.category.LAUNCHER");
                intentFilterNode.addActionNode(actionMainNode);
                intentFilterNode.addCategoryNode(categoryLauncherNode);
                this.addIntentFilterNode(intentFilterNode);
                result = true;
            }
        } else if (!this.isMainActivity()) {
            result = true;
        } else {
            for (IntentFilterNode intentFilterNode : this.getIntentFilterNodes()) {
                ActionNode actionMainNode = intentFilterNode.getActionNode("android.intent.action.MAIN");
                CategoryNode categoryLauncherNode = intentFilterNode.getCategoryNode("android.intent.category.LAUNCHER");
                if (actionMainNode == null || categoryLauncherNode == null) continue;
                intentFilterNode.removeActionNode(actionMainNode);
                intentFilterNode.removeCategoryNode(categoryLauncherNode);
                if (intentFilterNode.isEmpty()) {
                    this.removeIntentFilterNode(intentFilterNode);
                }
                result = true;
            }
        }
        return result;
    }

    public boolean isMainActivity() {
        boolean isMainActivity = false;
        boolean hasActionMain = false;
        boolean hasCategoryLauncher = false;
        for (IntentFilterNode intent : this.getIntentFilterNodes()) {
            hasActionMain = false;
            hasCategoryLauncher = false;
            for (ActionNode actionNode : intent.getActionNodes()) {
                if (!actionNode.getName().equals("android.intent.action.MAIN")) continue;
                hasActionMain = true;
                break;
            }
            for (CategoryNode categoryNode : intent.getCategoryNodes()) {
                if (!categoryNode.getName().equals("android.intent.category.LAUNCHER")) continue;
                hasCategoryLauncher = true;
            }
            if (!hasActionMain || !hasCategoryLauncher) continue;
            isMainActivity = true;
            break;
        }
        return isMainActivity;
    }

    public void addMetadataNode(MetadataNode metadata) {
        if (metadata != null && !this.children.contains(metadata)) {
            this.children.add(metadata);
        }
    }

    public List<MetadataNode> getMetadataNodes() {
        LinkedList<MetadataNode> metadatas = new LinkedList<MetadataNode>();
        AndroidManifestNode[] androidManifestNodeArray = this.getAllChildrenFromType(AndroidManifestNode.NodeType.MetaData);
        int n = androidManifestNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AndroidManifestNode node = androidManifestNodeArray[n2];
            metadatas.add((MetadataNode)node);
            ++n2;
        }
        return metadatas;
    }

    public void removeMetadataNode(MetadataNode metadata) {
        if (metadata != null) {
            this.children.remove(metadata);
        }
    }

    @Override
    protected List<IStatus> getSpecificNodeProblems() {
        return null;
    }

    public static enum ConfigChanges {
        mcc,
        mnc,
        locale,
        touchscreen,
        keyboard,
        keyboardHidden,
        navigation,
        orientation,
        fontscale;

    }

    public static enum LaunchMode {
        standard,
        singleTop,
        singleTask,
        singleInstance;

    }

    public static enum ScreenOrientation {
        unspecified,
        user,
        behind,
        landscape,
        portrait,
        sensor,
        nonsensor;

    }
}

