/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.model.manifest.dom;

import java.util.List;
import java.util.Map;
import org.eclipse.andmore.android.model.manifest.dom.AndroidManifestNode;
import org.eclipse.andmore.android.model.manifest.dom.IAndroidManifestProperties;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;

public class MetadataNode
extends AndroidManifestNode
implements IAndroidManifestProperties {
    private String propName = null;
    private String propResource = null;
    private String propValue = null;

    static {
        defaultProperties.add("android:name");
        defaultProperties.add("android:resource");
        defaultProperties.add("android:value");
    }

    public MetadataNode(String name) {
        Assert.isLegal((name != null ? 1 : 0) != 0);
        this.propName = name;
    }

    @Override
    protected boolean canContains(AndroidManifestNode.NodeType nodeType) {
        return false;
    }

    @Override
    public Map<String, String> getNodeProperties() {
        this.properties.clear();
        this.properties.put("android:name", this.propName);
        if (this.propResource != null && this.propResource.trim().length() > 0) {
            this.properties.put("android:resource", this.propResource);
        }
        if (this.propValue != null && this.propValue.length() > 0) {
            this.properties.put("android:value", this.propValue);
        }
        return this.properties;
    }

    @Override
    public AndroidManifestNode.NodeType getNodeType() {
        return AndroidManifestNode.NodeType.MetaData;
    }

    @Override
    protected boolean isNodeValid() {
        boolean containsOnlyValue;
        boolean containsOnlyResource = this.propResource != null && this.propValue == null;
        boolean bl = containsOnlyValue = this.propResource == null && this.propValue != null;
        return this.propName.trim().length() > 0 && (containsOnlyResource || containsOnlyValue);
    }

    public String getName() {
        return this.propName;
    }

    public void setName(String name) {
        Assert.isLegal((name != null ? 1 : 0) != 0);
        this.propName = name;
    }

    public String getResource() {
        return this.propResource;
    }

    public void setResource(String resource) {
        this.propResource = resource;
    }

    public String getValue() {
        return this.propValue;
    }

    public void setValue(String value) {
        this.propValue = value;
    }

    @Override
    protected List<IStatus> getSpecificNodeProblems() {
        return null;
    }
}

