/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.launch;

import com.android.ide.common.xml.AndroidManifestParser;
import com.android.ide.common.xml.ManifestData;
import com.android.io.IAbstractFolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.ISerialNumbered;
import org.eclipse.andmore.android.SdkUtils;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.core.devfrm.DeviceFrameworkManager;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.emulator.logic.IAndroidLogicInstance;
import org.eclipse.andmore.android.launch.ILaunchConfigurationConstants;
import org.eclipse.andmore.android.launch.i18n.LaunchNLS;
import org.eclipse.andmore.io.IFolderWrapper;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sequoyah.device.framework.factory.InstanceRegistry;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class LaunchUtils {
    public static String getSerialNumberForInstance(String instanceName) {
        String serial = null;
        List list = InstanceRegistry.getInstance().getInstances();
        for (IInstance inst : list) {
            if (!inst.getName().equals(instanceName) || !(inst instanceof ISerialNumbered)) continue;
            serial = ((ISerialNumbered)inst).getSerialNumber();
        }
        return serial;
    }

    public static IProject getProject(String projectName) {
        IProject project = null;
        Path projectPath = new Path(projectName);
        if (projectPath.isValidSegment(projectName)) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return project;
    }

    public static boolean isProjectSupported(IProject project) {
        boolean hasNature = false;
        boolean isLibrary = true;
        if (project != null && project.isOpen()) {
            try {
                hasNature = project.hasNature("org.eclipe.andmore.AndroidNature");
                isLibrary = SdkUtils.isLibraryProject((IProject)project);
            }
            catch (CoreException coreException) {}
        }
        return hasNature && !isLibrary;
    }

    public static IProject[] getSupportedProjects() {
        IProject[] projectsName;
        ArrayList<IProject> projectCollection = new ArrayList<IProject>();
        IProject[] iProjectArray = projectsName = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projectsName.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible() && LaunchUtils.isProjectSupported(project)) {
                projectCollection.add(project);
            }
            ++n2;
        }
        return projectCollection.toArray(new IProject[projectCollection.size()]);
    }

    public static String[] getProjectActivities(IProject project) {
        String[] activities = null;
        ManifestData.Activity[] adtActivities = null;
        try {
            ManifestData manifestParser = AndroidManifestParser.parse((IAbstractFolder)new IFolderWrapper((IContainer)project));
            if (manifestParser != null) {
                adtActivities = manifestParser.getActivities();
            }
            if (adtActivities != null && adtActivities.length > 0) {
                activities = new String[adtActivities.length];
                int i = 0;
                while (i < adtActivities.length) {
                    activities[i] = adtActivities[i].getName();
                    ++i;
                }
            }
        }
        catch (Exception e) {
            AndmoreLogger.error(LaunchUtils.class, (String)"An error occurred trying to parse AndroidManifest", (Throwable)e);
        }
        return activities;
    }

    public static void setADTLaunchConfigurationDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(ILaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, true);
        configuration.setAttribute("org.eclipse.andmore.action", 0);
        configuration.setAttribute("org.eclipse.andmore.target", ILaunchConfigurationConstants.ATTR_TARGET_MODE_DEFAULT.toString());
        configuration.setAttribute("org.eclipse.andmore.speed", 0);
        configuration.setAttribute("org.eclipse.andmore.delay", 0);
        configuration.setAttribute("org.eclipse.andmore.wipedata", false);
        configuration.setAttribute("org.eclipse.andmore.nobootanim", false);
        configuration.setAttribute("org.eclipse.andmore.commandline", "");
    }

    public static void updateLaunchConfigurationDefaults(ILaunchConfigurationWorkingCopy configuration) {
        try {
            IAndroidEmulatorInstance deviceInstance;
            String deviceName = configuration.getAttribute("org.eclipse.andmore.android.launch.instanceName", "");
            if (deviceName != null && !deviceName.equals("") && (deviceInstance = DeviceFrameworkManager.getInstance().getInstanceByName(deviceName)) instanceof IAndroidLogicInstance) {
                String commandLine = ((IAndroidLogicInstance)deviceInstance).getCommandLineArguments();
                configuration.setAttribute("org.eclipse.andmore.commandline", commandLine);
            }
        }
        catch (CoreException e) {
            AndmoreLogger.error(LaunchUtils.class, (String)("Error updating launch configuration values for : " + configuration.getName()), (Throwable)e);
        }
    }

    public static Shell getActiveWorkbenchShell() {
        class ActiveShellRunnable
        implements Runnable {
            private Shell shell = null;

            ActiveShellRunnable() {
            }

            public Shell getShell() {
                return this.shell;
            }

            @Override
            public void run() {
                IWorkbenchWindow activeWorkbench = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (activeWorkbench != null) {
                    this.shell = activeWorkbench.getShell();
                }
            }
        }
        ActiveShellRunnable runnable = new ActiveShellRunnable();
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)runnable);
        return runnable.getShell();
    }

    public static void showErrorDialog(final String title, final String message) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                MessageDialog.openError((Shell)ww.getShell(), (String)title, (String)message);
            }
        });
    }

    public static ISerialNumbered resolveInstance(List<IInstance> instances) {
        ISerialNumbered theInstance = null;
        Iterator<IInstance> it = instances.iterator();
        while (it.hasNext() && theInstance == null) {
            IInstance anInstance = it.next();
            if (!(anInstance instanceof ISerialNumbered)) continue;
            theInstance = (ISerialNumbered)anInstance;
        }
        return theInstance;
    }

    public static IStatus isCompatible(IProject project, String instanceName) {
        IStatus status = null;
        List instances = InstanceRegistry.getInstance().getInstances();
        for (IInstance instance : instances) {
            if (!instanceName.equals(instance.getName()) || !(instance instanceof ISerialNumbered)) continue;
            status = LaunchUtils.isCompatible(project, (ISerialNumbered)instance);
            break;
        }
        return status;
    }

    public static IStatus isCompatible(IProject project, ISerialNumbered instance) {
        int minSdkVersion;
        Object compatible = null;
        int projectAPILevel = SdkUtils.getApiVersionNumberForProject((IProject)project);
        String minSdkVersionStr = SdkUtils.getMinSdkVersion((IProject)project);
        boolean isProjectTargetAPlatform = SdkUtils.getTarget((IProject)project) != null ? SdkUtils.getTarget((IProject)project).isPlatform() : true;
        try {
            minSdkVersion = Integer.parseInt(minSdkVersionStr);
        }
        catch (Exception exception) {
            minSdkVersion = projectAPILevel;
        }
        String projectTarget = SdkUtils.getTargetNameForProject((IProject)project);
        if (instance instanceof IAndroidEmulatorInstance) {
            IAndroidEmulatorInstance emulatorInstance = (IAndroidEmulatorInstance)instance;
            int emulatorApi = emulatorInstance.getAPILevel();
            String emulatorTarget = emulatorInstance.getTarget();
            if (emulatorApi >= minSdkVersion) {
                String emulatorInstanceName = emulatorInstance.getName();
                String emulatorInstanceBaseTarget = SdkUtils.getBaseTarget((String)emulatorInstanceName);
                boolean isEmulatorTargetAPlatform = SdkUtils.isPlatformTarget((String)emulatorInstanceName);
                compatible = emulatorTarget.equals(projectTarget) ? Status.OK_STATUS : (!isEmulatorTargetAPlatform && emulatorInstanceBaseTarget.equals(projectTarget) ? Status.OK_STATUS : new Status(2, "org.eclipse.andmore.android.launch", NLS.bind((String)LaunchNLS.UI_LaunchConfigurationTab_WARN_DEVICE_INCOMPATIBLE, (Object)emulatorApi, (Object)projectAPILevel)));
            } else {
                compatible = new Status(4, "org.eclipse.andmore.android.launch", NLS.bind((String)LaunchNLS.UI_LaunchConfigurationTab_ERR_EMULATOR_INCOMPATIBLE, (Object)emulatorTarget, (Object)projectTarget));
            }
        } else if (instance != null) {
            int deviceSdkVersion = -1;
            int tries = 0;
            while (tries < 5 && deviceSdkVersion <= 0) {
                try {
                    deviceSdkVersion = Integer.parseInt(DDMSFacade.getDeviceProperty((String)instance.getSerialNumber(), (String)"ro.build.version.sdk"));
                }
                catch (NumberFormatException numberFormatException) {
                    deviceSdkVersion = 0;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                ++tries;
            }
            compatible = deviceSdkVersion < minSdkVersion ? new Status(4, "org.eclipse.andmore.android.launch", NLS.bind((String)LaunchNLS.UI_LaunchConfigurationTab_ERR_DEVICE_INCOMPATIBLE, (Object)deviceSdkVersion, (Object)projectAPILevel)) : (deviceSdkVersion == projectAPILevel ? (!isProjectTargetAPlatform ? new Status(2, "org.eclipse.andmore.android.launch", LaunchNLS.UI_LaunchConfigurationTab_WARN_DEVICE_TARGET_MISSING) : Status.OK_STATUS) : new Status(2, "org.eclipse.andmore.android.launch", NLS.bind((String)LaunchNLS.UI_LaunchConfigurationTab_WARN_DEVICE_INCOMPATIBLE, (Object)deviceSdkVersion, (Object)projectAPILevel)));
        }
        return compatible;
    }

    public static Collection<ISerialNumbered> filterInstancesByProject(Collection<ISerialNumbered> allInstances, IProject project) {
        LinkedList<ISerialNumbered> filteredInstances = new LinkedList<ISerialNumbered>();
        for (ISerialNumbered instance : allInstances) {
            IStatus compatible = LaunchUtils.isCompatible(project, instance);
            if (compatible.getSeverity() == 4) continue;
            filteredInstances.add(instance);
        }
        return filteredInstances;
    }
}

