/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.remote;

import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.ISerialNumbered;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.devices.DevicesManager;
import org.eclipse.andmore.android.remote.RemoteDeviceInstanceBuilder;
import org.eclipse.andmore.android.remote.RemoteDevicePlugin;
import org.eclipse.andmore.android.remote.instance.RemoteDeviceInstance;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.device.framework.model.AbstractMobileInstance;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.IInstanceBuilder;
import org.eclipse.ui.PlatformUI;

public class RemoteDeviceUtils {
    public static void connectDevice(final String serialNumber) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DDMSFacade.isRemote((String)serialNumber)) {
                    boolean onlineDevice;
                    ISerialNumbered instance = DevicesManager.getInstance().getDeviceBySerialNumber(serialNumber);
                    boolean isTransitioning = instance != null ? ((AbstractMobileInstance)instance).getStateMachineHandler().isTransitioning() : false;
                    AndmoreLogger.debug((String)("Handle remote device connected event. Serial Number: " + serialNumber + " Instance: " + instance + " Transitioning: " + isTransitioning));
                    if ((instance == null || instance != null && !isTransitioning) && (onlineDevice = RemoteDeviceUtils.waitForDeviceToBeOnline(serialNumber, instance))) {
                        if (instance == null) {
                            try {
                                AndmoreLogger.debug((String)"Connecting Remote Device: device doesn't exist, create a new instance");
                                DevicesManager.getInstance().createInstanceForDevice(serialNumber, "org.eclipse.andmore.android.remote.androidRemoteDevice", (IInstanceBuilder)RemoteDeviceUtils.getInstanceBuilder(serialNumber), "org.eclipse.andmore.android.remote.initRemoteService");
                            }
                            catch (SequoyahException e) {
                                AndmoreLogger.error((String)("Connecting Remote Device: error while creating device instance " + e.getMessage()));
                            }
                        }
                        try {
                            instance = DevicesManager.getInstance().getDeviceBySerialNumber(serialNumber);
                            AndmoreLogger.debug((String)"Connecting Remote Device: the TmL service will be called");
                            HashMap<String, Boolean> arguments = new HashMap<String, Boolean>();
                            arguments.put("dummy", true);
                            RemoteDevicePlugin.getConnectServiceHandler().run((IInstance)instance, arguments);
                        }
                        catch (Exception e) {
                            AndmoreLogger.error((String)("Error when running TmL connect service: " + e.getMessage()));
                        }
                    }
                }
            }
        });
    }

    public static void disconnectDevice(String serialNumber) {
        if (DDMSFacade.isRemote((String)serialNumber)) {
            ISerialNumbered instance = DevicesManager.getInstance().getDeviceBySerialNumber(serialNumber);
            AndmoreLogger.debug((String)("Handle remote device disconnected event. Serial Number: " + serialNumber + " Instance: " + instance));
            if (instance != null) {
                boolean isVolatile;
                Object volatileProperty = ((RemoteDeviceInstance)instance).getProperties().get("org.eclipse.andmore.android.remote.volatileProperty");
                boolean bl = isVolatile = volatileProperty != null ? (Boolean)volatileProperty : false;
                if (!isVolatile) {
                    try {
                        AndmoreLogger.debug((String)"Disconnecting Remote Device: the device is NOT volatile, the TmL service will be called");
                        HashMap<String, Boolean> arguments = new HashMap<String, Boolean>();
                        arguments.put("dummy", true);
                        RemoteDevicePlugin.getDisconnectServiceHandler().run((IInstance)instance, arguments);
                    }
                    catch (Exception e) {
                        AndmoreLogger.error((String)("Error when running TmL disconnect service: " + e.getMessage()));
                    }
                } else {
                    AndmoreLogger.debug((String)"Disconnecting Remote Device: the device is volatile, it will be deleted");
                    DevicesManager.getInstance().deleteInstanceOfDevice(serialNumber);
                }
            }
        }
    }

    private static boolean waitForDeviceToBeOnline(String serialNumber, ISerialNumbered instance) {
        AndmoreLogger.debug((String)("Wait device to be online: " + serialNumber));
        boolean instanceOnline = false;
        long timeoutLimit = 0L;
        if (instance != null) {
            Properties prop = ((IInstance)instance).getProperties();
            String timeout = prop.getProperty("org.eclipse.andmore.android.remote.timeoutProperty");
            timeoutLimit = System.currentTimeMillis() + (long)(Integer.parseInt(timeout) * 1000);
        } else {
            timeoutLimit = System.currentTimeMillis() + 30000L;
        }
        while (!(instanceOnline = DDMSFacade.isDeviceOnline((String)serialNumber))) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                AndmoreLogger.error((String)"Wait for device to be online: thread has been interrupted");
            }
            try {
                RemoteDeviceUtils.testTimeout(timeoutLimit);
            }
            catch (TimeoutException timeoutException) {
                AndmoreLogger.warn((String)("Timeout reached wile wating device to be online: " + serialNumber));
                break;
            }
        }
        return instanceOnline;
    }

    private static RemoteDeviceInstanceBuilder getInstanceBuilder(String serialNumber) {
        RemoteDeviceInstanceBuilder instanceBuilder = null;
        String[] serialNumberParts = serialNumber.split(":");
        String host = serialNumberParts[0];
        String port = serialNumberParts[1];
        Properties props = new Properties();
        props.put("org.eclipse.andmore.android.remote.hostProperty", host);
        props.put("org.eclipse.andmore.android.remote.portProperty", port);
        props.put("org.eclipse.andmore.android.remote.timeoutProperty", String.valueOf(30));
        props.put("org.eclipse.andmore.android.remote.volatileProperty", (Object)true);
        instanceBuilder = new RemoteDeviceInstanceBuilder(serialNumber, props);
        return instanceBuilder;
    }

    public static boolean hasSameHostAndPort(ISerialNumbered device, String host, int port) {
        boolean returnValue = false;
        String deviceHost = ((RemoteDeviceInstance)device).getProperties().getProperty("org.eclipse.andmore.android.remote.hostProperty");
        String devicePort = ((RemoteDeviceInstance)device).getProperties().getProperty("org.eclipse.andmore.android.remote.portProperty");
        if (host.equals(deviceHost) && String.valueOf(port).equals(devicePort)) {
            returnValue = true;
        }
        return returnValue;
    }

    public static IStatus executeCommand(String[] cmd) throws IOException {
        IStatus status = Status.OK_STATUS;
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(cmd);
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            AndmoreLogger.error(RemoteDeviceUtils.class, (String)"Problems executing the command");
            status = new Status(4, "org.eclipse.andmore.android.remote", "Problems executing the command", (Throwable)e);
        }
        if (process.exitValue() != 0) {
            AndmoreLogger.error(RemoteDeviceUtils.class, (String)"The IP was not found");
            status = new Status(4, "org.eclipse.andmore.android.remote", "The IP was not found");
        }
        return status;
    }

    private static void testTimeout(long timeoutLimit) throws TimeoutException {
        if (System.currentTimeMillis() > timeoutLimit) {
            throw new TimeoutException();
        }
    }
}

