/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.remote;

import java.util.Collection;
import org.eclipse.andmore.android.ISerialNumbered;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.preferences.DialogWithToggleUtils;
import org.eclipse.andmore.android.devices.DevicesManager;
import org.eclipse.andmore.android.remote.RemoteDevicePlugin;
import org.eclipse.andmore.android.remote.i18n.RemoteDeviceNLS;
import org.eclipse.andmore.android.remote.instance.RemoteDeviceInstance;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;

public class RemoteDeviceWorkbenchListener
implements IWorkbenchListener {
    public void postShutdown(IWorkbench workbench) {
    }

    public boolean preShutdown(IWorkbench workbench, boolean forced) {
        boolean disconnectRemoteInstances;
        Collection connectedDevices = DevicesManager.getInstance().getOnlineDevicesByType(RemoteDeviceInstance.class);
        if (connectedDevices.size() > 0 && (disconnectRemoteInstances = DialogWithToggleUtils.showQuestion((String)"disconnect.all.remote.devices.in.shutdown", (String)RemoteDeviceNLS.QUESTION_ConnectedRemoteDevicesOnClose_Title, (String)RemoteDeviceNLS.QUESTION_ConnectedRemoteDevicesOnClose_Text))) {
            for (ISerialNumbered device : connectedDevices) {
                try {
                    RemoteDevicePlugin.getDisconnectServiceHandler().run((IInstance)((RemoteDeviceInstance)device));
                }
                catch (SequoyahException e) {
                    AndmoreLogger.error((String)("Error when trying to disconnect Remote Devices on Studio shutdown: " + e.getMessage()));
                }
            }
        }
        return true;
    }
}

