/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.remote.handlers;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.ISerialNumbered;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.remote.i18n.RemoteDeviceNLS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sequoyah.device.framework.events.InstanceEvent;
import org.eclipse.sequoyah.device.framework.events.InstanceEventManager;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.handler.IServiceHandler;
import org.eclipse.sequoyah.device.framework.model.handler.ServiceHandler;

public class DisconnectFromRemoteHandler
extends ServiceHandler {
    public IServiceHandler newInstance() {
        return new DisconnectFromRemoteHandler();
    }

    public IStatus runService(IInstance instance, Map<Object, Object> arguments, IProgressMonitor monitor) {
        AndmoreLogger.debug((String)("TmL Disconnect from Remote Device Service: start disconnecting from remote device: " + instance));
        if (arguments != null && ((Boolean)arguments.get("dummy")).booleanValue()) {
            AndmoreLogger.debug((String)"TmL Disconnect from Remote Device Service: dummy transition");
            this.setSuffix(instance);
            return Status.OK_STATUS;
        }
        IStatus status = Status.OK_STATUS;
        Properties prop = instance.getProperties();
        String host = prop.getProperty("org.eclipse.andmore.android.remote.hostProperty");
        String port = prop.getProperty("org.eclipse.andmore.android.remote.portProperty");
        String timeout = prop.getProperty("org.eclipse.andmore.android.remote.timeoutProperty");
        try {
            status = DDMSFacade.disconnectTcpIp((ISerialNumbered)((ISerialNumbered)instance), (String)host, (String)port, (int)Integer.parseInt(timeout), (IProgressMonitor)monitor);
        }
        catch (IOException iOException) {
            return new Status(4, "org.eclipse.andmore.android.remote", RemoteDeviceNLS.ERR_DisconnectToRemote_AdbStart);
        }
        if (status.getSeverity() == 0) {
            this.setSuffix(instance);
        }
        AndmoreLogger.debug((String)("TmL Disconnect from Remote Device Service: finish disconnecting from remote device. status: " + status.getSeverity()));
        return status;
    }

    public IStatus updatingService(IInstance instance, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    private void setSuffix(IInstance instance) {
        if (instance != null) {
            AndmoreLogger.debug((String)("TmL Disconnect from Remote Device Service: removing suffix from instance " + instance.getName()));
            instance.setNameSuffix(null);
            InstanceEventManager.getInstance().notifyListeners(new InstanceEvent(InstanceEvent.InstanceEventType.INSTANCE_UPDATED, instance));
        }
    }
}

