/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.remote.ui;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.andmore.android.ISerialNumbered;
import org.eclipse.andmore.android.devices.DevicesManager;
import org.eclipse.andmore.android.remote.RemoteDeviceUtils;
import org.eclipse.andmore.android.remote.i18n.RemoteDeviceNLS;
import org.eclipse.andmore.android.remote.instance.RemoteDeviceInstance;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class RemotePropertiesComposite
extends Composite {
    private String host;
    private int port;
    private int timeout;
    ISerialNumbered device;
    private final Collection<RemotePropertiesChangedListener> listeners = new LinkedHashSet<RemotePropertiesChangedListener>();
    private static final String ZERO_TO_255_PATTERN = "((\\d)|(\\d\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))";
    private static final String IP_PATTERN = "((\\d)|(\\d\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d)|(\\d\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d)|(\\d\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d)|(\\d\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))";
    private static final String HOST_ERR_MESSAGE = RemoteDeviceNLS.ERR_RemoteDeviceWizardPage_IP;
    private static final String PORT_ERR_MESSAGE = RemoteDeviceNLS.ERR_RemoteDeviceWizardPage_Port;
    private static final String TIMEOUT_ERR_MESSAGE = RemoteDeviceNLS.ERR_RemoteDeviceWizardPage_Timeout;

    public RemotePropertiesComposite(Composite parent) {
        this(parent, "", "", "", null);
    }

    public RemotePropertiesComposite(Composite parent, String initialHost, String initialPort, String initialTimeout, ISerialNumbered device) {
        super(parent, 0);
        this.device = device;
        this.host = initialHost != null && !initialHost.equals("") ? initialHost : null;
        this.port = initialPort != null && !initialPort.equals("") ? Integer.parseInt(initialPort) : -1;
        this.timeout = initialTimeout != null && !initialTimeout.equals("") ? Integer.parseInt(initialTimeout) : -1;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.andmore.android.remote.remoteDeviceProperties");
        this.setLayout((Layout)new GridLayout(2, false));
        Label hostLabel = new Label((Composite)this, 0);
        hostLabel.setText(RemoteDeviceNLS.UI_Host);
        GridData data = new GridData(4, 4, false, false);
        hostLabel.setLayoutData((Object)data);
        final Text hostText = new Text((Composite)this, 2048);
        data = new GridData(4, 4, true, false);
        hostText.setLayoutData((Object)data);
        hostText.addModifyListener(new ModifyListener(){
            private final Pattern p = Pattern.compile("((\\d)|(\\d\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d)|(\\d\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d)|(\\d\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d)|(\\d\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))");

            public void modifyText(ModifyEvent e) {
                String candidateHost = hostText.getText();
                if (candidateHost != null) {
                    Matcher m = this.p.matcher(candidateHost);
                    if (m.matches()) {
                        RemotePropertiesComposite.this.host = candidateHost;
                    } else {
                        RemotePropertiesComposite.this.host = "";
                    }
                    RemotePropertiesComposite.this.notifyListeners();
                }
            }
        });
        hostText.setText(initialHost);
        hostText.setFocus();
        Label portLabel = new Label((Composite)this, 0);
        portLabel.setText(RemoteDeviceNLS.UI_Port);
        data = new GridData(4, 4, false, false);
        portLabel.setLayoutData((Object)data);
        final Text portText = new Text((Composite)this, 2048);
        data = new GridData(4, 4, true, false);
        portText.setLayoutData((Object)data);
        portText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String portStr = portText.getText();
                try {
                    try {
                        RemotePropertiesComposite.this.port = Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        RemotePropertiesComposite.this.port = -1;
                        RemotePropertiesComposite.this.notifyListeners();
                    }
                }
                finally {
                    RemotePropertiesComposite.this.notifyListeners();
                }
            }
        });
        portText.setText(initialPort);
        Label timeoutLabel = new Label((Composite)this, 0);
        timeoutLabel.setText(RemoteDeviceNLS.UI_Timeout);
        data = new GridData(4, 4, false, false);
        timeoutLabel.setLayoutData((Object)data);
        final Text timeoutText = new Text((Composite)this, 2048);
        data = new GridData(4, 4, true, false);
        timeoutText.setLayoutData((Object)data);
        timeoutText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String timeoutStr = timeoutText.getText();
                try {
                    try {
                        RemotePropertiesComposite.this.timeout = Integer.parseInt(timeoutStr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        RemotePropertiesComposite.this.timeout = -1;
                        RemotePropertiesComposite.this.notifyListeners();
                    }
                }
                finally {
                    RemotePropertiesComposite.this.notifyListeners();
                }
            }
        });
        timeoutText.setText(!initialTimeout.equals("") ? initialTimeout : String.valueOf(30));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(RemotePropertiesChangedListener listener) {
        Collection<RemotePropertiesChangedListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(RemotePropertiesChangedListener listener) {
        Collection<RemotePropertiesChangedListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(listener);
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getPort() {
        return this.port;
    }

    public String getErrorMessage() {
        String errorMsg = null;
        if (this.timeout < 0) {
            errorMsg = TIMEOUT_ERR_MESSAGE;
        }
        if (this.port < 0) {
            errorMsg = PORT_ERR_MESSAGE;
        } else if (this.port < 1024 || this.port > 65535) {
            errorMsg = NLS.bind((String)RemoteDeviceNLS.WirelessPropertiesComposite_MsgPortNumberEqualOrHigherThan, (Object)1024, (Object)65535);
        }
        if (this.host != null && this.host.equals("")) {
            errorMsg = HOST_ERR_MESSAGE;
        }
        Collection existentRemoteDeviceInstances = DevicesManager.getInstance().getInstancesByType(RemoteDeviceInstance.class);
        for (ISerialNumbered device : existentRemoteDeviceInstances) {
            if (!RemoteDeviceUtils.hasSameHostAndPort(device, this.host, this.port) || this.device != null && (this.device == null || this.device.getDeviceName().equals(device.getDeviceName()))) continue;
            errorMsg = NLS.bind((String)RemoteDeviceNLS.ERR_RemoteDeviceWizardPage_Duplicated, (Object)device.getDeviceName());
            break;
        }
        return errorMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        Collection<RemotePropertiesChangedListener> collection = this.listeners;
        synchronized (collection) {
            for (RemotePropertiesChangedListener listener : this.listeners) {
                listener.propertiesChanged();
            }
        }
    }

    public static interface RemotePropertiesChangedListener {
        public void propertiesChanged();
    }
}

