/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.remote.ui.wireless;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.andmore.android.ISerialNumbered;
import org.eclipse.andmore.android.devices.DevicesManager;
import org.eclipse.andmore.android.remote.RemoteDeviceUtils;
import org.eclipse.andmore.android.remote.i18n.RemoteDeviceNLS;
import org.eclipse.andmore.android.remote.instance.RemoteDeviceInstance;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sequoyah.device.framework.factory.InstanceRegistry;
import org.eclipse.sequoyah.device.framework.model.AbstractMobileInstance;
import org.eclipse.sequoyah.device.framework.ui.DeviceUIResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class WirelessPropertiesComposite
extends Composite {
    private static final String EMPTY_STRING = "";
    private static final int DEFAULT_INVALID_INTEGER = -1;
    private String name;
    private final String host;
    private int port;
    private int timeout;
    ISerialNumbered device;
    private IProgressMonitor monitor;
    private final Collection<WirelessPropertiesChangedListener> listeners = new LinkedHashSet<WirelessPropertiesChangedListener>();
    private static final String NAME_ERR_MESSAGE = RemoteDeviceNLS.ERR_WirelessDeviceWizardPage_Name;
    private static final String HOST_ERR_MESSAGE = RemoteDeviceNLS.ERR_RemoteDeviceWizardPage_IP;
    private static final String PORT_ERR_MESSAGE = RemoteDeviceNLS.ERR_RemoteDeviceWizardPage_Port;
    private static final String TIMEOUT_ERR_MESSAGE = RemoteDeviceNLS.ERR_RemoteDeviceWizardPage_Timeout;
    private final Text nameText;
    private final Text portText;
    private final Text timeoutText;

    public WirelessPropertiesComposite(Composite parent, String host, ISerialNumbered device) {
        this(parent, host, EMPTY_STRING, EMPTY_STRING, device);
    }

    public WirelessPropertiesComposite(Composite parent, String initialHost, String initialPort, String initialTimeout, ISerialNumbered device) {
        super(parent, 0);
        this.name = String.valueOf(device.getDeviceName()) + "_wireless";
        this.host = initialHost;
        this.port = 10000;
        this.timeout = 30;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.andmore.android.remote.wirelessRemoteDeviceProperties");
        this.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label((Composite)this, 0);
        nameLabel.setText(RemoteDeviceNLS.UI_Name);
        nameLabel.setLayoutData((Object)new GridData(131072, 4, false, false));
        this.nameText = new Text((Composite)this, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.nameText.addModifyListener((ModifyListener)new NameModifyListener());
        this.nameText.setText(this.name);
        Label hostLabel = new Label((Composite)this, 0);
        hostLabel.setText(RemoteDeviceNLS.UI_Host);
        hostLabel.setLayoutData((Object)new GridData(131072, 4, false, false));
        Text hostText = new Text((Composite)this, 2048);
        hostText.setLayoutData((Object)new GridData(4, 4, true, false));
        hostText.setEnabled(false);
        hostText.setText(this.host);
        Label portLabel = new Label((Composite)this, 0);
        portLabel.setText(RemoteDeviceNLS.UI_Port);
        portLabel.setLayoutData((Object)new GridData(131072, 4, false, false));
        this.portText = new Text((Composite)this, 2048);
        this.portText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.portText.setText(String.valueOf(this.port));
        this.portText.addModifyListener((ModifyListener)new PortModifyListener());
        this.portText.setText(String.valueOf(this.port));
        Label timeoutLabel = new Label((Composite)this, 0);
        timeoutLabel.setText(RemoteDeviceNLS.UI_Timeout);
        timeoutLabel.setLayoutData((Object)new GridData(131072, 4, false, false));
        this.timeoutText = new Text((Composite)this, 2048);
        this.timeoutText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.timeoutText.addModifyListener((ModifyListener)new TimeoutModifyListener());
        this.timeoutText.setText(!initialTimeout.equals(EMPTY_STRING) ? initialTimeout : String.valueOf(30));
        this.manageSameIPAndPortOfRemoteDevice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(WirelessPropertiesChangedListener listener) {
        Collection<WirelessPropertiesChangedListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(WirelessPropertiesChangedListener listener) {
        Collection<WirelessPropertiesChangedListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(listener);
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getPort() {
        return this.port;
    }

    public IStatus getStatus() {
        Status status = new Status(0, "org.eclipse.andmore.android.remote", RemoteDeviceNLS.UI_WirelessInformationPage_Description);
        String errorMessage = null;
        boolean isValidationOK = true;
        if (this.name == null || this.name.equals(EMPTY_STRING)) {
            errorMessage = NAME_ERR_MESSAGE;
            status = new Status(4, "org.eclipse.andmore.android.remote", errorMessage);
            isValidationOK = false;
        }
        if (isValidationOK && this.port < 0) {
            errorMessage = PORT_ERR_MESSAGE;
            status = new Status(4, "org.eclipse.andmore.android.remote", errorMessage);
            isValidationOK = false;
        }
        if (isValidationOK && this.port < 1024 || this.port > 65535) {
            errorMessage = NLS.bind((String)RemoteDeviceNLS.WirelessPropertiesComposite_MsgPortNumberEqualOrHigherThan, (Object)1024, (Object)65535);
            status = new Status(4, "org.eclipse.andmore.android.remote", errorMessage);
            isValidationOK = false;
        }
        if (isValidationOK && this.timeout < 0) {
            errorMessage = TIMEOUT_ERR_MESSAGE;
            status = new Status(4, "org.eclipse.andmore.android.remote", errorMessage);
            isValidationOK = false;
        }
        if (isValidationOK && this.host != null && this.host.equals(EMPTY_STRING)) {
            errorMessage = HOST_ERR_MESSAGE;
            status = new Status(4, "org.eclipse.andmore.android.remote", errorMessage);
            isValidationOK = false;
        }
        if (isValidationOK) {
            Collection existentRemoteDeviceInstances = DevicesManager.getInstance().getInstancesByType(RemoteDeviceInstance.class);
            for (ISerialNumbered device : existentRemoteDeviceInstances) {
                if (!RemoteDeviceUtils.hasSameHostAndPort(device, this.host, this.port) || this.device != null && (this.device == null || this.device.getDeviceName().equals(device.getDeviceName()))) continue;
                errorMessage = NLS.bind((String)RemoteDeviceNLS.ERR_RemoteDeviceWizardPage_WirelessDuplicated, (Object)device.getDeviceName());
                status = new Status(2, "org.eclipse.andmore.android.remote", errorMessage);
                isValidationOK = false;
                break;
            }
        }
        if (isValidationOK && this.name != null && this.getRemoteDeviceWithSameIPAndPort() == null) {
            InstanceRegistry registry = InstanceRegistry.getInstance();
            if (!this.name.equals(EMPTY_STRING)) {
                if (registry.getInstancesByName(this.name).size() != 0) {
                    errorMessage = DeviceUIResources.SEQUOYAH_Emulator_Wizard_Project_Description_Duplicated_Error;
                    status = new Status(4, "org.eclipse.andmore.android.remote", errorMessage);
                    isValidationOK = false;
                } else if (!AbstractMobileInstance.validName((String)this.name)) {
                    errorMessage = DeviceUIResources.SEQUOYAH_Instance_Name_Invalid_Error;
                    status = new Status(4, "org.eclipse.andmore.android.remote", errorMessage);
                    isValidationOK = false;
                }
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        Collection<WirelessPropertiesChangedListener> collection = this.listeners;
        synchronized (collection) {
            for (WirelessPropertiesChangedListener listener : this.listeners) {
                listener.propertiesChanged();
            }
        }
    }

    private void manageSameIPAndPortOfRemoteDevice() {
        ISerialNumbered matchedDevice = this.getRemoteDeviceWithSameIPAndPort();
        if (matchedDevice != null) {
            this.nameText.setText(matchedDevice.getDeviceName());
            this.nameText.setEnabled(false);
        } else {
            this.nameText.setEnabled(true);
        }
    }

    private ISerialNumbered getRemoteDeviceWithSameIPAndPort() {
        ISerialNumbered matchedDevice = null;
        Collection existentRemoteDeviceInstances = DevicesManager.getInstance().getInstancesByType(RemoteDeviceInstance.class);
        for (ISerialNumbered device : existentRemoteDeviceInstances) {
            if (!RemoteDeviceUtils.hasSameHostAndPort(device, this.host, this.port) || this.device != null && (this.device == null || this.device.getDeviceName().equals(device.getDeviceName()))) continue;
            matchedDevice = device;
            break;
        }
        return matchedDevice;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public String getDeviceName() {
        return this.name;
    }

    private final class NameModifyListener
    implements ModifyListener {
        private NameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            WirelessPropertiesComposite.this.name = WirelessPropertiesComposite.this.nameText.getText();
            WirelessPropertiesComposite.this.notifyListeners();
        }
    }

    private final class PortModifyListener
    implements ModifyListener {
        private PortModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String portStr = WirelessPropertiesComposite.this.portText.getText();
            try {
                try {
                    WirelessPropertiesComposite.this.port = Integer.parseInt(portStr);
                    WirelessPropertiesComposite.this.manageSameIPAndPortOfRemoteDevice();
                }
                catch (NumberFormatException numberFormatException) {
                    WirelessPropertiesComposite.this.port = -1;
                    WirelessPropertiesComposite.this.notifyListeners();
                }
            }
            finally {
                WirelessPropertiesComposite.this.notifyListeners();
            }
        }
    }

    private final class TimeoutModifyListener
    implements ModifyListener {
        private TimeoutModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String timeoutStr = WirelessPropertiesComposite.this.timeoutText.getText();
            try {
                try {
                    WirelessPropertiesComposite.this.timeout = Integer.parseInt(timeoutStr);
                }
                catch (NumberFormatException numberFormatException) {
                    WirelessPropertiesComposite.this.timeout = -1;
                    WirelessPropertiesComposite.this.notifyListeners();
                }
            }
            finally {
                WirelessPropertiesComposite.this.notifyListeners();
            }
        }
    }

    public static interface WirelessPropertiesChangedListener {
        public void propertiesChanged();
    }
}

