/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.tools.datamodel.node;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.sequoyah.localization.tools.datamodel.node.StringArrayItemNode;
import org.eclipse.sequoyah.localization.tools.datamodel.node.StringNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringArrayNode
extends StringNode {
    private ArrayList<StringArrayItemNode> values = new ArrayList();

    public StringArrayNode(String string) {
        super(string, null);
    }

    public List<StringArrayItemNode> getValues() {
        return this.values;
    }

    public StringArrayItemNode getArrayItemByIndex(int n) {
        StringArrayItemNode stringArrayItemNode = null;
        Iterator<StringArrayItemNode> iterator = this.values.iterator();
        while (iterator.hasNext() && stringArrayItemNode == null) {
            StringArrayItemNode stringArrayItemNode2 = iterator.next();
            if (stringArrayItemNode2.getPosition() != n) continue;
            stringArrayItemNode = stringArrayItemNode2;
        }
        return stringArrayItemNode;
    }

    public List<String> getStringValues() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (StringNode stringNode : this.values) {
            linkedList.add(stringNode.getValue());
        }
        return linkedList;
    }

    public StringArrayItemNode addValue(String string) {
        return this.addValue(string, -1);
    }

    public StringArrayItemNode addValue(String string, int n) {
        return this.addValue(string, n, false);
    }

    public StringArrayItemNode addValue(String string, int n, boolean bl) {
        StringArrayItemNode stringArrayItemNode = null;
        int n2 = n;
        if (n == -1) {
            n2 = this.getLastIndex() + 1;
        }
        stringArrayItemNode = new StringArrayItemNode(string, this, n2);
        this.ensurePosition(bl ? n + 1 : n);
        if (bl) {
            this.values.set(n2, stringArrayItemNode);
        } else {
            this.values.add(n2, stringArrayItemNode);
        }
        int n3 = n2 + 1;
        while (n3 < this.values.size()) {
            this.values.get(n3).setPosition(this.values.get(n3).getPosition() + 1);
            ++n3;
        }
        return stringArrayItemNode;
    }

    private void ensurePosition(int n) {
        int n2 = this.values.size();
        while (n2 < n) {
            this.addValue(null, n2);
            ++n2;
        }
    }

    private int getLastIndex() {
        int n = -1;
        if (this.values.size() > 0) {
            StringArrayItemNode stringArrayItemNode = this.values.get(this.values.size() - 1);
            n = stringArrayItemNode.getPosition();
        }
        return n;
    }

    public void removeValue(StringArrayItemNode stringArrayItemNode) {
        int n = stringArrayItemNode.getPosition();
        this.values.remove(n);
        int n2 = n;
        while (n2 < this.values.size()) {
            this.values.get(n2).setPosition(this.values.get(n2).getPosition() - 1);
            ++n2;
        }
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.key == null ? 0 : this.key.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        return this.getKey().equals(((StringArrayNode)object).getKey());
    }

    @Override
    public void setKey(String string) {
        super.setKey(string);
        for (StringArrayItemNode stringArrayItemNode : this.values) {
            stringArrayItemNode.setKey(string);
        }
    }

    @Override
    public String toString() {
        return "StringArrayNode [values=" + this.values + "]";
    }
}

