/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinatesProvider;

public class AttitudesSequence
implements AttitudeProvider {
    private static final long serialVersionUID = 5140034224175180354L;
    private AttitudeProvider active = null;
    private final Map<AttitudeProvider, Collection<Switch<?>>> switchingMap = new HashMap();

    public void resetActiveProvider(AttitudeProvider provider) {
        if (!this.switchingMap.containsKey(provider)) {
            this.switchingMap.put(provider, new ArrayList());
        }
        this.active = provider;
    }

    public void registerSwitchEvents(Propagator propagator) {
        for (Collection<Switch<?>> collection : this.switchingMap.values()) {
            for (Switch<?> s : collection) {
                propagator.addEventDetector(s);
            }
        }
    }

    public <T extends EventDetector> void addSwitchingCondition(AttitudeProvider before, T switchEvent, boolean switchOnIncrease, boolean switchOnDecrease, AttitudeProvider after) {
        if (!this.switchingMap.containsKey(before)) {
            this.switchingMap.put(before, new ArrayList());
            if (this.active == null) {
                this.active = before;
            }
        }
        if (switchEvent != null) {
            if (!this.switchingMap.containsKey(after)) {
                this.switchingMap.put(after, new ArrayList());
            }
            this.switchingMap.get(before).add(new Switch(this, switchEvent, switchOnIncrease, switchOnDecrease, after));
        }
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) throws OrekitException {
        return this.active.getAttitude(pvProv, date, frame);
    }

    private static class LocalHandler<T extends EventDetector>
    implements EventHandler<Switch<T>> {
        private LocalHandler() {
        }

        @Override
        public EventHandler.Action eventOccurred(SpacecraftState s, Switch<T> sw, boolean increasing) throws OrekitException {
            if (increasing && ((Switch)sw).switchOnIncrease || !increasing && ((Switch)sw).switchOnDecrease) {
                sw.performSwitch();
            }
            return ((Switch)sw).event.eventOccurred(s, increasing);
        }

        @Override
        public SpacecraftState resetState(Switch<T> sw, SpacecraftState oldState) throws OrekitException {
            return ((Switch)sw).event.resetState(oldState);
        }
    }

    private class Switch<T extends EventDetector>
    extends AbstractDetector<Switch<T>> {
        private static final long serialVersionUID = 20141228L;
        private final T event;
        private final boolean switchOnIncrease;
        private final boolean switchOnDecrease;
        private final AttitudeProvider next;
        final /* synthetic */ AttitudesSequence this$0;

        public Switch(T event, boolean switchOnIncrease, boolean switchOnDecrease, AttitudeProvider next) {
            this(var1_1, event.getMaxCheckInterval(), event.getThreshold(), event.getMaxIterationCount(), new LocalHandler(), (EventDetector)event, switchOnIncrease, switchOnDecrease, next);
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private Switch(double maxIter, double event, int switchOnDecrease, EventHandler<Switch<T>> next, T t, boolean bl, boolean bl2, AttitudeProvider attitudeProvider) {
            void switchOnIncrease;
            void handler;
            void threshold;
            void maxCheck;
            this.this$0 = (AttitudesSequence)d;
            super((double)maxCheck, (double)threshold, (int)maxIter, handler);
            this.event = event;
            this.switchOnIncrease = switchOnIncrease;
            this.switchOnDecrease = switchOnDecrease;
            this.next = next;
        }

        @Override
        protected Switch<T> create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<Switch<T>> newHandler) {
            return new Switch(this.this$0, newMaxCheck, newThreshold, newMaxIter, newHandler, this.event, this.switchOnIncrease, this.switchOnDecrease, this.next);
        }

        public void performSwitch() {
            this.this$0.active = this.next;
        }

        @Override
        public void init(SpacecraftState s0, AbsoluteDate t) {
            this.event.init(s0, t);
        }

        @Override
        public double g(SpacecraftState s) throws OrekitException {
            return this.event.g(s);
        }
    }
}

