/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.RotationOrder;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.frames.LOFType;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedPVCoordinates;

public class LofOffset
implements AttitudeProvider {
    private static final long serialVersionUID = -713570668596014285L;
    private LOFType type;
    private final Rotation offset;
    private final Frame inertialFrame;

    public LofOffset(Frame inertialFrame, LOFType type) throws OrekitException {
        this(inertialFrame, type, RotationOrder.XYZ, 0.0, 0.0, 0.0);
    }

    public LofOffset(Frame inertialFrame, LOFType type, RotationOrder order, double alpha1, double alpha2, double alpha3) throws OrekitException {
        this.type = type;
        this.offset = new Rotation(order, alpha1, alpha2, alpha3).revert();
        if (!inertialFrame.isPseudoInertial()) {
            throw new OrekitException((Localizable)OrekitMessages.NON_PSEUDO_INERTIAL_FRAME_NOT_SUITABLE_FOR_DEFINING_ORBITS, inertialFrame.getName());
        }
        this.inertialFrame = inertialFrame;
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) throws OrekitException {
        TimeStampedPVCoordinates pv = pvProv.getPVCoordinates(date, this.inertialFrame);
        Transform inertialToLof = this.type.transformFromInertial(date, pv);
        Transform frameToInertial = frame.getTransformTo(this.inertialFrame, date);
        Transform frameToLof = new Transform(date, frameToInertial, inertialToLof);
        return new Attitude(date, frame, this.offset.applyTo(frameToLof.getRotation()), this.offset.applyTo(frameToLof.getRotationRate()), this.offset.applyTo(frameToLof.getRotationAcceleration()));
    }
}

