/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.GroundPointing;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedPVCoordinates;

public class TargetPointing
extends GroundPointing {
    private static final long serialVersionUID = 20140811L;
    private final Vector3D target;

    public TargetPointing(Frame bodyFrame, Vector3D target) {
        super(bodyFrame);
        this.target = target;
    }

    public TargetPointing(GeodeticPoint targetGeo, BodyShape shape) {
        super(shape.getBodyFrame());
        this.target = shape.transform(targetGeo);
    }

    @Override
    protected TimeStampedPVCoordinates getTargetPV(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) throws OrekitException {
        Transform t = this.getBodyFrame().getTransformTo(frame, date);
        TimeStampedPVCoordinates pv = new TimeStampedPVCoordinates(date, this.target, Vector3D.ZERO, Vector3D.ZERO);
        return t.transformPVCoordinates(pv);
    }
}

