/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.AttitudeProviderModifier;
import org.orekit.attitudes.GroundPointing;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class YawSteering
extends GroundPointing
implements AttitudeProviderModifier {
    private static final long serialVersionUID = 20140808L;
    private static final PVCoordinates PLUS_Z = new PVCoordinates(Vector3D.PLUS_K, Vector3D.ZERO, Vector3D.ZERO);
    private final GroundPointing groundPointingLaw;
    private final PVCoordinatesProvider sun;
    private final PVCoordinates phasingNormal;

    public YawSteering(GroundPointing groundPointingLaw, PVCoordinatesProvider sun, Vector3D phasingAxis) {
        super(groundPointingLaw.getBodyFrame());
        this.groundPointingLaw = groundPointingLaw;
        this.sun = sun;
        this.phasingNormal = new PVCoordinates(Vector3D.crossProduct((Vector3D)Vector3D.PLUS_K, (Vector3D)phasingAxis).normalize(), Vector3D.ZERO, Vector3D.ZERO);
    }

    @Override
    public AttitudeProvider getUnderlyingAttitudeProvider() {
        return this.groundPointingLaw;
    }

    @Override
    protected TimeStampedPVCoordinates getTargetPV(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) throws OrekitException {
        return this.groundPointingLaw.getTargetPV(pvProv, date, frame);
    }

    public Attitude getBaseState(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) throws OrekitException {
        return this.groundPointingLaw.getAttitude(pvProv, date, frame);
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) throws OrekitException {
        Attitude base = this.getBaseState(pvProv, date, frame);
        PVCoordinates sunDirection = new PVCoordinates(pvProv.getPVCoordinates(date, frame), (PVCoordinates)this.sun.getPVCoordinates(date, frame));
        PVCoordinates sunNormal = PVCoordinates.crossProduct(PLUS_Z, base.getOrientation().applyTo(sunDirection));
        TimeStampedAngularCoordinates compensation = new TimeStampedAngularCoordinates(date, PLUS_Z, sunNormal.normalize(), PLUS_Z, this.phasingNormal, 1.0E-9);
        return new Attitude(frame, compensation.addOffset(base.getOrientation()));
    }
}

