/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import java.io.Serializable;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.solvers.BracketingNthOrderBrentSolver;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.util.FastMath;
import org.orekit.frames.Frame;
import org.orekit.utils.TimeStampedPVCoordinates;

public class Ellipse
implements Serializable {
    private static final long serialVersionUID = 20140925L;
    private static final double ANGULAR_THRESHOLD = 1.0E-12;
    private final Vector3D center;
    private final Vector3D u;
    private final Vector3D v;
    private final double a;
    private final double b;
    private final Frame frame;
    private final double a2;
    private final double b2;
    private final double e2;
    private final double g;
    private final double g2;
    private final double evoluteFactorX;
    private final double evoluteFactorY;

    public Ellipse(Vector3D center, Vector3D u, Vector3D v, double a, double b, Frame frame) {
        this.center = center;
        this.u = u;
        this.v = v;
        this.a = a;
        this.b = b;
        this.frame = frame;
        this.a2 = a * a;
        this.g = b / a;
        this.g2 = this.g * this.g;
        this.e2 = 1.0 - this.g2;
        this.b2 = b * b;
        this.evoluteFactorX = (this.a2 - this.b2) / (this.a2 * this.a2);
        this.evoluteFactorY = (this.b2 - this.a2) / (this.b2 * this.b2);
    }

    public Vector3D getCenter() {
        return this.center;
    }

    public Vector3D getU() {
        return this.u;
    }

    public Vector3D getV() {
        return this.v;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public Vector3D pointAt(double theta) {
        return this.toSpace(new Vector2D(this.a * FastMath.cos((double)theta), this.b * FastMath.sin((double)theta)));
    }

    public Vector3D toSpace(Vector2D p) {
        return new Vector3D(1.0, this.center, p.getX(), this.u, p.getY(), this.v);
    }

    public Vector2D toPlane(Vector3D p) {
        Vector3D delta = p.subtract((Vector)this.center);
        return new Vector2D(Vector3D.dotProduct((Vector3D)delta, (Vector3D)this.u), Vector3D.dotProduct((Vector3D)delta, (Vector3D)this.v));
    }

    public Vector2D projectToEllipse(Vector2D p) {
        double rho;
        if (p.getX() <= 1.0E-12 * FastMath.abs((double)p.getY())) {
            double osculatingRadius = this.a2 / this.b;
            double evoluteCuspZ = FastMath.copySign((double)(this.a * this.e2 / this.g), (double)(-p.getY()));
            double deltaZ = p.getY() - evoluteCuspZ;
            double ratio = osculatingRadius / FastMath.hypot((double)deltaZ, (double)p.getX());
            return new Vector2D(ratio * p.getX(), evoluteCuspZ + ratio * deltaZ);
        }
        if (FastMath.abs((double)p.getY()) <= 1.0E-12 * p.getX()) {
            double osculatingRadius = this.b2 / this.a;
            double evoluteCuspR = this.a * this.e2;
            double deltaR = p.getX() - evoluteCuspR;
            if (deltaR >= 0.0) {
                double ratio = osculatingRadius / FastMath.hypot((double)p.getY(), (double)deltaR);
                return new Vector2D(evoluteCuspR + ratio * deltaR, ratio * p.getY());
            }
            double rEllipse = p.getX() / this.e2;
            return new Vector2D(rEllipse, FastMath.copySign((double)(this.g * FastMath.sqrt((double)(this.a2 - rEllipse * rEllipse))), (double)p.getY()));
        }
        ClosestPointFinder finder = new ClosestPointFinder(p);
        if (this.e2 >= 1.0E-12) {
            BracketingNthOrderBrentSolver solver = new BracketingNthOrderBrentSolver(1.0E-12 * this.b, 5);
            rho = solver.solve(100, (UnivariateFunction)finder, 0.0, 1.1 * this.a * this.e2);
        } else {
            rho = 0.0;
        }
        return finder.intersectionPoint(rho);
    }

    public TimeStampedPVCoordinates projectToEllipse(TimeStampedPVCoordinates pv) {
        Vector2D p2D = this.toPlane(pv.getPosition());
        Vector2D e2D = this.projectToEllipse(p2D);
        double fx = -this.a2 * e2D.getY();
        double fy = this.b2 * e2D.getX();
        double f2 = fx * fx + fy * fy;
        double f = FastMath.sqrt((double)f2);
        Vector2D tangent = new Vector2D(fx / f, fy / f);
        Vector2D normal = new Vector2D(-tangent.getY(), tangent.getX());
        double x2 = e2D.getX() * e2D.getX();
        double y2 = e2D.getY() * e2D.getY();
        double eX = this.evoluteFactorX * x2;
        double eY = this.evoluteFactorY * y2;
        double omegaX = eX * e2D.getX();
        double omegaY = eY * e2D.getY();
        double rho = FastMath.hypot((double)(e2D.getX() - omegaX), (double)(e2D.getY() - omegaY));
        double d = FastMath.hypot((double)(p2D.getX() - omegaX), (double)(p2D.getY() - omegaY));
        double projectionRatio = rho / d;
        Vector2D pDot2D = new Vector2D(Vector3D.dotProduct((Vector3D)pv.getVelocity(), (Vector3D)this.u), Vector3D.dotProduct((Vector3D)pv.getVelocity(), (Vector3D)this.v));
        double pDotTangent = pDot2D.dotProduct((Vector)tangent);
        double pDotNormal = pDot2D.dotProduct((Vector)normal);
        double eDotTangent = projectionRatio * pDotTangent;
        Vector2D eDot2D = new Vector2D(eDotTangent, tangent);
        Vector2D tangentDot = new Vector2D(this.a2 * this.b2 * (e2D.getX() * eDot2D.getY() - e2D.getY() * eDot2D.getX()) / f2, normal);
        double omegaXDot = 3.0 * eX * eDotTangent * tangent.getX();
        double omegaYDot = 3.0 * eY * eDotTangent * tangent.getY();
        double voz = omegaXDot * tangent.getY() - omegaYDot * tangent.getX();
        double vsz = -pDotNormal;
        double projectionRatioDot = ((rho - d) * voz - rho * vsz) / (d * d);
        Vector2D pDotDot2D = new Vector2D(Vector3D.dotProduct((Vector3D)pv.getAcceleration(), (Vector3D)this.u), Vector3D.dotProduct((Vector3D)pv.getAcceleration(), (Vector3D)this.v));
        double pDotDotTangent = pDotDot2D.dotProduct((Vector)tangent);
        double pDotTangentDot = pDot2D.dotProduct((Vector)tangentDot);
        double eDotDotTangent = projectionRatio * (pDotDotTangent + pDotTangentDot) + projectionRatioDot * pDotTangent;
        Vector2D eDotDot2D = new Vector2D(eDotDotTangent, tangent, eDotTangent, tangentDot);
        Vector3D e3D = this.toSpace(e2D);
        Vector3D eDot3D = new Vector3D(eDot2D.getX(), this.u, eDot2D.getY(), this.v);
        Vector3D eDotDot3D = new Vector3D(eDotDot2D.getX(), this.u, eDotDot2D.getY(), this.v);
        return new TimeStampedPVCoordinates(pv.getDate(), e3D, eDot3D, eDotDot3D);
    }

    private class ClosestPointFinder
    implements UnivariateFunction {
        private final Vector2D p;

        public ClosestPointFinder(Vector2D p) {
            this.p = p;
        }

        private Vector2D intersectionPoint(double rho) {
            double k = this.kOnEllipse(rho);
            return new Vector2D(rho + k * (this.p.getX() - rho), k * this.p.getY());
        }

        private double kOnEllipse(double rho) {
            double dr = this.p.getX() - rho;
            double alpha = Ellipse.this.b2 * dr * dr + Ellipse.this.a2 * this.p.getY() * this.p.getY();
            double beta = Ellipse.this.b2 * rho * dr;
            double gamma = Ellipse.this.b2 * (rho - Ellipse.this.a) * (rho + Ellipse.this.a);
            double s = FastMath.sqrt((double)(beta * beta - alpha * gamma));
            return beta > 0.0 ? -gamma / (s + beta) : (s - beta) / alpha;
        }

        public double value(double rho) {
            double k = this.kOnEllipse(rho);
            double l = rho + k * (this.p.getX() - rho);
            double rhoPrime = l * Ellipse.this.e2;
            return rhoPrime - rho;
        }
    }
}

