/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import java.io.Serializable;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.Precision;
import org.orekit.bodies.Ellipse;
import org.orekit.frames.Frame;

public class Ellipsoid
implements Serializable {
    private static final long serialVersionUID = 20140924L;
    private final Frame frame;
    private final double a;
    private final double b;
    private final double c;

    public Ellipsoid(Frame frame, double a, double b, double c) {
        this.frame = frame;
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getC() {
        return this.c;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public Ellipse getPlaneSection(Vector3D planePoint, Vector3D planeNormal) {
        double m;
        double bMA;
        Vector3D u = planeNormal.orthogonal();
        Vector3D v = Vector3D.crossProduct((Vector3D)planeNormal, (Vector3D)u).normalize();
        double xUOa = u.getX() / this.a;
        double yUOb = u.getY() / this.b;
        double zUOc = u.getZ() / this.c;
        double xVOa = v.getX() / this.a;
        double yVOb = v.getY() / this.b;
        double zVOc = v.getZ() / this.c;
        double xPOa = planePoint.getX() / this.a;
        double yPOb = planePoint.getY() / this.b;
        double zPOc = planePoint.getZ() / this.c;
        double alpha = xUOa * xUOa + yUOb * yUOb + zUOc * zUOc;
        double beta = xVOa * xVOa + yVOb * yVOb + zVOc * zVOc;
        double gamma = MathArrays.linearCombination((double)xUOa, (double)xVOa, (double)yUOb, (double)yVOb, (double)zUOc, (double)zVOc);
        double delta = MathArrays.linearCombination((double)xPOa, (double)xUOa, (double)yPOb, (double)yUOb, (double)zPOc, (double)zUOc);
        double epsilon = MathArrays.linearCombination((double)xPOa, (double)xVOa, (double)yPOb, (double)yVOb, (double)zPOc, (double)zVOc);
        double zeta = MathArrays.linearCombination((double)xPOa, (double)xPOa, (double)yPOb, (double)yPOb, (double)zPOc, (double)zPOc, (double)1.0, (double)-1.0);
        double tanTheta = FastMath.abs((double)gamma) < Precision.SAFE_MIN ? 0.0 : ((bMA = beta - alpha) >= 0.0 ? -2.0 * gamma / (bMA + FastMath.sqrt((double)(bMA * bMA + 4.0 * gamma * gamma))) : -2.0 * gamma / (bMA - FastMath.sqrt((double)(bMA * bMA + 4.0 * gamma * gamma))));
        double tan2 = tanTheta * tanTheta;
        double cos2 = 1.0 / (1.0 + tan2);
        double sin2 = tan2 * cos2;
        double cosSin = tanTheta * cos2;
        double cos = FastMath.sqrt((double)cos2);
        double sin = tanTheta * cos;
        double denom = gamma * gamma - alpha * beta;
        double tauC = (beta * delta - gamma * epsilon) / denom;
        double nuC = (alpha * epsilon - gamma * delta) / denom;
        double twogcs = 2.0 * gamma * cosSin;
        double bigA = alpha * cos2 + beta * sin2 + twogcs;
        double bigB = alpha * sin2 + beta * cos2 - twogcs;
        double bigF = (alpha * tauC + 2.0 * (gamma * nuC + delta)) * tauC + (beta * nuC + 2.0 * epsilon) * nuC + zeta;
        double l = FastMath.sqrt((double)(-bigF / bigA));
        if (Double.isNaN(l + (m = FastMath.sqrt((double)(-bigF / bigB))))) {
            return null;
        }
        if (l > m) {
            return new Ellipse(new Vector3D(1.0, planePoint, tauC, u, nuC, v), new Vector3D(cos, u, sin, v), new Vector3D(-sin, u, cos, v), l, m, this.frame);
        }
        return new Ellipse(new Vector3D(1.0, planePoint, tauC, u, nuC, v), new Vector3D(sin, u, -cos, v), new Vector3D(cos, u, sin, v), m, l, this.frame);
    }
}

