/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import java.io.Serializable;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.Precision;
import org.orekit.bodies.CelestialBody;
import org.orekit.bodies.CelestialBodyFactory;
import org.orekit.bodies.IAUPole;
import org.orekit.bodies.JPLEphemeridesLoader;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

class JPLCelestialBody
implements CelestialBody {
    private static final long serialVersionUID = 3809787672779740923L;
    private final String name;
    private final String supportedNames;
    private final JPLEphemeridesLoader.EphemerisType generateType;
    private final transient JPLEphemeridesLoader.RawPVProvider rawPVProvider;
    private final double gm;
    private final double scale;
    private final IAUPole iauPole;
    private final Frame inertialFrame;
    private final Frame bodyFrame;

    public JPLCelestialBody(String name, String supportedNames, JPLEphemeridesLoader.EphemerisType generateType, JPLEphemeridesLoader.RawPVProvider rawPVProvider, double gm, double scale, IAUPole iauPole, Frame definingFrameAlignedWithICRF) {
        this.name = name;
        this.gm = gm;
        this.scale = scale;
        this.supportedNames = supportedNames;
        this.generateType = generateType;
        this.rawPVProvider = rawPVProvider;
        this.iauPole = iauPole;
        this.inertialFrame = new InertiallyOriented(definingFrameAlignedWithICRF);
        this.bodyFrame = new BodyOriented();
    }

    @Override
    public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) throws OrekitException {
        PVCoordinates rawPV = this.rawPVProvider.getRawPV(date);
        TimeStampedPVCoordinates scaledPV = new TimeStampedPVCoordinates(date, this.scale, rawPV);
        Transform transform = this.getInertiallyOrientedFrame().getParent().getTransformTo(frame, date);
        return transform.transformPVCoordinates(scaledPV);
    }

    private Object writeReplace() {
        return new DTOCelestialBody(this.supportedNames, this.generateType, this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getGM() {
        return this.gm;
    }

    @Override
    public Frame getInertiallyOrientedFrame() {
        return this.inertialFrame;
    }

    @Override
    public Frame getBodyOrientedFrame() {
        return this.bodyFrame;
    }

    private static class DTOBodyFrame
    extends DataTransferObject {
        private static final long serialVersionUID = -3194195019557081000L;

        public DTOBodyFrame(String supportedNames, JPLEphemeridesLoader.EphemerisType generateType, String name) {
            super(supportedNames, generateType, name);
        }

        private Object readResolve() {
            return this.getBody().bodyFrame;
        }
    }

    private static class DTOInertialFrame
    extends DataTransferObject {
        private static final long serialVersionUID = 7915071664444154948L;

        public DTOInertialFrame(String supportedNames, JPLEphemeridesLoader.EphemerisType generateType, String name) {
            super(supportedNames, generateType, name);
        }

        private Object readResolve() {
            return this.getBody().inertialFrame;
        }
    }

    private static class DTOCelestialBody
    extends DataTransferObject {
        private static final long serialVersionUID = -8287341529741045958L;

        public DTOCelestialBody(String supportedNames, JPLEphemeridesLoader.EphemerisType generateType, String name) {
            super(supportedNames, generateType, name);
        }

        private Object readResolve() {
            return this.getBody();
        }
    }

    private static abstract class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 674742836536072422L;
        private final String supportedNames;
        private final JPLEphemeridesLoader.EphemerisType generateType;
        private final String name;

        public DataTransferObject(String supportedNames, JPLEphemeridesLoader.EphemerisType generateType, String name) {
            this.supportedNames = supportedNames;
            this.generateType = generateType;
            this.name = name;
        }

        protected JPLCelestialBody getBody() {
            try {
                JPLCelestialBody jplBody;
                CelestialBody factoryProvided = CelestialBodyFactory.getBody(this.name);
                if (factoryProvided instanceof JPLCelestialBody && this.supportedNames.equals((jplBody = (JPLCelestialBody)factoryProvided).supportedNames) && this.generateType == jplBody.generateType) {
                    return jplBody;
                }
                return (JPLCelestialBody)new JPLEphemeridesLoader(this.supportedNames, this.generateType).loadCelestialBody(this.name);
            }
            catch (OrekitException oe) {
                throw OrekitException.createInternalError(oe);
            }
        }
    }

    private class BodyOriented
    extends Frame {
        private static final long serialVersionUID = -2286454820784307274L;
        private static final String BODY_FRAME_SUFFIX = "/rotating";

        public BodyOriented() {
            super(JPLCelestialBody.this.inertialFrame, new TransformProvider(){
                private static final long serialVersionUID = 5973062576520917181L;

                @Override
                public Transform getTransform(AbsoluteDate date) throws OrekitException {
                    double dt = 10.0;
                    double w0 = JPLCelestialBody.this.iauPole.getPrimeMeridianAngle(date);
                    double w1 = JPLCelestialBody.this.iauPole.getPrimeMeridianAngle(date.shiftedBy(10.0));
                    return new Transform(date, new Rotation(Vector3D.PLUS_K, -w0), new Vector3D((w1 - w0) / 10.0, Vector3D.PLUS_K));
                }
            }, JPLCelestialBody.this.name + BODY_FRAME_SUFFIX, false);
        }

        private Object writeReplace() {
            return new DTOBodyFrame(JPLCelestialBody.this.supportedNames, JPLCelestialBody.this.generateType, JPLCelestialBody.this.name);
        }
    }

    private class InertiallyOriented
    extends Frame {
        private static final long serialVersionUID = -8849993808761896559L;
        private static final String INERTIAL_FRAME_SUFFIX = "/inertial";

        public InertiallyOriented(final Frame definingFrame) {
            super(definingFrame, new TransformProvider(){
                private static final long serialVersionUID = -8610328386110652400L;

                @Override
                public Transform getTransform(AbsoluteDate date) throws OrekitException {
                    TimeStampedPVCoordinates pv = JPLCelestialBody.this.getPVCoordinates(date, definingFrame);
                    Transform translation = new Transform(date, pv.negate());
                    Vector3D pole = JPLCelestialBody.this.iauPole.getPole(date);
                    Vector3D qNode = Vector3D.crossProduct((Vector3D)Vector3D.PLUS_K, (Vector3D)pole);
                    if (qNode.getNormSq() < Precision.SAFE_MIN) {
                        qNode = Vector3D.PLUS_I;
                    }
                    Transform rotation = new Transform(date, new Rotation(pole, qNode, Vector3D.PLUS_K, Vector3D.PLUS_I));
                    return new Transform(date, translation, rotation);
                }
            }, JPLCelestialBody.this.name + INERTIAL_FRAME_SUFFIX, true);
        }

        private Object writeReplace() {
            return new DTOInertialFrame(JPLCelestialBody.this.supportedNames, JPLCelestialBody.this.generateType, JPLCelestialBody.this.name);
        }
    }
}

