/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import java.io.Serializable;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.oned.Vector1D;
import org.apache.commons.math3.geometry.euclidean.threed.Line;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.Ellipse;
import org.orekit.bodies.Ellipsoid;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;

public class OneAxisEllipsoid
extends Ellipsoid
implements BodyShape {
    private static final long serialVersionUID = 20130518L;
    private final Frame bodyFrame;
    private final double ae2;
    private final double f;
    private final double e2;
    private final double g;
    private final double g2;
    private double angularThreshold;

    public OneAxisEllipsoid(double ae, double f, Frame bodyFrame) {
        super(bodyFrame, ae, ae, ae * (1.0 - f));
        this.f = f;
        this.ae2 = ae * ae;
        this.e2 = f * (2.0 - f);
        this.g = 1.0 - f;
        this.g2 = this.g * this.g;
        this.setAngularThreshold(1.0E-12);
        this.bodyFrame = bodyFrame;
    }

    public void setAngularThreshold(double angularThreshold) {
        this.angularThreshold = angularThreshold;
    }

    public double getEquatorialRadius() {
        return this.getA();
    }

    public double getFlattening() {
        return this.f;
    }

    @Override
    public Frame getBodyFrame() {
        return this.bodyFrame;
    }

    @Override
    public GeodeticPoint getIntersectionPoint(Line line, Vector3D close, Frame frame, AbsoluteDate date) throws OrekitException {
        double c;
        double cz2;
        double a;
        double ac;
        double dz;
        double dy;
        Transform frameToBodyFrame = frame.getTransformTo(this.bodyFrame, date);
        Line lineInBodyFrame = frameToBodyFrame.transformLine(line);
        Vector3D closeInBodyFrame = frameToBodyFrame.transformPosition(close);
        double closeAbscissa = lineInBodyFrame.toSubSpace((Vector)closeInBodyFrame).getX();
        Vector3D point = lineInBodyFrame.getOrigin();
        double x = point.getX();
        double y = point.getY();
        double z = point.getZ();
        double z2 = z * z;
        double r2 = x * x + y * y;
        Vector3D direction = lineInBodyFrame.getDirection();
        double dx = direction.getX();
        double b = -(this.g2 * (x * dx + y * (dy = direction.getY())) + z * (dz = direction.getZ()));
        double b2 = b * b;
        if (b2 < (ac = (a = 1.0 - this.e2 * (cz2 = dx * dx + dy * dy)) * (c = this.g2 * (r2 - this.ae2) + z2))) {
            return null;
        }
        double s = FastMath.sqrt((double)(b2 - ac));
        double k1 = b < 0.0 ? (b - s) / a : c / (b + s);
        double k2 = c / (a * k1);
        double k = FastMath.abs((double)(k1 - closeAbscissa)) < FastMath.abs((double)(k2 - closeAbscissa)) ? k1 : k2;
        Vector3D intersection = lineInBodyFrame.toSpace((Vector)new Vector1D(k));
        double ix = intersection.getX();
        double iy = intersection.getY();
        double iz = intersection.getZ();
        double lambda = FastMath.atan2((double)iy, (double)ix);
        double phi = FastMath.atan2((double)iz, (double)(this.g2 * FastMath.sqrt((double)(ix * ix + iy * iy))));
        return new GeodeticPoint(phi, lambda, 0.0);
    }

    @Override
    public Vector3D transform(GeodeticPoint point) {
        double longitude = point.getLongitude();
        double cLambda = FastMath.cos((double)longitude);
        double sLambda = FastMath.sin((double)longitude);
        double latitude = point.getLatitude();
        double cPhi = FastMath.cos((double)latitude);
        double sPhi = FastMath.sin((double)latitude);
        double h = point.getAltitude();
        double n = this.getA() / FastMath.sqrt((double)(1.0 - this.e2 * sPhi * sPhi));
        double r = (n + h) * cPhi;
        return new Vector3D(r * cLambda, r * sLambda, (this.g2 * n + h) * sPhi);
    }

    @Override
    public Vector3D projectToGround(Vector3D point, AbsoluteDate date, Frame frame) throws OrekitException {
        Transform toBody = frame.getTransformTo(this.bodyFrame, date);
        Vector3D p = toBody.transformPosition(point);
        double z = p.getZ();
        double r = FastMath.hypot((double)p.getX(), (double)p.getY());
        Ellipse meridian = new Ellipse(Vector3D.ZERO, new Vector3D(p.getX() / r, p.getY() / r, 0.0), Vector3D.PLUS_K, this.getA(), this.getC(), this.bodyFrame);
        Vector3D groundPoint = meridian.toSpace(meridian.projectToEllipse(new Vector2D(r, z)));
        return toBody.getInverse().transformPosition(groundPoint);
    }

    @Override
    public TimeStampedPVCoordinates projectToGround(TimeStampedPVCoordinates pv, Frame frame) throws OrekitException {
        Transform toBody = frame.getTransformTo(this.bodyFrame, pv.getDate());
        TimeStampedPVCoordinates pvInBodyFrame = toBody.transformPVCoordinates(pv);
        Vector3D p = pvInBodyFrame.getPosition();
        double r = FastMath.hypot((double)p.getX(), (double)p.getY());
        Vector3D meridian = new Vector3D(p.getX() / r, p.getY() / r, 0.0);
        Ellipse firstPrincipalCurvature = new Ellipse(Vector3D.ZERO, meridian, Vector3D.PLUS_K, this.getA(), this.getC(), this.bodyFrame);
        TimeStampedPVCoordinates gpFirst = firstPrincipalCurvature.projectToEllipse(pvInBodyFrame);
        Vector3D gpP = gpFirst.getPosition();
        double gr = MathArrays.linearCombination((double)gpP.getX(), (double)meridian.getX(), (double)gpP.getY(), (double)meridian.getY());
        double gz = gpP.getZ();
        Vector3D east = new Vector3D(-meridian.getY(), meridian.getX(), 0.0);
        Vector3D zenith = new Vector3D(gr * this.getC() / this.getA(), meridian, gz * this.getA() / this.getC(), Vector3D.PLUS_K).normalize();
        Vector3D north = Vector3D.crossProduct((Vector3D)zenith, (Vector3D)east);
        Ellipse secondPrincipalCurvature = this.getPlaneSection(gpP, north);
        TimeStampedPVCoordinates gpSecond = secondPrincipalCurvature.projectToEllipse(pvInBodyFrame);
        Vector3D gpV = gpFirst.getVelocity().add((Vector)gpSecond.getVelocity());
        Vector3D gpA = gpFirst.getAcceleration().add((Vector)gpSecond.getAcceleration());
        TimeStampedPVCoordinates groundPV = new TimeStampedPVCoordinates(pv.getDate(), gpP, gpV, gpA);
        return toBody.getInverse().transformPVCoordinates(groundPV);
    }

    @Override
    public GeodeticPoint transform(Vector3D point, Frame frame, AbsoluteDate date) throws OrekitException {
        Vector3D pointInBodyFrame = frame.getTransformTo(this.bodyFrame, date).transformPosition(point);
        double r2 = pointInBodyFrame.getX() * pointInBodyFrame.getX() + pointInBodyFrame.getY() * pointInBodyFrame.getY();
        double r = FastMath.sqrt((double)r2);
        double z = pointInBodyFrame.getZ();
        Ellipse meridian = new Ellipse(Vector3D.ZERO, new Vector3D(pointInBodyFrame.getX() / r, pointInBodyFrame.getY() / r, 0.0), Vector3D.PLUS_K, this.getA(), this.getC(), this.bodyFrame);
        Vector2D ellipsePoint = meridian.projectToEllipse(new Vector2D(r, z));
        double dr = r - ellipsePoint.getX();
        double dz = z - ellipsePoint.getY();
        double insideIfNegative = this.g2 * (r2 - this.ae2) + z * z;
        return new GeodeticPoint(FastMath.atan2((double)ellipsePoint.getY(), (double)(this.g2 * ellipsePoint.getX())), FastMath.atan2((double)pointInBodyFrame.getY(), (double)pointInBodyFrame.getX()), FastMath.copySign((double)FastMath.hypot((double)dr, (double)dz), (double)insideIfNegative));
    }

    private Object writeReplace() {
        return new DataTransferObject(this.getA(), this.f, this.bodyFrame, this.angularThreshold);
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20130518L;
        private final double ae;
        private final double f;
        private final Frame bodyFrame;
        private final double angularThreshold;

        public DataTransferObject(double ae, double f, Frame bodyFrame, double angularThreshold) {
            this.ae = ae;
            this.f = f;
            this.bodyFrame = bodyFrame;
            this.angularThreshold = angularThreshold;
        }

        private Object readResolve() {
            OneAxisEllipsoid ellipsoid = new OneAxisEllipsoid(this.ae, this.f, this.bodyFrame);
            ellipsoid.setAngularThreshold(this.angularThreshold);
            return ellipsoid;
        }
    }
}

