/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.math3.exception.util.DummyLocalizable;
import org.apache.commons.math3.exception.util.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.TimeStamped;

public class SimpleTimeStampedTableParser<T extends TimeStamped> {
    private static final String REAL_TYPE_PATTERN = "[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?";
    private final int columns;
    private final RowConverter<T> converter;

    public SimpleTimeStampedTableParser(int columns, RowConverter<T> converter) {
        this.columns = columns;
        this.converter = converter;
    }

    public List<T> parse(InputStream stream, String name) throws OrekitException {
        if (stream == null) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_FILE, name);
        }
        StringBuilder builder = new StringBuilder("^\\p{Space}*");
        for (int i = 0; i < this.columns; ++i) {
            builder.append("(");
            builder.append(REAL_TYPE_PATTERN);
            builder.append(")");
            builder.append(i < this.columns - 1 ? "\\p{Space}+" : "\\p{Space}*$");
        }
        Pattern regularLinePattern = Pattern.compile(builder.toString());
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            ArrayList<T> table = new ArrayList<T>();
            String line = reader.readLine();
            while (line != null) {
                Matcher regularMatcher = regularLinePattern.matcher(line = line.replace('\u2212', '-'));
                if (regularMatcher.matches()) {
                    double[] rawFields = new double[this.columns];
                    for (int i = 0; i < this.columns; ++i) {
                        rawFields[i] = Double.parseDouble(regularMatcher.group(i + 1));
                    }
                    table.add(this.converter.convert(rawFields));
                }
                line = reader.readLine();
            }
            if (table.isEmpty()) {
                throw new OrekitException((Localizable)OrekitMessages.NOT_A_SUPPORTED_IERS_DATA_FILE, name);
            }
            return table;
        }
        catch (IOException ioe) {
            throw new OrekitException(ioe, (Localizable)new DummyLocalizable(ioe.getMessage()), new Object[0]);
        }
    }

    public static interface RowConverter<S extends TimeStamped> {
        public S convert(double[] var1) throws OrekitException;
    }
}

